# aclocal.m4 generated automatically by aclocal 1.4c

# Copyright 1994, 1995, 1996, 1997, 1998, 1999, 2000
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

AC_DEFUN(GST_CHECK_PROG, [
  AC_CHECK_PROG([$1], [$2], [$2], ifelse([$3], , $ac_aux_dir/missing [$2], [$3]))
])dnl

AC_DEFUN(GST_DOUBLE_ALIGNMENT, [

AC_CACHE_CHECK(for double alignment, gst_cv_double_alignment, [
AC_TRY_RUN([
  main()
  {
    long vec[3];
    double test, *testptr;

    test = *(double *)&vec[1];  /* Should not be double aligned */
    testptr = (double *)&vec[1];
    *testptr = test;
    exit(0);
  }],
  gst_cv_double_alignment=SIZEOF_CHAR_P,
  gst_cv_double_alignment="2 * SIZEOF_CHAR_P",
  gst_cv_double_alignment="2 * SIZEOF_CHAR_P")     dnl Assume the worst
])

AC_DEFINE_UNQUOTED(DOUBLE_ALIGNMENT, $gst_cv_double_alignment, [Define this with the memory alignment required by type "double".])

])dnl

AC_DEFUN(GST_C_SIGNED, [

AC_CACHE_CHECK(for signed, gst_cv_c_signed,
[AC_TRY_COMPILE(, [signed int x; ],
    gst_cv_c_signed=yes, gst_cv_c_signed=no)
])
test $gst_cv_c_signed = no && \
AC_DEFINE_UNQUOTED(signed, , [Define as empty if the C compiler doesn't support it.])

])dnl

AC_DEFUN(GST_C_GOTO_VOID_P, [

AC_CACHE_CHECK(for goto void *, gst_cv_c_goto_void_p,
[AC_TRY_COMPILE(, [
    void *x = &&label;
    goto *x;
    label: ],
    gst_cv_c_goto_void_p=yes, gst_cv_c_goto_void_p=no)
])
test $gst_cv_c_goto_void_p = yes && \
AC_DEFINE(HAVE_GOTO_VOID_P, 1, [Define if your CC has the `&&' and `goto void *' GCC extensions.])

])dnl

AC_DEFUN(GST_C_OLDCC, [

AC_CACHE_CHECK(for old ANSI CC (no void *), gst_cv_c_oldcc,
[AC_TRY_COMPILE(, [void *x; ],
    gst_cv_c_oldcc=no, gst_cv_c_oldcc=yes)
])
test $gst_cv_c_oldcc = yes && \
AC_DEFINE(OLDCC, 1, [Define if the C compiler doesn't support void * and enums.])

])dnl

AC_DEFUN(GST_C_SYMBOLSET, [

# This test outputs the list of symbols which /bin/cc or /lib/cpp
# define and which we had the foresight to guess at.  When
# cross-compiling, we only consider /lib/cpp.
AC_CACHE_CHECK(builtin preprocessor symbol set, gst_cv_machine_defines,
[   syms="AMIX BIT_MSF BSD BSD4_3 BSD_NET2 CMU CRAY DGUX DJGPP DOLPHIN DPX2 \
	GO32 GOULD_PN HP700 I386 I80960 I960 Lynx M68000 M68K MACH \
	MIPSEB MIPSEL MSDOS MTXINU MULTIMAX MVS \
	M_COFF M_I186 M_I286 M_I386 M_I8086 M_I86 M_I86SM \
	M_SYS3 M_SYS5 M_SYSIII M_SYSV M_UNIX M_XENIX \
	NeXT OCS88 OSF1 PARISC PC532 PORTAR POSIX \
	PWB R3000 RES RISC6000 RT Sun386i SVR3 SVR4 \
	SYSTYPE_BSD SYSTYPE_SVR4 SYSTYPE_SYSV Tek4132 Tek4300 \
	UMAXV USGr4 USGr4_2 UTEK UTS UTek UnicomPBB UnicomPBD Utek \
	VMS WIN32 Xenix286 \
	_AIX _AIX32 _AIX370 _AM29000 _COFF _CRAY _CX_UX _EPI \
	_IBMESA _IBMR2 _M88K _M88KBCS_TARGET \
	_MIPSEB _MIPSEL _M_COFF _M_I86 _M_I86SM _M_SYS3 \
	_M_SYS5 _M_SYSIII _M_SYSV _M_UNIX _M_XENIX _NLS _PGC_ _R3000 \
	_SYSTYPE_BSD _SYSTYPE_BSD43 _SYSTYPE_SVR4 \
	_SYSTYPE_SYSV _SYSV3 _U370 _UNICOS \
	__386BSD__ __BIG_ENDIAN __BIG_ENDIAN__ __BSD_4_4__ \
	__CYGWIN__ __CYGWIN32__ __DGUX__ __DJGPP__ __DPX2__ __H3050R \
	__H3050RX __LITTLE_ENDIAN __LITTLE_ENDIAN__ __MACH__ _MSC_VER \
	__MIPSEB __MIPSEB__ __MIPSEL __MIPSEL__ __MSDOS__ \
	__Next__ __OS2__ __OSF1__ __PARAGON__ __PGC__ __PWB __STDC__ \
	__SVR4_2__ __UMAXV__ __WIN32__ _WIN32 \
	____386BSD____ __alpha __alpha__ __amiga \
	__bsd4_2 __bsd4_2__ __bsdi__ __convex__ \
	__host_mips__ \
	__hp9000s200 __hp9000s300 __hp9000s400 __hp9000s500 \
	__hp9000s500 __hp9000s700 __hp9000s800 \
	__hppa __hpux __hp_osf __i286 __i286__ __i386 __i386__ \
	__i486 __i486__ __i860 __i860__ __ibmesa __ksr1__ __linux__ \
	__m68k __m68k__ __m88100__ __m88k __m88k__ \
	__mc68000 __mc68000__ __mc68020 __mc68020__ \
	__mc68030 __mc68030__ __mc68040 __mc68040__ \
	__mc88100 __mc88100__ __mips __mips__ \
	__motorola__ __osf__ __pa_risc __sparc__ __stdc__ \
	__sun __sun__ __svr3__ __svr4__ __ultrix __ultrix__ \
	__unix __unix__ __uxpm__ __uxps__ __vax __vax__ \
	_host_mips _mips _unix \
	a29k aegis aix aixpc alliant alpha am29000 amiga \
	ansi ardent apollo ardent att386 att3b \
	bsd bsd43 bsd4_2 bsd4_3 bsd4_4 bsdi bull \
	cadmus clipper concurrent convex cray ctix \
	dmert encore gcos gcx gimpel gould \
	hbullx20 hcx host_mips hp200 hp300 hp700 hp800 \
	hp9000 hp9000s300 hp9000s400 hp9000s500 \
	hp9000s700 hp9000s800 hp9k8 hppa hpux \
	i186 i286 i386 i486 i8086 \
	i80960 i860 iAPX286 ibm ibm032 ibmrt interdata is68k \
	ksr1 linux luna luna88k m68k m88100 m88k \
	mc300 mc500 mc68000 mc68010 mc68020 mc68030 \
	mc68040 mc68060 mc68k mc68k32 mc700 \
	mc88000 mc88100 merlin mert mips mvs n16 \
	ncl_el ncl_mr \
	news1500 news1700 news1800 news1900 news3700 \
	news700 news800 news900 ns16000 ns32000 \
	ns32016 ns32332 ns32k nsc32000 os osf \
	parisc pc532 pdp11 plexus posix pyr \
	riscix riscos scs sequent sgi sinix sony sony_news \
	sonyrisc sparc sparclite spectrum stardent stratos \
	sun sun3 sun386 svr4 sysV68 sysV88 \
	titan tower tower32 tower32_200 tower32_600 tower32_700 \
	tower32_800 tower32_850 tss u370 u3b u3b2 u3b20 u3b200 \
	u3b20d u3b5 ultrix unix unixpc unos vax venix vms \
	xenix z8000"

   if test $cross_compiling != yes; then
      # Some cpp's do not define any symbols, but instead let /bin/cc do it
      # for them.  For such machines, not using CPP to run this test (instead
      # creating a program which printf's them to stdout) may prove useful.
      (echo "#include <stdio.h>"			;\
      echo "main ()" 					;\
      echo "{"						;\
      Q=\\\"						;\
      for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "  printf(\"$Q$i$Q, \");"			;\
	echo "#endif"					;\
      done						;\
      echo "  printf (\"\n\");"				;\
      echo "  exit (0);"				;\
      echo "}")						>conftest.$ac_ext

      dnl Stolen from AC_TRY_RUN's definition
      AC_TRY_EVAL(ac_link) && gst_cv_machine_defines=`./conftest 2>/dev/null`
    fi
    if test -z "$gst_cv_machine_defines"; then
      (for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "\"$i\","					;\
	echo "#endif"					;\
      done)						>conftest.$ac_ext

      gst_cv_machine_defines=`(eval "$ac_cpp conftest.$ac_ext") | grep ","`
    fi
    rm -rf conftest*
])

test -z "$gst_cv_machine_defines" && gst_cv_machine_defines='"unknown", '

AC_DEFINE_UNQUOTED(MACHINE_DEFINES, $gst_cv_machine_defines,
[The set of builtin preprocessor symbols which are defined in the current environment.])

])dnl

AC_DEFUN(GST_C_VARARGS, [

AC_CHECK_HEADERS(stdarg.h)

AC_CACHE_CHECK(whether va_arg(..., char) works, gst_cv_working_va_arg, [
  AC_TRY_LINK([
#ifdef HAVE_STDARG_H
# include <stdarg.h>
#else
# include <varargs.h>
#endif

#ifdef HAVE_STDARG_H
int testfunc (int test, ...)
#else
int testfunc (va_alist)
     va_dcl
#endif
{
  va_list	args;
  char          test2;
  
#ifdef HAVE_STDARG_H
  va_start(args, test);
#else
  int		test;
  
  va_start(args);
  test = va_arg(args, int);
#endif

  test = va_arg(args, char);
  
}], [
  testfunc(5, '3');
  return 0;
],
	      gst_cv_working_va_arg=yes,
	      gst_cv_working_va_arg=no)
])

test $gst_cv_working_va_arg = no && \
AC_DEFINE(PICKY_VA_ARG, 1, [Define if your system does not support va_arg(..., char)])

])dnl

AC_DEFUN(GST_FUNC_WAITPID, [
AC_REQUIRE([AC_HEADER_SYS_WAIT])
AC_CHECK_FUNCS(wait wait3 waitpid)
# Check whether we have no waitpid, but we can emulate it
if test $ac_cv_func_waitpid = no; then
  if test $ac_cv_func_wait = yes || test $ac_cv_func_wait3 = yes; then
    LIBOBJS="$LIBOBJS waitpid.o"
    AC_DEFINE(HAVE_WAITPID)
  fi
fi


])dnl

AC_DEFUN(GST_FUNC_OBSTACK, [

AC_CACHE_CHECK(for obstacks, am_cv_func_obstack, [
  AC_TRY_LINK([#include "obstack.h"],
	      [struct obstack *mem;obstack_free(mem,(char *) 0)],
	      am_cv_func_obstack=yes,
	      am_cv_func_obstack=no)
])
if test $am_cv_func_obstack = yes; then
  AC_DEFINE(HAVE_OBSTACK, 1, [Define if you have the obstack function.])
else
  LIBOBJS="$LIBOBJS obstack.o"
fi

])dnl

AC_DEFUN(GST_INET_SOCKETS, [

AC_CHECK_LIB(socket, listen)
AC_CHECK_LIB(nsl, gethostbyname)

ok_so_far=yes
AC_CHECK_FUNC(socket, , ok_so_far=no)
AC_CHECK_HEADER(netinet/in.h, , ok_so_far=no)
AC_CHECK_HEADER(arpa/inet.h, , ok_so_far=no)
test $ok_so_far = yes && \
AC_DEFINE(HAVE_INET_SOCKETS, 1, [Define if your system's sockets provide access to the Internet.])


])dnl

AC_DEFUN(GST_FUNC_STRTOUL, [

# Check for strtoul.  Under some versions of AIX, strtoul returns
# an incorrect terminator pointer for the string "0".
AC_CACHE_CHECK(for strtoul, gst_cv_working_strtoul, [
  exec AS_MESSAGE_FD>/dev/null
  AC_CHECK_FUNC(strtoul, gst_cv_working_strtoul=yes, gst_cv_working_strtoul=no)
  if test $gst_cv_working_strtoul = yes; then
    AC_TRY_RUN([
      extern int strtoul();
      int main()
      {
	char *string = "0";
	char *term;
	int value;
	value = strtoul(string, &term, 0);
	exit((value != 0) || (term != (string+1)));
      }], ,
      [gst_cv_working_strtoul="yes, but broken"],
      [gst_cv_working_strtoul="yes, but cross-compiling"])
  fi
  test "$silent" != yes && exec AS_MESSAGE_FD>&1
])

test "$gst_cv_working_strtoul" != yes && LIBOBJS="$LIBOBJS strtoul.o"

])dnl

AC_DEFUN(GST_FUNC_LOCALTIME, [

AC_CACHE_CHECK(whether localtime caches the timezone, emacs_cv_localtime_cache,
[AC_REQUIRE([AC_HEADER_TIME])
AC_TRY_RUN(
    [#if defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <sys/time.h>
    #endif
    #if !defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <time.h>
    #endif
    #if STDC_HEADERS
    # include <stdlib.h>
    #endif

    extern char **environ;
    unset_TZ ()
    {
      char **from, **to;
      for (to = from = environ; (*to = *from); from++)
        if (! (to[0][0] == 'T' && to[0][1] == 'Z' && to[0][2] == '='))
          to++;
    }
    char TZ_GMT0[] = "TZ=GMT0";
    char TZ_PST8[] = "TZ=PST8";
    main()
    {
      time_t now = time ((time_t *) 0);
      int hour_GMT0, hour_unset;
      if (putenv (TZ_GMT0) != 0)
        exit (1);
      hour_GMT0 = localtime (&now)->tm_hour;
      unset_TZ ();
      hour_unset = localtime (&now)->tm_hour;
      if (putenv (TZ_PST8) != 0)
        exit (1);
      if (localtime (&now)->tm_hour == hour_GMT0)
        exit (1);
      unset_TZ ();
      if (localtime (&now)->tm_hour != hour_unset)
        exit (1);
      exit (0);
    }],
    emacs_cv_localtime_cache=no, emacs_cv_localtime_cache=yes,

    [# Assume the worst when cross-compiling.
    emacs_cv_localtime_cache=yes])
])
test $emacs_cv_localtime_cache = yes && \
AC_DEFINE(LOCALTIME_CACHE, 1, [Define if your system's localtime(3) caches the timezone.])

])dnl

AC_DEFUN(GST_KIND_DLD, [

# Test even if we don't use dynamic loading
AC_MSG_CHECKING(which dynamic loading API is to be used)
exec AS_MESSAGE_FD>/dev/null

AC_ARG_WITH(dld, 
[  --with-dld=path         set path to dynamic linking libraries
  --without-dld      	  don't look for a way to enable dynamic linking])


test "$with_dld" && test -d "$with_dld" && LDFLAGS="$LDFLAGS -L$with_dld"

which=
# for syntax is: Header Library Function Result
DLD_MODULE=none
test $PLATFORM = win32 && DLD_MODULE=win32
for item in	ltdl.h ltdl lt_dlopenext ltdl		\
		dlfcn.h dl dlopen libdl			\
		dl.h dld shl_load hpux			\
  		dld.h dld dld_get_func gnu		\
		ldfcn.h ld load aix			; do
  which=x$which
  case $which in
    x)    header=$item ;;
    xx)   lib=$item ;;
    xxx)  func=$item ;;
    xxxx) which=
      AC_CHECK_HEADER($header, [
	AC_CHECK_LIB($lib, $func, [
	  LIBS="$LIBS -l$lib" DLD_MODULE=$item
	  break
        ])
      ]) ;;
  esac
done

test "$silent" != yes && exec AS_MESSAGE_FD>&1
AC_MSG_RESULT($DLD_MODULE)

DLD_MODULE=dld_$DLD_MODULE
test "$with_dld" = no && DLD_MODULE=dld_none
if test "$DLD_MODULE" != dld_none; then
  AC_DEFINE(HAVE_DLD, 1, [Define if your system's dynamic loading method is supported.])
  AC_CACHE_CHECK(for leading _ in shared libraries, gst_cv_dlsym_underscore,
    path_to_libc=`ls /lib/lib*c.so /usr/lib/lib*c.so \
	     /lib/lib*c.sl /usr/lib/lib*c.sl \
             /bin/cygwin*.dll /gnuwin32/cygwin*.dll \
             /lib/lib*c.a* /usr/lib/lib*c.a 2> /dev/null | head -1`

    AC_TRY_RUN([
      #ifdef OLDCC
      typedef char *voidPtr;
      #else
      typedef void *voidPtr;
      #endif
      #define __GSTDLD__			/* avoid including dld_gst.h */
      #include "$srcdir/lib/$DLD_MODULE.c"	/* include the wrappers here */
      main(argc, argv)
           int	argc;
           char	**argv;
      {
	voidPtr lib;
	gst_dld_init(*argv);
	lib = gst_dld_open("$path_to_libc");
	exit(gst_dld_sym(lib, "printf") != NULL);
      }], gst_cv_dlsym_underscore=no, gst_cv_dlsym_underscore=yes
  ))

  if test "$gst_cv_dlsym_underscore" = yes; then
    AC_DEFINE(NEED_DLSYM_UNDERSCORE, 1,
              [Define if your system's dynamic loading method needs a _ to be prepended to the function name.])
  fi
fi

AC_SUBST(DLD_MODULE)
])dnl

AC_DEFUN(GST_HAVE_TCLTK, [

if test $PLATFORM = unix; then
  AC_REQUIRE([AC_PATH_XTRA])dnl
  echo > /dev/null		# dummy
fi
AC_CACHE_CHECK(how to link with Tcl/Tk 8.0, gst_cv_tcltk_libs, [
  exec AS_MESSAGE_FD>/dev/null

  gst_cv_tcltk_libs="not found"
  # Newer versions are preferred
  for lib in 8.2 82 8.1 81 8.0 80 ""; do
    AC_CHECK_LIB(tcl$lib, Tcl_ObjSetVar2, [
      tcl_libs=-ltcl$lib
      if test $PLATFORM = unix; then
        test have_x=yes || break
        tcl_libs="$tcl_libs $X_PRE_LIBS -lX11 $X_LIBS $X_EXTRA_LIBS"
      fi
      AC_CHECK_LIB(tk$lib, Tk_Init,
        [gst_cv_tcltk_libs="$tcl_libs -ltk$lib"
        break], ,
        $tcl_libs)
    ])
  done
  tcl_libs=
  test "$silent" != yes && exec AS_MESSAGE_FD>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  TCL_LIBS="$gst_cv_tcltk_libs"
  AC_DEFINE(HAVE_TCLTK, 1, [Define if your system has Tcl/Tk, 8.0 or later, installed.])
fi


AC_SUBST(TCL_LIBS)
AC_SUBST(X_CFLAGS)
AC_SUBST(X_EXTRA_LIBS)
AC_SUBST(X_LIBS)
AC_SUBST(X_PRE_LIBS)
])dnl

AC_DEFUN(GST_HAVE_READLINE, [

AC_ARG_WITH(readline, 
	[  --with-readline=path    set path to readline and termcap libraries
  --without-readline      don't try to detect readline])


AC_CACHE_CHECK(how to link with readline, gst_cv_readline_libs, [
if test "$with_readline" != no; then
  test "$with_readline" && test -d "$with_readline" && \
    LDFLAGS="$LDFLAGS -L$with_readline"
  gst_cv_readline_libs="not found"
  ac_save_LIBS="$LIBS"
  for lib in "" -ltermcap -ltermlib -lncurses; do
    LIBS="$ac_save_LIBS -lreadline $lib"
    AC_TRY_LINK(
      [#include <stdio.h>
      #include <readline/readline.h>],
      [char *l = readline("")],
      [gst_cv_readline_libs="-lreadline $lib"
      break])
  done
  LIBS="$ac_save_LIBS"
fi])

if test "$gst_cv_readline_libs" != "not found"; then
  LIBS="$LIBS $gst_cv_readline_libs"
  AC_DEFINE(HAVE_READLINE, 1, [Define this if you want the ultra-winning GNU readline library to be present in the command reader.])
fi

])dnl

