/******************************** -*- C -*- ****************************
 *
 *	Symbol Table declarations
 *
 *	$Revision: 1.7.5$
 *	$Date: 2000/05/28 16:56:52$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTSYM__
#define __GSTSYM__

#define SYMBOL_TABLE_SIZE	521

/* Uncomment this to enable profiling of the symbol table */
/*#define symbol_table_profiling */

typedef enum {
  temporaryScope,
  receiverScope,
  poolScope,
  globalScope
} ScopeType;



typedef struct SymbolStruct {
  OBJ_HEADER;			/* I love inheritance */
  char		symString[1];
} *Symbol;

typedef struct SymbolEntryStruct {
  ScopeType	scope;
  OOP		symbol;
  int		varIndex;	/* index of receiver or temporary */
  unsigned int	scopeDistance;	/* how many frames up the stack is this
				   variable from where we are? */
} *SymbolEntry;

typedef struct SymbolInfoStruct {
  OOP		*symbolVar;
  char		*value;
} SymbolInfo;

extern long		useUndeclared;

extern SymbolEntry	findVariable();

extern OOP		atColonSymbol, atColonPutColonSymbol, sizeSymbol,
			nextSymbol, nextPutColonSymbol, atEndSymbol, 
  			classSymbol, blockCopyColonSymbol, 
			valueSymbol, isNilSymbol, notNilSymbol,
			valueColonValueColonSymbol, uppercaseSuperSymbol,
			valueColonValueColonValueColonSymbol,
 			valueWithArgumentsColonSymbol,
			valueColonSymbol, doColonSymbol, newSymbol,
			newColonSymbol, plusSymbol, minusSymbol,
			lessThanSymbol, greaterThanSymbol, lessEqualSymbol,
			greaterEqualSymbol, equalSymbol, notEqualSymbol,
			toColonDoColonSymbol, timesSymbol,
			toColonByColonDoColonSymbol, repeatSymbol,
			timesRepeatColonSymbol, divideSymbol, remainderSymbol,
			bitShiftColonSymbol, integerDivideSymbol,
			bitAndColonSymbol, bitOrColonSymbol, sameObjectSymbol,
  			notSameObjectSymbol, finalizeSymbol, yourselfSymbol,
  			whileTrueColonSymbol, whileFalseColonSymbol,
 			whileFalseSymbol, whileTrueSymbol,
			ifTrueColonSymbol, ifFalseColonSymbol, 
			ifTrueColonIfFalseColonSymbol,
  			ifFalseColonIfTrueColonSymbol, andColonSymbol,
			selfSymbol, superSymbol, trueSymbol,
  			falseSymbol, nilSymbol, orColonSymbol,
			doesNotUnderstandColonSymbol, unknownSymbol,
			charSymbol, stringSymbol, stringOutSymbol, 
			symbolSymbol, intSymbol, longSymbol, floatSymbol,
			doubleSymbol, booleanSymbol, undeclaredSymbol,
			voidSymbol, variadicSymbol, cObjectSymbol,
			cObjectPtrSymbol, smalltalkSymbol, symbolTable,
			thisContextSymbol, byteArraySymbol, byteArrayOutSymbol,
			terminateSymbol,
			
			currentNamespace;

extern SymbolInfo	symbolInfo[];

extern OOP		internString(),
  			makeInstanceVariableArray(),
			makeClassVariableDictionary(),
			makePoolArray(), 
			internStringOOP();

extern char		*symbolAsString();

extern unsigned long	hashString();

extern int		stringOOPLen(), getArgCount(), getTempCount(),
			declareArguments(), declareTemporaries(),
			declareBlockArguments(), declareName(),
			selectorNumArgs();

extern void		printString(), printSymbol(), undeclareName(),
			pushNewScope(), scopeReturnsFromMethod(),
			freeSymbolEntry(), popOldScope();

#endif /* __GSTSYM__ */
