#!/bin/bash
#
# dodiff.sh
# Written by Richard Dawe <richdawe@bigfoot.com> 2003-04-20
#
# Generate a diff between unpatched and patched sources, with the ability
# to cope with renamed & added files.
#
# This version is for the port of libtool 1.5 to DJGPP.
#

SRCDIR=/dev/c/develop/ports/orig/libtool-1.5
DSTDIR=/dev/c/develop/ports/gnu.dev/libtool-1.5

# Files that have the same name under $srcdir as $dstdir
NORMAL="
configure
libltdl/configure
cdemo/configure
demo/configure
depdemo/configure
mdemo/configure
tagdemo/configure
f77demo/configure
pdemo/configure.ac
pdemo/configure
pdemo/Makefile.am
pdemo/Makefile.in
tests/Makefile.am
tests/Makefile.in
"

# Files that have been renamed in $dstdir compared with $srcdir
# Syntax: <old-name>:<new-name>
RENAMED="
tests/build-relink.test:tests/bldrlnk.test
tests/build-relink2.test:tests/bldrlnk2.test
tests/cdemo-conf.test:tests/cd-conf.test
tests/cdemo-exec.test:tests/cd-exec.test
tests/cdemo-make.test:tests/cd-make.test
tests/cdemo-shared.test:tests/cd-shared.test
tests/cdemo-static.test:tests/cd-static.test
tests/demo-conf.test:tests/d-conf.test
tests/demo-exec.test:tests/d-exec.test
tests/demo-inst.test:tests/d-inst.test
tests/demo-make.test:tests/d-make.test
tests/demo-nofast.test:tests/d-nofast.test
tests/demo-nopic.test:tests/d-nopic.test
tests/demo-pic.test:tests/d-pic.test
tests/demo-shared.test:tests/d-shared.test
tests/demo-static.test:tests/d-static.test
tests/demo-unst.test:tests/d-unst.test
tests/depdemo-conf.test:tests/depd-conf.test
tests/depdemo-exec.test:tests/depd-exec.test
tests/depdemo-inst.test:tests/depd-inst.test
tests/depdemo-make.test:tests/depd-make.test
tests/depdemo-nofast.test:tests/depd-nofast.test
tests/depdemo-shared.test:tests/depd-shared.test
tests/depdemo-static.test:tests/depd-static.test
tests/depdemo-unst.test:tests/depd-unst.test
tests/f77demo-conf.test:tests/f77d-conf.test
tests/f77demo-exec.test:tests/f77d-exec.test
tests/f77demo-make.test:tests/f77d-make.test
tests/f77demo-shared.test:tests/f77d-shared.test
tests/f77demo-static.test:tests/f77d-static.test
tests/mdemo-conf.test:tests/md-conf.test
tests/mdemo-exec.test:tests/md-exec.test
tests/mdemo-inst.test:tests/md-inst.test
tests/mdemo-make.test:tests/md-make.test
tests/mdemo-shared.test:tests/md-shared.test
tests/mdemo-static.test:tests/md-static.test
tests/mdemo-unst.test:tests/md-unst.test
tests/pdemo-conf.test:tests/pd-conf.test
tests/pdemo-exec.test:tests/pd-exec.test
tests/pdemo-inst.test:tests/pd-inst.test
tests/pdemo-make.test:tests/pd-make.test
tests/tagdemo-conf.test:tests/tagd-conf.test
tests/tagdemo-exec.test:tests/tagd-exec.test
tests/tagdemo-make.test:tests/tagd-make.test
tests/tagdemo-shared.test:tests/tagd-shared.test
tests/tagdemo-static.test:tests/tagd-static.test
"

# Files that are new in $dstdir
NEW="
"

# Parse command-line args
test=0

while [ $# -gt 0 ]; do
    # Test mode?
    if [ "$1" = "-n" ]; then
	test=1
	shift
	continue
    # Trace mode?
    elif [ "$1" = "-t" ]; then
	set -x
	shift
	continue
    # Assume the other options are for diff
    else
	break
    fi
done

DIFFOPTS="$@"
DIFF="diff $DIFFOPTS"

# Check that source directories exist
if [ ! -d $SRCDIR ]; then
    echo ERROR: $SRCDIR is not a directory
    exit 1
fi

if [ ! -d $DSTDIR ]; then
    echo ERROR: $DSTDIR is not a directory
    exit 1
fi

# Failure status for existence checks
failed=0

# Check that normal files exist
for i in $NORMAL; do
    if [ ! -r $SRCDIR/$i ]; then
	echo MISSING: $SRCDIR/$i
	failed=1
    fi

    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

# Check that renamed files exist
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    if [ ! -r $SRCDIR/$origname ]; then
	echo MISSING: $SRCDIR/$origname
	failed=1
    fi

    if [ ! -r $DSTDIR/$newname ]; then
	echo MISSING: $DSTDIR/$newname
	failed=1
    fi
done

# Check that new files exist
for i in $NEW; do
    if [ ! -r $DSTDIR/$i ]; then
	echo MISSING: $DSTDIR/$i
	failed=1
    fi
done

if [ "a$failed" != "a0" ]; then
    echo Files missing - aborting
    exit 1
fi

if [ "a$test" != "a0" ]; then
    echo Running in test mode - exiting
    exit 0
fi

# Diff the normal files
for i in $NORMAL; do
    $DIFF $SRCDIR/$i $DSTDIR/$i
done

# Diff the renamed files
for i in $RENAMED; do
    origname=`echo $i | cut -d : -f 1`
    newname=`echo $i | cut -d : -f 2`

    $DIFF $SRCDIR/$origname $DSTDIR/$newname
done

# Diff the new files
for i in $NEW; do
    $DIFF /dev/null $DSTDIR/$i
done
