# Local additions to Autoconf macros.			-*- shell-script -*-
# Copyright  1992, 1994, 1995, 1996, 1997, 1998 Progiciels Bourbeau-Pinard inc.
# Franois Pinard <pinard@iro.umontreal.ca>, 1992.

# This code is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2, or (at your
# option) any later version.

# This code is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public
# License along with this code; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

## ------------------- ##
## See if %llu works.  ##
## ------------------- ##

# SunOS 4.1.3's printf treats %llu as %lu.  From Alexander Oliva.

AC_DEFUN(fp_HAVE_PRINTF_LLU,
[AC_CACHE_CHECK(whether printf understands %llu, tar_cv_have_printf_llu,
[AC_TRY_RUN([#include <stdio.h>
main ()
{
  unsigned long long before = 1;
  char buffer[1024];
  while (before)
    {
       unsigned long long after = 0;
       sprintf(buffer, "%llu", before);
       sscanf(buffer, "%llu", &after);
       if (after != before)
	 exit (1);
       before <<= 1;
    }
  exit (0);
}
], tar_cv_have_printf_llu=yes, tar_cv_have_printf_llu=no,
  test "$tar_cv_have_printf_llu" = '' && tar_cv_have_printf_llu=cross)
test "$tar_cv_have_printf_llu" = yes && AC_DEFINE(HAVE_PRINTF_LLU)])
])

## ---------------------------------------- ##
## See if compiling for Microsoft systems.  ##
## ---------------------------------------- ##

AC_DEFUN(fp_OS_MICROSOFT,
[AC_CACHE_CHECK([for MSDOS, Win95 or WinNT], fp_cv_os_microsoft,
[if test -n "$COMSPEC"; then
  # MSDOS or Win95
   fp_cv_os_microsoft=yes
elif test -n "$ComSpec"; then
  # WinNT
  fp_cv_os_microsoft=yes
else
  fp_cv_os_microsoft=no
fi
])])

## ----------------------------------------- ##
## Find how to suppress newlines with echo.  ##
## ----------------------------------------- ##

# Once this macro is called, you may output with no echo in a Makefile or
# script using:  echo @ECHO_N@ "STRING_TO_OUTPUT@ECHO_C@".

AC_DEFUN(fp_PROG_ECHO,
[AC_CACHE_CHECK(how to suppress newlines using echo, fp_cv_prog_echo_nonl,
[if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    fp_cv_prog_echo_nonl=no
  else
    fp_cv_prog_echo_nonl=option
  fi
else
  fp_cv_prog_echo_nonl=escape
fi
])
test $fp_cv_prog_echo_nonl = no \
  && echo 2>&1 "WARNING: \`echo' not powerful enough for \`make check'"
case $fp_cv_prog_echo_nonl in
  no) ECHO_N= ECHO_C= ;;
  option) ECHO_N=-n ECHO_C= ;;
  escape) ECHO_N= ECHO_C='\c' ;;
esac
AC_SUBST(ECHO_N)dnl
AC_SUBST(ECHO_C)dnl
])

## ------------------------------------------ ##
## Check if --without-gnu-gettext was given.  ##
## From Franois Pinard                       ##
## ------------------------------------------ ##

AC_DEFUN(fp_WITH_GNU_GETTEXT,
[AC_ARG_WITH(gnu-gettext,
  [  --without-gnu-gettext   avoid using an installed GNU gettext], ,
  [withval=yes])
if test "$withval" = yes; then
  AC_CHECK_LIB(intl, gettext)

  AC_MSG_CHECKING(selection of message catalogs)
  if test $ac_cv_lib_intl_gettext = yes; then

    if test -z "$ALL_LINGUAS"; then
      AC_MSG_WARN('ALL_LINGUAS is currently empty in configure.in')
    else
      ac_items="$ALL_LINGUAS"
      for ac_item in $ac_items; do
	if test -z "$ALL_MOFILES"; then
	  ALL_MOFILES=$ac_item.mo
	else
	  ALL_MOFILES="$ALL_MOFILES $ac_item.mo"
	fi
      done
    fi
    AC_SUBST(ALL_LINGUAS)
    AC_SUBST(ALL_MOFILES)

    if test -z "$LINGUAS"; then
      ac_print="$ALL_LINGUAS"
      MOFILES="$ALL_MOFILES"
    else
      ac_items="$LINGUAS"
      for ac_item in $ac_items; do
	case "$ALL_LINGUAS" in
	  *$ac_item*)
	    if test -z "$ALL_MOFILES"; then
	      ac_print=$ac_item
	      MOFILES=$ac_item.mo
	    else
	      ac_print="$ac_print $ac_item"
	      MOFILES="$MOFILES $ac_item.mo"
	    fi
	    ;;
	esac
      done
    fi
    AC_SUBST(LINGUAS)
    AC_SUBST(MOFILES)

  else
    ac_print=none
  fi
  AC_MSG_RESULT($ac_print)

else
  AC_MSG_CHECKING(selection of message catalogs)
  AC_MSG_RESULT(none)
fi
])

## ------------------------------------------- ##
## Check if --with-included-malloc was given.  ##
## From Franois Pinard                        ##
## ------------------------------------------- ##

# In 1992, Michael Bushnell (now Thomas Bushnell <thomas@gnu.org>)
# devised a test for avoiding HP/UX malloc and using GNU malloc instead.
# Bruno Haible <haible@ma2s2.mathematik.uni-karlsruhe.de> recycled this
# test for CLISP Common LISP and extended it to cover broken mallocs
# from SGI.  I (<pinard@iro.umontreal.ca>) reworked it a little so it is
# independent of config.guess, and overridable by the installer.

# On IRIX 5.2, libc malloc is broken, but the -lmalloc one was usable.
# So in my packages, I once unconditionally used -lmalloc if it existed.
# This does not do anymore, because the -lmalloc malloc is broken on
# Solaris 2.4 to 2.5.1 (alignment is 4 bytes instead of 8 bytes, as
# reported by John Wells <john@bitsmart.com>).

# Bruno also notes: "HP-UX has two different malloc() implementations.
# Both are broken.  When used with CLISP, the one in the default libc.a
# leads to a SIGSEGV, the one in libmalloc.a leads to a SIGBUS."

# If the installer does not give a preference, we use the included GNU
# malloc if we have the slightest doubt that malloc could be broken,
# this includes cross compilation, and *all* HP/UX or IRIX systems.
# It is crude indeed, but I just do not have enough information for truly
# benchmarking malloc in all cases, but want safe packages nevertheless.

AC_DEFUN(fp_WITH_INCLUDED_MALLOC,
[AC_MSG_CHECKING(if included GNU malloc is wanted)
AC_ARG_WITH(included-malloc,
[  --with-included-malloc  use the GNU malloc which is included here], ,
[if test $cross_compiling = yes; then
  withval=yes
else
  case `uname -s 2> /dev/null` in
    HP-UX | IRIX* ) withval=yes ;;
    *) withval=no ;;
  esac
fi])
test "$withval" = yes && LIBOBJS="$LIBOBJS gmalloc.o"
AC_MSG_RESULT($withval)
])
