/*****************************************************************************

  This code is copyrighted by Salvador Eduardo Tropea. (c) 1996.

  You can use, distribute and modify this code with the following
restrictions:

1) You can't remove this text.
2) You must say who is the original author.
3) You can't receive money for this files, this includes the binarys
generated with this sources, without my consent. (only a minimal amount for
the media is allowed without my consent (floppy disk <= 5 U$S, CD <= U$S 35)).
4) You can't modify the copyrights inside inflibc.spa and inflibc.eng, and
if you generate a convertion from libc.inf this convertion must include
inflibc.spa or inflibc.eng.

  The following aren't restictions but requests:

1) If you find any bug please inform it to me.
2) If you make enhacements or derivated work share it with me.
3) If you use this code or the files generated e-mail, or send a letter,
to me.

  Some of the projects i have in mind are the followings:

1) A FAQ's to NG coverter (seems to be easy).
2) A TEX to NG converter (not so easy).
3) A generic NG compiler (from sources).

  If you plan to do some of these, e-mail to me.

  Share and enjoy, but not abuse.

E-Mail: ice@inti.edu.ar

Telephone: (+541) 759-0013

Postal Address:
Salvador E. Tropea
Curapalige 2124
(1678) Caseros - 3 de Febrero
Prov: Buenos Aires
Argentina

History: (dates in spanish style)
10/04/96
v0.1 First release
24/04/96
v0.2 Added NGShortDummy to allow the creation of index without an important
      grow in the file.	Made for the generic INF to NG.

*****************************************************************************/

#include "setstd.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// For a simple check
#define DEBUG

#ifdef DEBUG
// for a Heavy check
//#define PESADO
#endif

#ifdef PESADO
void PesadoSi(int cond,int valor)
{
 if (cond)
   {
    printf("Crash: %d\n",valor);
    exit(1);
   }
}
#else
#define PesadoSi(a,b);
#endif

//#define ESPANOL

#include "compila.hpp"

/***************************************************************************

 Informacin de errores y warnings

***************************************************************************/

char *Warnings[] =
{
#ifdef ESPANOL
 "Largo de valor centrado muy largo",
 "Nombre de men muy largo"
#else
 "String to be centered is very large",
 "Menu name is very large"
#endif
};

void Warning(int Val)
{
 printf("Warning (%4X): %s\n",Val,Warnings[Val-0x1000]);
}

char *Errores[] =
{
#ifdef ESPANOL
 "No hay ms memoria",
 "Asignando posicin a un nodo nulo",
 "Agregando un Objeto incorrecto a un Tipo 0",
 "Error al crear el archivo de salida",
 "Llamado a grabar con valores ilgicos",
 "Atachado algo a un tipo 1",
 "Error SeeAlso no resuelto"
#else
 "Out of memory",
 "Trying to assign a position to a NULL node",
 "Attaching an incorrect object to a Tipe 0",
 "Can't create the output file",
 "Call to Grabar with wrong parameter",
 "Attaching an object to a Tipe 1",
 "Unresolvered See Also"
#endif
};

void Error(int Val)
{
 printf("Error (%4X): %s\n",Val,Errores[Val]);
 exit(1);
}

inline
char *StrCopiaDe(char *s)
{
 char *ret=strdup(s);
 if (ret==NULL) Error(ID_MEMORIA);
 return ret;
}

/***************************************************************************

 void CopiaCentrado(char *linea,char *s,int max)

***************************************************************************/

void CopiaCentrado(char *linea,char *s,int max)
{
 int i,relleno,largo;

 // para \x0
 --max;
 // truncar si excede
 largo=strlen(s);
 if (largo>max)
   {
    s[max]=0;
    Warning(ID_LARGO_CENTRADO);
   }

 relleno=(max-largo)/2;
 for (i=0;i<relleno;i++)
     linea[i]=32;
 for (;*s && *s!='\n';s++,i++)
     linea[i]=*s;
 for (;i<max;i++)
     linea[i]=0;
}



/***************************************************************************

 Rutinas que graban a disco encriptando

***************************************************************************/

void Xor26Save(BYTE *Buf,size_t Taman,FILE *f)
{
 size_t Cont;

 for (Cont=0; Cont<Taman; Cont++)
     Buf[Cont]^=26;
 fwrite((void *)Buf,Taman,1,f);
}

void Xor26SaveLong(long Val,FILE *f)
{
 Val^=0x1A1A1A1AL; 
 fwrite((void *)&Val,4,1,f);
}

void Xor26SaveWord(WORD Val,FILE *f)
{
 Val^=0x1A1A;
 fwrite((void *)&Val,2,1,f);
}

/***************************************************************************

  Implementa la Clase ListaStr

***************************************************************************/

void ListaStr::Agregar(char *s)
{
 NodoStr *p = new NodoStr;
 if (p==NULL) Error(ID_MEMORIA);
 p->s=StrCopiaDe(s);

 strcpy(p->s,s);
 if (Cantidad++ == 0)
   {
    Pos=Cola=Base=p;
   }
 else
   {
    Cola->p=p;
    Cola=p;
   }
 p->p=NULL;
}

char *ListaStr::Avanzar()
{
 if (Pos!=NULL)
   {
    char *ret=Pos->s;
    Pos=Pos->p;

    return ret;
   }

 return NULL;
}

ListaStr::~ListaStr()
{
 Pos=Base;

 while (Pos!=NULL)
   {
    free(Pos->s);
    delete Pos;
    Pos=Pos->p;
   }
}

/***************************************************************************

  Implementa la Clase ListaStrOff

***************************************************************************/

void ListaStrOff::Agregar(char *s)
{
 NodoStrOff *p = new NodoStrOff;
 if (p==NULL) Error(ID_MEMORIA);
 p->s=StrCopiaDe(s);
 p->Pos = 0;

 if (Cantidad++ == 0)
   {
    Cola=Base=p;
   }
 else
   {
    Cola->p=p;
    Cola=p;
   }
 p->p=NULL;
}

ListaStrOff::~ListaStrOff()
{
 NodoStrOff *Pos=Base;

 while (Pos!=NULL)
   {
    free(Pos->s);
    delete Pos;
    Pos=Pos->p;
   }
}


/***************************************************************************

  Implementa la Clase ObjNGElemento

***************************************************************************/

void ObjNGElemento::Agregar(ObjNG& o)
{
 NodoLista *p = new NodoLista;

 if (p==NULL) Error(ID_MEMORIA);
 p->o=&o;
 if (iObjContiene++ == 0)
   {
    Ultimo=Lista=p;
   }
 else
   {
    Ultimo->p=p;
    Ultimo=p;
   }
 p->p=NULL;
}

/***************************************************************************

  Implementa la Clase NGListaPura

***************************************************************************/

int StrCmpTolera32(char *s1, char *s2)
{
 // Mover s1 y s2 hasta un no blanco
 for(;*s1 && isspace(*s1);s1++);
 for(;*s2 && isspace(*s2);s2++);

 // Si algno es nulo no aceptar match
 if (!(*s1 || *s2)) return 1;

 // Comparar
 for(;*s1 && *s2 && *s1==*s2; s1++,s2++);

 return !(*s1==0 && *s2==0);
}


//
// Resuelve los SeeAlso
//
#pragma argsused
long NGListaPura::ResolverPosiciones(long lPosIni,long dummy)
{
 NodoLista *p,*b;
 p=Lista;
 NGShort *o;

 //   Recorrer la lista de objetos tipo 1, esto es medio crazy, pero casteo
 // el puntero de la abstracta a la instanciable !!!!, no veo otra manera
 // de resolverlo.
 while (p!=NULL)
   {
    o=(NGShort *)p->o;
    if (o->SeeAlso.Cantidad!=0)
      { // Si hay SeeAlsos
       NodoStrOff *sa;

       sa=o->SeeAlso.Base;
       while (sa!=NULL)
         {
          // Barrer la lista buscado el match
          b=Lista;
          while (b!=NULL)
            {
             if (StrCmpTolera32(sa->s,((NGShort *)b->o)->Alias)==0) break;
             b=b->p;
            }
          if (b==NULL)
            {
             #ifdef ESPANOL
             printf("SeeAlso no resuelto: %s (%d) en %s\n",sa->s,strlen(sa->s),o->Nombre);
             #else
             printf("Unresolvered SeeAlso: %s (%d) in %s\n",sa->s,strlen(sa->s),o->Nombre);
             #endif
             //Error(ID_SEEALSO);
            }
          else
             // Eureka!, poner el valor
             sa->Pos=b->o->lPosBase;

          sa=sa->p;
         }
      }
    p=p->p;
   }
 return 0;
}

NGShort *NGListaPura::Buscar(char *NomBus)
{
 NodoLista *p;
 NGShort *o;
 p=Lista;

 while (p!=NULL)
   {
    o=(NGShort *)p->o;
    if (strcmp(o->Alias,NomBus)==0)
       return o;
    p=p->p;
   }
 return NULL;
}

/***************************************************************************

  Implementa la Clase NGArchivo

***************************************************************************/

NGArchivo::NGArchivo(char *s,char *nom)
{
 h.ID=NG_ID;
 h.Version=0x100;
 NumCopy=0;
 Nombre=StrCopiaDe(s);
 memset(h.CopyR,0,sizeof(h.CopyR));
 strncpy(h.Nombre,nom,40);
 h.Nombre[39]=0;
 lLargo=sizeof(hNG);
}

void NGArchivo::AgregarCopy(char *Cp)
{
 if (NumCopy<4)
    CopiaCentrado(h.CopyR[NumCopy++],Cp,66);
}

#pragma argsused
long NGArchivo::ResolverPosiciones(long lPosIni,long dummy)
{
 NodoLista *p=Lista;
 long lProxPosT0o1,lProxPosMenu;
 long lPosPrimerTipo0;

 // Setear el valor del archivo 0 se supone.
 lPosBase=lPosIni;

 // Los menes van todos juntos al principio, por ello el primer tipo 0 o 1
 // no puede ir atrs del primer men (una lstima)
 lPosPrimerTipo0=lPosIni+lLargo;
 while (p!=NULL)
   {
    lPosPrimerTipo0+=p->o->lLargo;
    p=p->p;
   }

 // Ahora si resolver todo el rbol
 p=Lista;
 lProxPosMenu=lPosIni+lLargo;
 lProxPosT0o1=lPosPrimerTipo0;
 while (p!=NULL)
   {
    lProxPosT0o1=p->o->ResolverPosiciones(lProxPosMenu,lProxPosT0o1);
    lProxPosMenu+=p->o->lLargo;
    p=p->p;
   }
 return lProxPosT0o1;
}

#pragma argsused
void NGArchivo::Grabar(int Accion,FILE *f)
{
 if ((f=fopen(Nombre,"wb"))==NULL) Error(ID_CREAR_SALIDA);

 h.NumeroMenues=iObjContiene;
 h.Dummy1=0;  // Por las dudas
 // Escribir el header
 fwrite((void *)&h,sizeof(hNG),1,f);

 // A continuacin la coleccin de menes
 NodoLista *p=Lista;
 while (p!=NULL)
   {
    p->o->Grabar(ID_GUARDAR_SOLO_MENU,f);
    p=p->p;
   }

 // Ahora si todo
 p=Lista;
 while (p!=NULL)
   {
    p->o->Grabar(ID_GUARDAR_COMPLETO,f);
    p=p->p;
   }

 // Esto es todo!
 fclose(f);
}

NGArchivo::~NGArchivo()
{
 if (Nombre!=NULL)
    delete Nombre;
}

/***************************************************************************

  Implementa la Clase NGMenu

***************************************************************************/

int NGMenu::NumeroDeMenues=0;

NGMenu::NGMenu(char *nom)
{
 Nombre = new char[40];

 int LarMen=strlen(nom);

 if (LarMen>39)
   {
    nom[39]=0;
    Warning(ID_LARGO_MENU);
   }
 strcpy(Nombre,nom);

 // Tipo 2, Largo de la entrada + el Fin del ttulo + el string del men +
 // el nulo final
 lLargo=sizeof(hElem)+sizeof(NGMenuFinOps)+LarMen+1+1;

 Numero=NumeroDeMenues++;
}

NGMenu::~NGMenu()
{
 if (Nombre!=NULL)
    delete Nombre;
}

//
//   Esto agrega una opcin vertical en el men descolgable, esta puede ser
// una Tipo 0 o 1, lo comn es una tipo 0.
//
void NGMenu::Agregar(ObjNG& o,char *Nombre,NGListaPura& oLista)
{
 ObjNGElemento::Agregar(o);
 Strs.Agregar(Nombre);
 if (o.Tipo()==1)
    oLista.Agregar(o);
 // 2 por el puntero + la struct de Fin + el string (\x0 incluido)
 lLargo+=4+sizeof(NGMenuFinOps)+strlen(Nombre)+1;
}

long NGMenu::ResolverPosiciones(long lPosDeEste,long lPosResto)
{
 NodoLista *p=Lista;
 long lProxPos,lPosAnt,lAux;
 int iCont=0;

 // Setear el valor del men.
 lPosBase=lPosDeEste;

 lProxPos=lPosResto;
 lPosAnt=NIL;
 while (p!=NULL)
   {
    lAux=lProxPos;

    // Propagar la pos del padre en el pulldown
    p->o->iPerteH=Numero;
    p->o->iPerteV=iCont++;

    // Algo que se descuelga de un men no tiene padre
    p->o->iPadreInd=NIL;
    p->o->lPadrePos=NIL;

    lProxPos=p->o->ResolverPosiciones(lProxPos,0);
    p->o->lPrevio=lPosAnt;
    lPosAnt=lAux;
    if (p->p!=NULL)
       p->o->lProximo=lProxPos;
    else
       p->o->lProximo=NIL;
    p=p->p;
   }
 return lProxPos;
}

void NGMenu::Grabar(int Accion,FILE *f)
{
 NodoLista *p;
 int iPosAcu=0;

 switch (Accion)
   {
    case ID_GUARDAR_SOLO_MENU:
         memset((void *)&hElem,0,sizeof(hElem));
         hElem.Tipo=2;
         hElem.Largo=lLargo-sizeof(hElem);
         hElem.Opciones=iObjContiene+1;
         hElem.LargoListaPunts=iObjContiene*4;
         Xor26Save((BYTE *)&hElem,sizeof(hElem),f);

         // Punteros a las entradas
         p=Lista;
         while (p!=NULL)
           {
            Xor26SaveLong(p->o->lPosBase,f);
            iPosAcu+=4;
            p=p->p;
           }

         // Fines de los nombres referidos al fin de la zona variable
         NGMenuFinOps Fin;
         p=Lista;
         Strs.Rebobinar();
         // Primero para el ttulo
         iPosAcu+=strlen(Nombre)+1+sizeof(Fin)*(iObjContiene+1);
         memset((void *)&Fin,0,sizeof(Fin));
         Fin.Fin=iPosAcu;
         Xor26Save((BYTE *)&Fin,sizeof(Fin),f);
         while (p!=NULL)
           {
            iPosAcu+=strlen(Strs.Avanzar())+1;
            memset((void *)&Fin,0,sizeof(Fin));
            Fin.Fin=iPosAcu;
            Xor26Save((BYTE *)&Fin,sizeof(Fin),f);
            p=p->p;
           }

         // Ahora los strings
         p=Lista;
         Strs.Rebobinar();
         // Primero para el ttulo
         PesadoSi(strlen(Nombre)>39,1);
         Xor26Save((BYTE *)Nombre,strlen(Nombre)+1,f);
         while (p!=NULL)
           {
            char *aux;
            aux=Strs.Avanzar();
            PesadoSi(aux==NULL,5);
            Xor26Save((BYTE *)aux,strlen(aux)+1,f);
            p=p->p;
           }

         // El NULL final
         fputc(0^26,f);
         break;

    case ID_GUARDAR_COMPLETO:
         // Ya antes se guard esto, ahora guardar lo que tiene atachado
         p=Lista;
         while (p!=NULL)
           {
            p->o->Grabar(0,f);
            p=p->p;
           }
         break;

    #ifdef DEBUG
    default: Error(ID_GRABAR_INCORRECTO);
    #endif
   }
}

/***************************************************************************

  Implementa la Clase NGVariosShort

***************************************************************************/

NGVariosShort::NGVariosShort(char *nom)
{
 Nombre=StrCopiaDe(nom);
 lLargo=sizeof(hElem);
 iLargoNombre=strlen(nom);
}

NGVariosShort::~NGVariosShort()
{
 PesadoSi(Nombre==NULL,2);
 free(Nombre);
}

void NGVariosShort::Agregar(ObjNG& o,NGListaPura& oLista)
{
 PesadoSi(&o==NULL,3);
 ObjNGElemento::Agregar(o);
 if (o.Tipo()==1)
    oLista.Agregar(o);
 #ifdef DEBUG
 if (o.iLargoNombre==-1)
    Error(ID_AGREGA_NO_INI);
 #endif
 // Puntero al nombre y a la entrada + Largo de nombre
 lLargo+=sizeof(NGVariosShortNomPun)+o.iLargoNombre+1;
}


long NGVariosShort::ResolverPosiciones(long lPosIni,long dummy)
{
 NodoLista *p=Lista;
 long lProxPos,lPosAnt,lAux;
 int iCont=0;

 lPosBase=lPosIni;
 lProxPos=lPosIni+lLargo;
 lPosAnt=NIL;
 while (p!=NULL)
   {
    lAux=lProxPos;

    // Propagar la pos del padre en el pulldown
    p->o->iPerteH=iPerteH;
    p->o->iPerteV=iPerteV;

    // Algo que se descuelga de un tipo 0 es su hijo
    p->o->iPadreInd=iCont++;
    p->o->lPadrePos=lPosBase;

    lProxPos=p->o->ResolverPosiciones(lProxPos,dummy);
    p->o->lPrevio=lPosAnt;
    lPosAnt=lAux;
    if (p->p!=NULL)
       p->o->lProximo=lProxPos;
    else
       p->o->lProximo=NIL;
    p=p->p;
   }
 return lProxPos;
}

#pragma argsused
void NGVariosShort::Grabar(int Accion,FILE *f)
{
 NodoLista *p;

 memset((void *)&hElem,0,sizeof(hElem));
 hElem.Tipo=0;
 hElem.Largo=lLargo-sizeof(hElem);
 hElem.Puntos=iObjContiene;
 hElem.IndPadre=iPadreInd;
 hElem.PosPadre=lPadrePos;
 hElem.IndMenuH=iPerteH;
 hElem.IndMenuV=iPerteV;

 Xor26Save((BYTE *)&hElem,sizeof(hElem),f);

 // Punteros a las entradas y los strings
 p=Lista;
 int iPosAcu=sizeof(NGVariosShortNomPun)*iObjContiene;
 NGVariosShortNomPun DatEnts;
 while (p!=NULL)
   {
    DatEnts.PosNom=iPosAcu;
    if (p->o->lLargo==sizeof(hElem))
       DatEnts.Punt=NIL; // No guardar la info de uno vaco
    else
       DatEnts.Punt=p->o->lPosBase;
    iPosAcu+=strlen(p->o->Nombre)+1;
    Xor26Save((BYTE *)&DatEnts,sizeof(NGVariosShortNomPun),f);
    p=p->p;
   }

 // Ahora los strings
 p=Lista;
 while (p!=NULL)
   {
    PesadoSi(p->o->Nombre==NULL,4);
    Xor26Save((BYTE *)p->o->Nombre,strlen(p->o->Nombre)+1,f);
    p=p->p;
   }

 // Ya antes se guard esto, ahora guardar lo que tiene atachado
 p=Lista;
 while (p!=NULL)
   {
    p->o->Grabar(0,f);
    p=p->p;
   }
}

/***************************************************************************

  Implementa la Clase NGShort

***************************************************************************/

#ifndef TEXTO_EN_DISCO
NGShort::NGShort(char *nom,char *alias)
{
 Nombre=StrCopiaDe(nom);
 if (alias!=NULL)
    Alias=StrCopiaDe(alias);
 else
    Alias=Nombre;
 Lineas=0;
 Texto=NULL;
 iLargoNombre=strlen(nom);
 lLargo=sizeof(NGShortStruct);
}
#else
NGShort::NGShort(char *nom,char *alias,FILE *f)
{
 Nombre=StrCopiaDe(nom);
 if (alias!=NULL)
    Alias=StrCopiaDe(alias);
 else
    Alias=Nombre;
 Lineas=0;
 iLargoNombre=strlen(nom);
 lLargo=sizeof(NGShortStruct);
 BufDisco=f;
}
#endif

NGShort::~NGShort()
{
 PesadoSi(Nombre==NULL || Alias==NULL,7);
 free(Nombre);
 if (Alias!=Nombre)
    free(Alias);
 #ifndef TEXTO_EN_DISCO
 if (Texto!=NULL)
    delete Texto;
 #endif
}

void ComprimeEspacios(char *&PosNoC,char *&PosC)
{
 int CantEsp=0,EnEsp=0;

 while (*PosNoC)
   {
    if (*PosNoC!=32)
      {
       // Si es una letra
       if (*PosNoC=='\n')
          PosNoC++;
       else
         {
          if (EnEsp)
            { // Si estaba en una secuencia de espacios
             if (CantEsp>2)
               { // Si vale la pena
                *PosC=255; PosC++;
                *PosC=(char)CantEsp; // Sorry, no ms de 128 es incoherente
                PosC++;
               }
             else
               { // Al pedo disparar la compresin
                if (CantEsp==2)
                   { *PosC=32; PosC++; }
                *PosC=32; PosC++;
               }
             EnEsp=0;
            }
          else
            {
             *PosC=*PosNoC;
             PosC++;
             PosNoC++;
            }
         }
      }
    else
      {
       // Es un espacio, intento de compresin.
       if (EnEsp)
         { // Si ya estoy en eso
          CantEsp++;
         }
       else
         { // Si es el 1ro
          CantEsp=1;
          EnEsp=1;
         }
       PosNoC++;
      }
   }
 // Estaba en espacios?
 if (EnEsp)
   { // Si estaba en una secuencia de espacios
    if (CantEsp>2)
      { // Si vale la pena
       *PosC=255; PosC++;
       *PosC=(char)CantEsp; // Sorry, no ms de 128 es incoherente
       PosC++;
      }
    else
      { // Al pedo disparar la compresin
       *PosC=32; PosC++;
       *PosC=32; PosC++;
      }
   }
 *PosC=*PosNoC=0;
 PosC++;
 PosNoC++;
}

void NGShort::PonerTexto(char *Buf, int Cant)
{
 int i;
 char *PosC;
 char *PosNoC;

 Lineas=Cant;
 PosNoC=PosC=Buf;
 for (i=0; i<Cant; i++)
    {
     ComprimeEspacios(PosNoC,PosC);
    }

 TamanTexto=PosC-Buf;
 PesadoSi(TamanTexto>16348,8);
 #ifdef TEXTO_EN_DISCO
 lPosEnDisco=ftell(BufDisco);
 fwrite(Buf,TamanTexto,1,BufDisco);
 #else
 Texto = new char[TamanTexto];
 if (Texto==NULL) Error(ID_MEMORIA);
 memcpy(Texto,Buf,TamanTexto);
 #endif
 lLargo+=TamanTexto;
}


void NGShort::AgregarSeeAlso(char *nom)
{
 if (SeeAlso.Cantidad==0)
   {
    // 2 para indicar la cantidad + 1 por el \x0 extra
    lLargo+=2+1;
   }
 PesadoSi(nom==NULL,9);
 SeeAlso.Agregar(nom);
 // 4 por el puntero + Largo del nombre
 lLargo+=4+strlen(nom)+1;
}

#pragma argsused
void NGShort::Grabar(int Accion,FILE *f)
{
 if (!Lineas) return;

 hElem.Tipo=1;
 hElem.Largo=lLargo-sizeof(hElem);
 hElem.Lineas=Lineas;
 if (SeeAlso.Cantidad==0)
    hElem.OffSeeAlso=0;
 else
    hElem.OffSeeAlso=TamanTexto;
 hElem.IndPadre=iPadreInd;
 hElem.PosPadre=lPadrePos;
 hElem.IndMenuH=iPerteH;
 hElem.IndMenuV=iPerteV;
 hElem.Prev=lPrevio;
 hElem.Next=lProximo;

 Xor26Save((BYTE *)&hElem,sizeof(hElem),f);

 // El Texto que contiene
 #ifndef TEXTO_EN_DISCO
 PesadoSi(Texto==NULL,6);
 Xor26Save((BYTE *)Texto,TamanTexto,f);
 #else
 fseek(BufDisco,lPosEnDisco,SEEK_SET);
 char *aux = new char[TamanTexto];
 if (aux==NULL) Error(ID_MEMORIA);
 fread(aux,TamanTexto,1,BufDisco);
 Xor26Save((BYTE *)aux,TamanTexto,f);
 delete aux;
 #endif

 // Los seealso
 if (SeeAlso.Cantidad)
   {
    // Cantidad
    Xor26SaveWord(SeeAlso.Cantidad,f);

    // OffSets
    NodoStrOff *p=SeeAlso.Base;
    while (p!=NULL)
      {
       Xor26SaveLong(p->Pos,f);
       p=p->p;
      }

    // Nombres
    p=SeeAlso.Base;
    while (p!=NULL)
      {
       PesadoSi(p->s==NULL,10);
       Xor26Save((BYTE *)p->s,strlen(p->s)+1,f);
       p=p->p;
      }

    // El NULL final
    fputc(0^26,f);
   }

 #ifdef NDEBUG
 if (Lista!=NULL) Error(ID_ATACHO_1);
 #endif
}

#pragma argsused
long NGShort::ResolverPosiciones(long lPosIni,long dummy)
{
 lPosBase=lPosIni;

 if (Lineas)
    return lPosIni+lLargo;
 return lPosIni;
}



/***************************************************************************

  Implementa la Clase NGShortDummy

***************************************************************************/

NGShortDummy::NGShortDummy(char *nom,char *alias,NGShort *oReal)
{
 Nombre=StrCopiaDe(nom);
 if (alias!=NULL)
    Alias=StrCopiaDe(alias);
 else
    Alias=Nombre;
 Real=oReal;
 iLargoNombre=strlen(nom);
}

NGShortDummy::~NGShortDummy()
{
 PesadoSi(Nombre==NULL || Alias==NULL,20);
 free(Nombre);
 if (Alias!=Nombre)
    free(Alias);
}

#pragma argsused
long NGShortDummy::ResolverPosiciones(long lPosIni,long dummy)
{
 lPosBase=Real->lPosBase;
 return lPosIni;
}



