/*
 * PINLOAD.CPP - Information modules loader and related functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _PINLOAD_CC_

#include "bios.h"

char buffer[4096];

int pinrun(const char *pinfile, const char *file)
{
 FILE *fp, *tfp;
 int found = 0;
 char fname[100];
 unsigned long size, f;
 int retval = -1;

 // Try to open file.
 if ((fp = fopen(pinfile, "rb")) == NULL) return (retval);

 do {
    if ((!fread(fname, 100, 1, fp)) ||
       (!fread(&size, sizeof(size), 1, fp))) break;

    if (!strcmp(file, fname)) {
       found = 1;
       break;
    }
    // Change file pointer.
    fseek(fp, ftell(fp) + size, SEEK_SET);

 } while (ftell(fp) < filelength(fileno(fp)));
 if (!found) {
    fclose(fp);
    return (retval);
 }
 // Copy contents to temporary file.
 if ((tfp = fopen("pin.$$$", "wb")) == NULL) return (retval);

 for(f = 0; f < size / 4096; f++)
 {
  if (!fread(buffer, 4096, 1, fp)) break;
  if (!fwrite(buffer, 4096, 1, tfp)) break;
 }

 if (f != size / 4096) {
    fclose(fp);
    fclose(tfp);
    return (retval);
 }

 for(f = 0; f < size % 4096; f++)
 {
  if (!fread(buffer, 1, 1, fp)) break;
  if (!fwrite(buffer, 1, 1, tfp)) break;
 }

 if (f != size % 4096) {
    fclose(fp);
    fclose(tfp);
    return (retval);
 }

 fclose(fp);
 fclose(tfp);
 retval = spawnl(P_WAIT, "pin.$$$", "", NULL);
 unlink("pin.$$$");
 return (retval);
}
