/*
 * TIMING.CPP - Contains CPU speed functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _TIMING_CC_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef stderr

#undef stderr

#ifdef _TIMING_CC_

FILE *stderr;

#else

extern FILE *stderr;

#endif

#endif

unsigned _stklen = 0x2000;
char cmdline[20];
FILE *fp;

extern "C" {
	unsigned get_cpu_divdword();
	unsigned get_cpu_divword();
	unsigned get_cpu_divbyte();
	unsigned get_cpu_family();
	unsigned long get_rdtsc_time();
}

void errors(const char *string)
{
	fprintf(stderr, "Error: %s\n\r", string);
	exit(0x7f);
}

int getspeed()
{
	int i;
	unsigned counter;
	float cpu__speed = 0, p_rating = 0;
	float *tb;
	int cputype = get_cpu_family();
	// For clock.
	for(i = 0; i < 100; i++)
	{
		counter = get_cpu_divbyte();
		cpu__speed += (float)counter;
	}

	if (cputype) {
		cpu__speed = (float)get_rdtsc_time();
		cpu__speed = cpu__speed / 10000 * 18.2065 / 100;
	}

	// For P-Rating.
	for(i = 0; i < 100; i++)
	{
		counter = get_cpu_divdword();
		p_rating += (float)counter;
	}

	// Calculate and write to file.
	if ((fp = fopen("temp.$$$", "wb")) == NULL)
		errors("Unable to create temporary file");
	if (fprintf(fp, "%f ", cpu__speed) == EOF)
		errors("Cannot write to disk (Disk full ?)");

	if (!cputype) cpu__speed = 133.0 * 142.0 / (unsigned)(cpu__speed / 100);

	if (fprintf(fp, "%f ", cpu__speed) == EOF)
		errors(" Cannot write to disk (Disk full ?)");
	p_rating = 133.0 * 735.0 / (unsigned)(p_rating / 100);
	if (fprintf(fp, "%f ", p_rating) == EOF)
		errors("Error: Cannot write to disk (Disk full ?)");
	fclose(fp);
	return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

int main(int argc, char **argv)
{
	// Check if it was called with correct arguments.
	open_stderr();
	get_cmdline();

	if (!strcmp(cmdline, "getspeed")) return(getspeed());

	return 0;
}