/*
 * PARALLEL.C - Contains parallel port functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _PARALLEL_CC_

#include "parallel.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

#define ENTRIES 6

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 unsigned short prn[3];

 // Create output file.
 if ((fp = fopen("parallel.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nPARALLEL PORT(S) INFORMATION :\n\n");

 // Get Parallel ports information.
 dosmemget(0x408, 6, (char *)prn);
 sprintf(output, "\tParallel Port 1 installed      : %s\n",
		(*prn) ? "Yes" : "No");
 writestring(output);
 if (prn[0]) {
	writestring("\tParallel Port Name             : LPT1\n");
	sprintf(output, "\tPort ID                        : %Xh\n", prn[0]);
	writestring(output);
 }

 sprintf(output, "\tParallel Port 2 installed      : %s\n",
		(prn[1]) ? "Yes" : "No");
 writestring(output);
 if (prn[1]) {
	writestring("\tParallel Port Name             : LPT2\n");
	sprintf(output, "\tPort ID                        : %Xh\n", prn[1]);
	writestring(output);
 }
 sprintf(output, "\tParallel Port 3 installed      : %s\n",
		(prn[2]) ? "Yes" : "No");
 writestring(output);
 if (prn[2]) {
	writestring("\tParallel Port Name             : LPT3\n");
	sprintf(output, "\tPort ID                        : %Xh\n", prn[2]);
	writestring(output);
 }

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

// The main function.
int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
