/*
 * PINLOAD.CC - Contains Information Modules management functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _PINLOAD_CC_

#include "pciagp.h"

int pinrun(const char *pinfile, const char *file)
{
 FILE *fp, *tfp;
 int found = 0;
 char fname[100], buffer[4096];
 unsigned long size, offset = 0, f;
 int retval = -1;

 // Try to open file.
 if ((fp = fopen(pinfile, "rb")) == NULL) return (retval);

 do {
    if ((!fread(fname, 100, 1, fp)) ||
       (!fread(&size, sizeof(size), 1, fp))) break;

    if (!strcmp(file, fname)) {
       found = 1;
       break;
    }
    // Change file pointer.
    fseek(fp, ftell(fp) + size, SEEK_SET);

 } while (offset < (unsigned long)filelength(fileno(fp)));
 if (!found) {
    fclose(fp);
    return (retval);
 }
 // Copy contents to temporary file.
 if ((tfp = fopen("pin.$$$", "wb")) == NULL) return (retval);

 for(f = 0; f < size / 4096; f++)
 {
  if (!fread(buffer, 4096, 1, fp)) break;
  if (!fwrite(buffer, 4096, 1, tfp)) break;
 }

 if (f != size / 4096) {
    fclose(fp);
    fclose(tfp);
    return (retval);
 }

 for(f = 0; f < size % 4096; f++)
 {
  if (!fread(buffer, 1, 1, fp)) break;
  if (!fwrite(buffer, 1, 1, tfp)) break;
 }

 if (f != size % 4096) {
    fclose(fp);
    fclose(tfp);
    return (retval);
 }

 fclose(fp);
 fclose(tfp);
 retval = spawnl(P_WAIT, "pin.$$$", "", NULL);
 unlink("pin.$$$");
 return (retval);
}

int pinrun(void *pinbuffer, const char *file, int nfiles)
{
 FILE *tfp;
 int found = 0;
 unsigned long size, offset = 0, f;
 int retval = -1;

 // Try to open file.
 if (pinbuffer == NULL) return (retval);

 do {
    size = *(unsigned long *)((unsigned long)pinbuffer + 100);

    if (!strcmp(file, (char *)pinbuffer)) {
       found = 1;
       break;
    }
    // Change file pointer.
    pinbuffer = (void *)((unsigned long)pinbuffer + 100 + 4 + size);

 } while (++offset < (unsigned)nfiles);
 if (!found) return (retval);
 // Copy contents to temporary file.
 if ((tfp = fopen("pin.$$$", "wb")) == NULL) return (retval);

 pinbuffer = (void *)((unsigned long)pinbuffer + 100 + 4);

 for(f = 0; f < size / 4096; f++)
 {
  if (!fwrite(pinbuffer, 4096, 1, tfp)) break;
  pinbuffer = (void *)((unsigned long)pinbuffer + 4096);
 }

 if (f != size / 4096) {
    fclose(tfp);
    return (retval);
 }

 for(f = 0; f < size % 4096; f++)
 {
  if (!fwrite(pinbuffer, 1, 1, tfp)) break;
  pinbuffer = (void *)((unsigned long)pinbuffer + 1);
 }

 if (f != size % 4096) {
    fclose(tfp);
    return (retval);
 }

 fclose(tfp);
 retval = spawnl(P_WAIT, "pin.$$$", "", NULL);
 unlink("pin.$$$");
 return (retval);
}

void *pinload(const char *pinfile)
{
 FILE *fp;
 unsigned long size, f;
 void *buffer, *bufptr = NULL;
 if ((fp = fopen(pinfile, "rb")) == NULL) return (NULL);
 size = filelength(fileno(fp));
 if ((buffer = malloc(size)) == NULL) {
    fclose(fp);
    return (NULL);
 }

 bufptr = buffer;
 fflush(stdout);

 for(f = 0; f < size / 4096; f++, bufptr =
                                  (void *)((unsigned long)bufptr + 4096))
 if (!fread(bufptr, 4096, 1, fp)) {
    fclose(fp);
    free(buffer);
    return (NULL);
 }

 for(f = 0; f < size % 4096; f++, bufptr =
                                  (void *)((unsigned long)bufptr + 1))
 if (!fread(bufptr, 1, 1, fp)) {
    fclose(fp);
    free(buffer);
    return (NULL);
 }
 printf("\n");
 return (buffer);
 return (fp);
}

void *pinseek(void *pinbuffer, const char *file, int nfiles)
{
 int found = 0;
 unsigned long size, offset = 0;
 void *retval = NULL;

 // Try to open file.
 if (pinbuffer == NULL) return (retval);

 do {
    size = *(unsigned long *)((unsigned long)pinbuffer + 100);

    if (!strcmp(file, (char *)pinbuffer)) {
       found = 1;
       break;
    }
    // Change file pointer.
    pinbuffer = (void *)((unsigned long)pinbuffer + 100 + 4 + size);

 } while (++offset < (unsigned)nfiles);
 if (!found) return (retval);

 // Return the pointer to the header.
 return (pinbuffer);
}

