/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** DRAW.CC: This file is part of the BETATRON library and can be used
 **          and/or distributed only under the terms of the GNU Library
 **          General Public License. See doc/readme.1st for details.
 */



#include "world.h"
#include "plvga.h"
#include <string.h>
#include "cb.h"

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

	void TOworld::refresh()
	{
	 if (curmode==gmMODEX320x200)
	 {
	  drawall(backofs);
	  drawall(drawofs);
	 }
	 else
	 {
	  drawallvesa();
	  Mcb2Vcbsolid(bufofs,0,0,	drawofs,0,0,   Xlen,Ylen);
	 }

	 refreshbit=1;
         palettechanged=1;
	};


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

void TOworld::refreshtiles1() // to proto miso antigrafei ta nea tiles sti drawofs, kai backofs
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short tileno;	 //  ⮦ tile

  unsigned short *lay;	  // layer  餜  椞 騘
  unsigned short *lay2;   // fore layer
  unsigned short laystep=length-22;
  signed char dwx,dwy;
  char *tilere;
  unsigned short tilestep=MAXXTILES+2 - 22;

  //    tile (tilex,tiley) 坜  橣 
  //    椞

  lay = Pbacklayer + ((wy*length) + wx);
  lay2 = Pforelayer + ((wy*length) + wx);

  tilere=(char *)&tilerefresh[1+(long)wy-wy0][1+(long)wx-wx0];

  for (j0=0;j0<15;j0++,lay+=laystep,lay2+=laystep,tilere+=tilestep)
   for (i0=0;i0<22;i0++,lay++,lay2++,tilere++)
   {
    if ( ! (*tilere))  continue;

    tileno= *lay;
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      drawstile(Ptiles[tileno & 32767],i0,j0,drawofs);	// tipose solid tile

    tileno= *lay2;
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      drawttile(Ptiles[tileno & 32767],i0,j0,drawofs); // tipose thru tile

    v2v(drawofs,(i0<<2),j0<<4,backofs,i0<<2,j0<<4,4,16);
   }
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void TOworld::refreshtiles2()
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  signed char dwx,dwy;
  char *tilere;
  unsigned short tilestep=MAXXTILES+2 - 22;

  tilere=(char *)&tilerefresh[1+(long)wy-wy0][1+(long)wx-wx0];

  for (j0=0;j0<15;j0++,tilere+=tilestep)
  {
   for (i0=0;i0<22;i0++,tilere++)
    if (*tilere)
      v2v(backofs,(i0<<2),j0<<4,drawofs,i0<<2,j0<<4,4,16);
  }

}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void TOworld::drawbackground(unsigned short layer)
{
 unsigned short tileno;
 unsigned short *lay;
 unsigned short i0,j0;
 short step=length-22;
 char *fore;
 short forestep=MAXXTILES-22;
 void (*Pdrawtile)(char *,unsigned char,unsigned char,unsigned short);

  lay = layers[layer] + ((wy*length) + wx);

  fore=(char *)forerefresh[0]; // min ksexnas oti oi 2 diastaseon pinakes
			    // exoun sinexomena stoixeia kai den
			    // einai 1 diastaseis pinakes deikton

       if (layer==LAY_BACK) Pdrawtile=drawstile;
  else if (layer==LAY_FORE) Pdrawtile=drawttile;

  for (j0=0;j0<15;j0++,fore+=forestep,lay+=step)
   for (i0=0;i0<22;i0++,fore++,lay++)
   {
     if ( ! (*fore) ) continue;

     tileno=(*lay);
     if (tileno!=65535)
     if (tileno & 32768)
     Pdrawtile(Ptiles[tileno & 32767],i0,j0,drawofs);  // tiposi solid i thru
   }

};


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

void TOworld::erasesprites()
{
 int i;
 TOsprite *plist,*ptmp;
 unsigned short clipx1,clipy1,clipx2,clipy2;
 unsigned short x4,y4,len4,hei4; // x: tetrades apo arxi drawofs,len4: mikos se tetrades
 unsigned short x11,y11,x12,y12;
 short res;

 x11=wx<<4; y11=wy<<4; x12=x11+351; y12=y11+239;

 for (i=0;i<PRIORITIESNO;i++) // to i metraei layer proteraiotitas
 {
  for (plist=(TOsprite *)priorities[i];plist;)
  {
     if (!plist->framesbit)  // an den exei frames proxora parakato
     {
      plist=(TOsprite *)plist->Pnext2;
      continue;
     }

     //an einai enrgopoiimeno to deadbit i to antikeimeno den itan orato
     //sto proigoumeno frame tote pigaine parakato

     if ( (!plist->deadbit) && (plist->oldvisbit!=VIS_INVISIBLE))
     {
      clipx1=plist->oldx;
      clipy1=plist->oldy;
      clipx2=clipx1+plist->oldlen - 1;
      clipy2=clipy1+plist->oldhei - 1;

      MACROcmplace(x11,y11,x12,y12,clipx1,clipy1,clipx2,clipy2,res);
      if ( res )
       {
	x4 = (( clipx1 - (wx << 4) ) >> 2); // kathe grammi tis video ram 352 / 4 dieuthinseis
	y4 =  clipy1 - (wy << 4) ;
	len4 = ((clipx2 - (wx << 4) ) >> 2) - x4+1;
	hei4 = clipy2 - clipy1 + 1;
	// ananeose to background svinontas ta palia sprites
	v2v(backofs,x4,y4,drawofs,x4,y4,len4,hei4);
       }
     }


     plist->oldvisbit=plist->visbit;
     plist->oldx=plist->clipx;	      // antegrapse stis sintetagmenes oldx,,
     plist->oldy=plist->clipy;	    // tis sintetagmenes clipping gia ton
     plist->oldlen=plist->cliplen;    // epomeno kuklo
     plist->oldhei=plist->cliphei;

     ptmp=plist;  plist=(TOsprite *)plist->Pnext2;


     // einai na diagrafei auto to sprite
     if (ptmp->deletebit)
     {
       removeobj(ptmp);      // afairese to apo ton kosmo
       delete ptmp;	     // diagrapse to
     }
     else if (ptmp->removebit)
       removeobj(ptmp);     // afairese to aplos apo ton kosmo

   }
 }



// oi parakato grammes einai gia ta windows 95
// anakalipsa oti ta windows 95 einai vitsioza
// kai apaitoun na ginei mia toulaxiston video
// to video metafora gia na kanoun sosta to
// screen update. Gi auto evala tis parakato
// grammes kodika oi opoies metaferoun akrivos
// ena byte apo tin backofs stin drawofs oste
// na ikanopoithoun ta windows se periptosi
// pou den simvei kamia tetoia metafora kata
// ton parapano broxo

asm("                      \n \
   pusha		   \n \
	pushw %%es		\n \
   xorl  %%edi,%%edi	   \n \
   xorl  %%esi,%%esi	   \n \
			   \n \
	movw	$0x03ce,%%dx	  \n \
	movb	$0x05,%%al	  \n \
	outb	%%al,%%dx	  \n \
	incw	%%dx		  \n \
	inb	%%dx,%%al	  \n \
	pushw	%%ax		  \n \
	andb	$0B11111111^0x02,%%al  \n \
	orb	$0x01,%%al	       \n \
	outb	%%al,%%dx	       \n \
				\n \
	movw	_pl_a000h,%%ax	       \n \
	movw	%%ax,%%es	       \n \
	movw	     %0 ,%%di	       \n \
	movw	     %1 ,%%si	       \n \
	movb	%%es:(%%edi),%%al      \n \
	movb	%%al,%%es:(%%esi)      \n \
				\n \
				\n \
				\n \
	movw	$0x03ce,%%dx	       \n \
	popw	%%ax		       \n \
	movb	%%al,%%ah	       \n \
	movb	$0x05,%%al	       \n \
	outw	%%ax,%%dx	       \n \
				\n \
	popw	%%es		       \n \
   popa": : "m" (backofs), "m" (drawofs));

};



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

///////// allagi se vesa compatible mode
////////
void TOworld::drawsprites(unsigned char low,unsigned char high)
{
 short i;
 short j,k;

 unsigned short clipx1,clipy1,clipx2,clipy2; // sintetegmenes clipping os pros
					     // tin arxi tou sprite
 unsigned short tmpx1,tmpy1;	// voithitikes sintetagmenes
 unsigned short curx1,cury1;	// sintetagmenes tou trexon sprite os pros tin arxi
			      // tou kosmou
 unsigned short curx2,cury2; // mikos , ipsos tou trexontos sprite
 unsigned short ftilex,ftiley,ftiley2;	  //  x1, y1,y2 ston pinaka ananeosis foreground
 unsigned char ftilelen;	  // mikos pou katalambanei to frame
				  // ston pinaka ananeosis tou foreground (se tiles)
 unsigned short sfno;	     // sub frame no
 TOobject *plist;
 TPframedescr fdescr;	  // deiktis se frame descriptor
 TPbitmap  pbitmap;	 // deiktis se bitmap

 char *fdata;		// deiktis stin arxi tis perigrafis ton subframes
 unsigned short dx0 = (wx << 4);
 unsigned short dy0 = (wy << 4);
 short res;
 char res2;
 char *drawdata;
 unsigned short x2s=x+Xres-1;
 unsigned short y2s=y+Yres-1;


 for (i=low;i<=high;i++) // to i metraei layer proteraiotitas
 {
  for (plist=priorities[i];plist;plist=plist->Pnext2)
  {
   if (plist->deadbit || plist->removebit || plist->deletebit) continue;
   //an einai enrgopoiimeno to deadbit
   // tote agnoise to trexon sprite
   curx1=plist->x;
   cury1=plist->y;

   if (! (plist->framesbit) )	// den exei frames einai tipou TOobject
   {
     curx2=curx1+plist->slen;  // mikos tou sprite to statiko mikos
     cury2=cury1+plist->shei;  // kai ipsos tou sprite to statiko ipsos
     // these aplos to visbit
     MACROcmplace2(x,y,x2s,y2s,curx1,cury1,curx2,cury2,res,res2);
     if (!res) plist->setvisbit(VIS_INVISIBLE); else
     if (res && !res2) plist->setvisbit(VIS_PARTIAL); else
     plist->setvisbit(VIS_FULL);
     continue;
   }
   // diaforetika (exei frames )

   fdescr=framesdescr[ ((TOsprite * ) plist)->framebase+((TOsprite *)plist)->framenow];
   if (!fdescr) continue; // sinexise an deixnei se NULL frame descriptor
   curx1+=fdescr->xdispl;
   cury1+=fdescr->ydispl;

   clipx1=curx1;
   clipy1=cury1;

   clipx2=clipx1+fdescr->len-1;
   clipy2=clipy1+fdescr->hei-1;



    MACROcmplace2(x,y,x2s,y2s,clipx1,clipy1,clipx2,clipy2,res,res2);
   if ( res )
   {
    if (!res2) plist->setvisbit(VIS_PARTIAL); else
    plist->setvisbit(VIS_FULL);

    //fdata einai deiktis stin arxi perigrafis ton subframes
    fdata = (char *) fdescr->data;
    // etoimasou na enimeroseis ton pinaka ananeosis tou foreground
    ftilex= (clipx1 >> 4) - wx;
    ftiley= (clipy1 >> 4) - wy;
    ftilelen = (clipx2 >> 4) -wx -ftilex + 1;
    ftiley2 = (clipy2 >> 4) - wy;
    // enimerose ton pinaka ananeosis tou foreground
    for (k=ftiley;k<=ftiley2;k++)
     memset(&(forerefresh[k][ftilex]),1,ftilelen);


    // etoimasou na filakseis tis sintetegmenes clipping gia na sbhstei
    // argotera to sprite apo tin othoni
    ((TOsprite *)plist)->clipx=clipx1;
    ((TOsprite *)plist)->clipy=clipy1;
    ((TOsprite *)plist)->cliplen=clipx2-clipx1+1;
    ((TOsprite *)plist)->cliphei=clipy2-clipy1+1;


    if ( fdescr->bitmapsno==1 )  // i pio pithani periptosi ksexorista
    {
      sfno=  *((unsigned short *)(fdata+4));
      pbitmap=bitmaps+sfno;

      if (!(pbitmap->data) ) continue;	  // pare deikti sto pixelmap tou sub frame
      drawdata=pbitmap->data;


      switch ( pbitmap->drawmethod)
      {
	 case DR_SOLID:     // solid clipping
		       M2Vsolidproc(drawdata,drawofs,clipx1-dx0,clipy1-dy0,
		       clipx2-clipx1+1,clipy2-clipy1+1,clipx1-curx1,clipy1-cury1,
		       pbitmap->len,pbitmap->hei);

		       break;

	 case DR_THRU:
		       M2Vthruproc(drawdata,drawofs,clipx1-dx0,clipy1-dy0,
		       clipx2-clipx1+1,clipy2-clipy1+1,clipx1-curx1,clipy1-cury1,
		       pbitmap->len);

		       break;

	 case DR_RLE:
		      M2Vrleproc(drawdata,drawofs, clipx1-dx0, clipy1-dy0,
		       clipx1-curx1, clipy1-cury1, clipx2-clipx1+1,
		       clipy2-clipy1+1);

		      break;

      } //switch
    }
    else
    for (j=0;j<fdescr->bitmapsno;j++) // etoimasou na tiposeis 1-1 ta subframes
    {
     clipx1= *((unsigned short *)fdata) +curx1; // x-sintetegmeni arxis subframe
     fdata+=2;	       // deikse sto sfy
     clipy1= *((unsigned short *)fdata) + cury1;
     fdata+=2;	      // deikse sto frameno
     sfno=  *((unsigned short *)fdata);
     fdata+=2;

     pbitmap=bitmaps+sfno;
     if (!(pbitmap->data)) continue;	// pare deikti sto pixelmap tou sub frame

     clipx2=clipx1+pbitmap->len-1;
     clipy2=clipy1+pbitmap->hei-1;

     tmpx1=clipx1;
     tmpy1=clipy1;

     MACROcmplace(x,y,x2s,y2s,clipx1,clipy1,clipx2,clipy2,res);
     if ( res )
     {
      drawdata=pbitmap->data;

      switch (pbitmap->drawmethod)
      {
	 case DR_SOLID:     // solid clipping
		       M2Vsolidproc(drawdata,drawofs,clipx1-dx0,clipy1-dy0,
		       clipx2-clipx1+1,clipy2-clipy1+1,clipx1-tmpx1,clipy1-tmpy1,
		       pbitmap->len,pbitmap->hei);

		       break;

	 case DR_THRU:		       // thru clipping
		      M2Vthruproc(drawdata,drawofs,clipx1-dx0,clipy1-dy0,
		      clipx2-clipx1+1,clipy2-clipy1+1,clipx1-tmpx1,clipy1-tmpy1,
		      pbitmap->len);

		      break;

	 case DR_RLE:
		      M2Vrleproc(drawdata,drawofs, clipx1-dx0, clipy1-dy0,
		      clipx1-tmpx1, clipy1-tmpy1, clipx2-clipx1+1,
		      clipy2-clipy1+1);

		      break;
      }

     }

    }

  }
  else plist->setvisbit(VIS_INVISIBLE);

 }

 }
};
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------





void TOworld::drawall(unsigned short pageofs)
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short tileno,tileno2;	 //  ⮦ tile

  unsigned short *lay,*lay2;	// layer  餜  椞 騘
  unsigned short step=length-Xtiles;

  //    tile (tilex,tiley) 坜  橣 
  //    椞

  lay = Pbacklayer + wy*length + wx;
  lay2= Pforelayer + wy*length + wx;


  for (j0=0;j0<Ytiles;j0++,lay+=step,lay2+=step)
   for (i0=0;i0<Xtiles;i0++,lay++,lay2++)
   {
     tileno=(*lay);
     if (tileno != 65535)	       // 65535: min tiposeis tipota
       drawstile(Ptiles[tileno & 32767],i0,j0,pageofs);  // tipose solid tile

     tileno2=(*lay2);
     if (tileno2 != 65535)		// 65535: min tiposeis tipota
       drawttile(Ptiles[tileno2 & 32767],i0,j0,pageofs); // tipose thru tile
   }

}




//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
// row se tetrades apo tin dieuthinsi pageofs


void  TOworld::drawrow(unsigned char row, unsigned short pageofs) //坜  tile 
{
  unsigned char i0   ;		 // (i0,row) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short j,k;
				 //   橣
  unsigned short tileno,tileno2; //  ⮦ tile
  register unsigned short *lay,*lay2;	  // layer  餜  椞 騘
  unsigned char tilerow; // to row tou tile pou tha tipothei



  j = ((wy<<2) + row);
  tilerow = j & 3;   // mod 4
  j>>=2;    // j to tile pou antistoixei sto row
  row>>=2;  // kai to row na ginei se 16ades

  lay  = Pbacklayer+ ( (j*length) + wx);
  lay2 = Pforelayer + ( (j*length) + wx);

#define BROXOS1()  for (i0=0;i0<22;i0++) \
  {                         \
    tileno=(*lay);          \
    if (tileno != 65535)    \
    {                       
#define BROXOS2()   }      \
    lay++;                 \
    tileno2=(*lay2);       \
    if (tileno2 != 65535)  \
    {                      
#define BROXOS3()   }      \
    lay2++;                \
  }


#if  SCROLLROWHEI2 == 2
   BROXOS1()
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow);
   BROXOS2()
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow);
   BROXOS3()
#elif  SCROLLROWHEI2 == 3
   BROXOS1()
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow);
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow+1);
   BROXOS2()
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow);
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow+1);
   BROXOS3()
#elif  SCROLLROWHEI2 == 4
   BROXOS1()
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow);
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow+1);
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow+2);
   drawsrowtile(Ptiles[tileno & 32767],i0,row,pageofs,tilerow+3);
   BROXOS2()
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow);
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow+1);
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow+2);
   drawtrowtile(Ptiles[tileno2 & 32767],i0,row,pageofs,tilerow+3);
   BROXOS3()
#else
#error SCROLLROWHEI2 can take only the values 2,3,4
#endif


#undef BROXOS1
#undef BROXOS2
#undef BROXOS3
}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------


// col se 4ades  se sxesi me to pageofs

void  TOworld::drawcol(unsigned char col,unsigned short pageofs) //坜  tile 㢞
{
  unsigned char j0;		 // (col,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short i,k;
  unsigned short tileno,tileno2;	 //  ⮦ tile
  register unsigned short *lay,*lay2;	 // layers back kai fore
  unsigned char tilecol;


  i=( (wx<<2) + col);
  tilecol = i &3;	 // pia stili mesa sto tile
  i>>=2;		 // i: tilex ston kosmo
  col>>=2;		 // pio tilex sti selida

  lay = Pbacklayer+ ( (wy*length) + i);
  lay2= Pforelayer+ ( (wy*length) + i);


#define BROXOS1() for (j0=0;j0<15;j0++) \
  {                                     \
    tileno= (*lay);                     \
    if (tileno != 65535)                \
    {
#define BROXOS2()  }         \
    lay+=length;             \
    tileno2= (*lay2);        \
    if (tileno2 != 65535)    \
    {
#define BROXOS3()     }      \
    lay2+=length;            \
  }


#if SCROLLCOLLEN2 == 2
    BROXOS1()
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol);
    BROXOS2()
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol);
    BROXOS3()
#elif SCROLLCOLLEN2 == 3
    BROXOS1()
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol);
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol+1);
    BROXOS2()
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol);
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol+1);
    BROXOS3()
#elif SCROLLCOLLEN2 == 4
    BROXOS1()
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol);
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol+1);
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol+2);
    drawscoltile(Ptiles[tileno & 32767],col,j0,pageofs,tilecol+3);
    BROXOS2()
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol);
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol+1);
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol+2);
    drawtcoltile(Ptiles[tileno2 & 32767],col,j0,pageofs,tilecol+3);
    BROXOS3()
#else
#error SCROLLCOLLEN2 can take only the values 2,3,4
#endif
 
 

#undef BROXOS1
#undef BROXOS2
#undef BROXOS3
}


