/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** GRID.H: This file is part of the BETATRON library and can be used
 **         and/or distributed only under the terms of the GNU Library
 **         General Public License. See doc/readme.1st for details.
 */


#ifndef pl_grid_h
#define pl_grid_h

#include "sprite.h"
#include "world.h"

#define DEFCELLL		 7
#define DEFCELLH		 7
#define DEFMAXOBJSNO			 1000
#define ERR_GRIDMADE			-305
#define ERR_GRIDNOTMADE 		-307

// max dimensions of grid cell 256x256
#define MAXGRIDCELLL			 8
#define MAXGRIDCELLH			 8
#define MAXMAXOBJSNO				 10000
#define ERR_TOOMANYLISTS			-306

#define MAXLISTS					 15

struct Tobjptrlist
{
  TOobject *obj;
  Tobjptrlist *next;  // arxika auto tha itan short,displacement
			  // os pros tin arxi data tou buffer
};

typedef Tobjptrlist *TPobjptrlist;

struct Tclustergrid
{
 private:
   long bufsize;					// size of the buffer
   long nowpos; 					// position in the buffer
   char *data;					// the memory reserved for the buffer
   short initbuffer(long size0);
   void  *getmem(unsigned short size0); // gets the next size bytes
   void freebuffer();
   void zerobuffer()  { nowpos=0; }
//////////////////////////////////////////////////////////////////////////
//// metavlites pou xrisimopoiountai apo tis getfirst(), getnext()
   TPobjptrlist element;
   TOworld	*world;

public:
   unsigned short len,hei;	 // dimensions of the grid in grid cells
   unsigned char l2,h2; 	 // dimensions of the grid cell in 2's powers
				 // (gridlength=1 << l2 );
   unsigned short maxobjsno; // posoi to poli deiktes antikeimenon sto grid
   TPobjptrlist *grid;		 // pinakas *Tobjptrlist stoixeion

   short lists[MAXLISTS];
   short listsno;		 // howmany lists


   TOobject *gridcollision(TOobject *o);
   inline void getgridarea(TOobject *o,unsigned short &x1,unsigned short &y1,
									   unsigned short &x2,unsigned short &y2);
   inline TOobject *getfirst(unsigned short gridx,unsigned short gridy);
   inline TOobject *getnext();
   short setparameters(unsigned char l20,unsigned char h20,unsigned short maxobjsno0);
   short makegrid(unsigned short length,unsigned short height,TOworld *w);
   short addfirstlist(short list);
   short addlist(short list);
   void clusterize();
   void done();

   Tclustergrid();
  ~Tclustergrid();
};




void Tclustergrid::getgridarea(TOobject *o,unsigned short &x1,unsigned short &y1,
				   unsigned short &x2,unsigned short &y2)
{
 x1 = o->x >> l2;
 x2 = (o->x+o->slen-1) >> l2;
 y1 = o->y >> h2;
 y2 = (o->y + o->shei -1 ) >> h2;
}

TOobject *Tclustergrid::getfirst(unsigned short gridx,unsigned short gridy)
{
 TOobject *o;
 element=grid[gridy*len+gridx];
 return getnext();
}

TOobject *Tclustergrid::getnext()
{
 TOobject *o;

 if (element)
 {
  o=element->obj;
  element=element->next;
  return o;
 }
 return NULL;
}



#endif
