#include <stdio.h>
#include <string.h>

static char line[1024];

void usage()
{
 printf("usage : parsemap <file> <command>\n");
 exit(1);
}

void error(char *s)
{
 printf("Error : %s\n",s);
 exit(1);
}

void listobj(FILE *stream)
{
 char *pos;
 while (!feof(stream))
 {
  fgets(line,1023,stream);
  if (strstr(line,"Allocating common symbols")) break;
  if (!(pos=strstr(line,".a("))) continue;
  if (strchr(strchr(pos,')')+1,'(')) continue;
  *strchr(pos,')')=0;
  printf("%s\n",pos+3);
 }
}

void listsym(FILE *stream)
{
 char *pos,*suffix="?";
 int first=1;
 while (!feof(stream))
 {
  if (!fgets(line,1023,stream)) break;
  if (!strncmp(line,"OUTPUT",6)) break;
  if (*line!='.') if (first) continue; else; else
   { /* Section found */
    first=0;
    if (!strncmp(line+1,"text",4)) suffix="";
     else if (!strncmp(line+1,"data",4)) suffix="D";
      else if (!strncmp(line+1,"bss",3)) suffix="C";
       else suffix=0;
    continue;
   }
  if (line[1]!=' ') continue;
  if (strstr(line,"=.")||strstr(line,".=")) continue;
  if (line[36]!=' ') continue;
  line[strlen(line)-1]=0; /* remove EOL */
  if (strncmp(line+42,"_dlm",4))
   if (strncmp(line+42,"_sym",4))
    if (strncmp(line+42,"_hash",5))
     if (strcmp(line+42,"start"))
      if (strcmp(line+42,"exception_stack"))
       if (suffix) printf("EXP%s(%s)\n",suffix,line+42);
 }
}

int main(int argc,char **argv)
{
 FILE *stream;
 char *cmd;
 if (argc<3) usage();
 stream=fopen(argv[1],"rt");
 if (!stream) error("file not found");
 cmd=argv[2];
 switch (*cmd)
 {
  case 'o' : /* List used objects */
    listobj(stream);
   break;
  case 's' : /* List used symbols */
    listsym(stream);
   break;
  default :
   error("invalid command - only 'o' and 's' are valid");
 }
 return 0;
}

