/****************************************************************************/
/* ERRORS                                                                   */
/*--------------------------------------------------------------------------*/
/* Fonctions de gestion des erreurs de la librairie JPTUI                   */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 24/02/95                                                    */
/****************************************************************************/

#include <stdlib.h>
#include <iostream.h>

#include "Const.h"
#include "Vocab.h"

#include "Sound.h"
#include "Screen.h"

#include "Errors.h"

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* AbortProgram                                                             */
/*--------------------------------------------------------------------------*/
/* Aborts the program without displaying any message			    */
/****************************************************************************/

void AbortProgram()
{
  _exit(EXIT_FAILURE);
}


/****************************************************************************/
/* FatalError                                                               */
/*--------------------------------------------------------------------------*/
/* Quitte l'application et affiche le message d'erreur                      */
/****************************************************************************/

void FatalError(char *message)
{
  TextError(message);
  AbortProgram();
}

/****************************************************************************/
/* TextError                                                                */
/*--------------------------------------------------------------------------*/
/* Ferme l'cran "graphique" et et affiche le message d'erreur              */
/****************************************************************************/

void TextError(char *message)
{
  CloseScreen();
  cerr << "\n\n" << message << "\n\n";
  PlaySound(ERROR_SOUND);
}



