/****************************************************************************/
/* TFRAME                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TFrame (Group d'objets entours d'un cadre)                        */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>

#include "Const.h"

#include "Mouse.h"

#include "TWindow.h"
#include "TFrame.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y     : Coordonnes du Frame p/r au groupe                    */
/* width,height     : Dimensions du Frame                                   */
/* caption          : Lgende du Frame (hot-key prcde de ~)              */
/* enabled          : ENABLED si le Frame est activable (DISABLED sinon)    */
/****************************************************************************/

TFrame::TFrame(PObject parent,
	       int rel_x,int rel_y,
	       int width,int height,
	       char *caption,
	       boolean enabled)
       :TGroup(parent,
	       OBJ_FRAME_GROUP,
	       rel_x,rel_y,
	       width,height,
	       (parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
	       caption,
	       enabled,
	       FALSE,  // NOT_FOCUS_DEPENDING_ASPECT
	       TRUE,   // CAN_BE_ENABLED
	       TRUE)   // NEED_FOCUSED_ELEMENT
{
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TFrame::~TFrame()
{
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TFrame::m_display_caption()
{
  int x1,y1,x2,y2;

  if (!f_open)
    return;

  x1=m_get_x_in_window();
  y1=m_get_y_in_window();
  x2=x1+f_width-1;
  y2=y1+f_height-1;

  f_window->m_draw_frame(x1,y1,x2,y2,f_background,f_caption,f_enabled);
}

