/****************************************************************************/
/* TTEXTZN                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TTextZone (Zone d'dition de texte)                                */
/****************************************************************************/

#ifndef _TTEXTZN_H_
#define _TTEXTZN_H_


#include "Keyboard.h"
#include "Types.h"

#include "TObject.h"

// Vitesse de dfilement du texte

#define TEXTZONE_FIRST_SCROLL_SPEED   150
#define TEXTZONE_SCROLL_SPEED         70

// Objet pour les informations complmentaires sur les lignes du texte

class TLineProperties
{
  public:

	     TLineProperties();
    virtual ~TLineProperties();
};

typedef TLineProperties    *PLineProperties;


// Type TText (Liste double-chane de chaines)

typedef struct string_node
{
  char               *string;
  PLineProperties    properties;  // Peut tre NULL

  struct string_node *next,*last;
} TStringNode,*PStringNode,*PText;


class TTextZone:public TObject
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Position /Dimensions de la zone de texte elle-mme p/r  l'objet

    int     f_text_rel_x,
	    f_text_rel_y;
    int     f_text_width,
	    f_text_height;

    // Nombre maximal de colonnes du texte
    // Nombre de lignes actuel du texte

    int     f_nb_cols;
    int     f_nb_lines;

    // Tab size (when using m_insert_line, m_set_line...)

    int     f_tab_size;

    // Modification du texte autorise

    boolean f_modification_enabled;

    // Texte contenue dans la TextBox

    PText   f_text;

    // Elments spciaux du texte

    PStringNode
            f_first_visible_string;     // Premire chane visible

    PStringNode
            f_last_string;              // Dernier lment de la liste

    PStringNode
            f_current_string;           // Une chane du texte qui vient
    int     f_current_string_line;      // d'tre utilise et sa ligne
                                        // (sert pour acclerer la lecture

    // Mode insertion/recouvrement
    // (champ commun  toutes les instances de l'objet)

    static
    int     f_cursor_style;

    // Premire colonne,ligne visible

    int     f_first_visible_col,
	    f_first_visible_line;

    // Une zone est slectionne ?

    boolean f_zone_selected;

    // Si oui :
    // -> caractres de position min et max de la zone slectionne
    // Si f_min_selected_col vaut f_nb_cols+1,
    // seul le saut de ligne de f_min_selected_line est compris
    // Si f_max_selected_col vaut 0,
    // cela signifie que la zone slectionne comprend le saut de ligne de
    // la ligne prcdente  (f_max_selected_line-1)

    int     f_min_selected_line,
	    f_min_selected_col;

    int     f_max_selected_line,
	    f_max_selected_col;

    // En cours de slection :
    // -> premier et dernier caractres slectionnes
    //    (par ordre de slection)

    int     f_first_selected_col,
	    f_last_selected_col;

    int     f_first_selected_line,
	    f_last_selected_line;

    // Position du cursor

    int     f_cursor_col,
	    f_cursor_line;

    // Ascenseurs

    PScrollBar
	    f_vertical_scrollbar,
	    f_horizontal_scrollbar;

    // Chane retourne par m_get_line

    char    *f_return_string;

    // Buffer pour la zone retourne par m_get_zone()

    char    *f_zone_buffer;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // Callback : Fonction appele si le nombre de lignes dans le texte
    //            change et son argument

    void    (*f_nb_lines_changed_action)(PObject,char *);
    char    *f_nb_lines_changed_argument;

    // Callback : Fonction appele  chaque modification de la chane
    //            et son argument

    void    (*f_text_changed_action)(PObject,char *);
    char    *f_text_changed_argument;

    // Callback : Fonction appele si la position du curseur change
    //            et son argument

    void     (*f_cursor_line_changed_action)(PObject,char *);
    char     *f_cursor_line_changed_argument;

    void     (*f_cursor_col_changed_action)(PObject,char *);
    char     *f_cursor_col_changed_argument;

    void     (*f_cursor_pos_changed_action)(PObject,char *);
    char     *f_cursor_pos_changed_argument;

    // Callback : Fonction appele si la partie visible (en hauteur)
    //            de la liste change et son argument

    void     (*f_visible_lines_changed_action)(PObject,char *);
    char     *f_visible_lines_changed_argument;

    void     (*f_visible_cols_changed_action)(PObject,char *);
    char     *f_visible_cols_changed_argument;

    // Callback : Fonction appele s'il y a/n'y a plus de zone slectionne

    void     (*f_selection_status_changed_action)(PObject,char *);
    char     *f_selection_status_changed_argument;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TTextZone(PObject parent,
		             int rel_x,int rel_y,
			     int width,int height,
			     char *caption,
			     int max_text_nb_cols,
			     TScrollbarChoice scrollbars=SBC_VERTICAL,
			     boolean enabled=TRUE);
    virtual         ~TTextZone();

    // Mthodes d'accs

	    void    m_set_cursor_at(int col,int line,boolean make_cursor_visible=TRUE);
            void    m_get_cursor_pos(int &col,int &line);

	    int     m_get_nb_lines() { return(f_nb_lines);};
            int     m_get_nb_cols()  { return(f_nb_cols);};

	    int     m_get_text_rel_x() { return(f_text_rel_x);};
	    int     m_get_text_rel_y() { return(f_text_rel_y);};
	    int     m_get_text_width() { return(f_text_width);};
	    int     m_get_text_height() { return(f_text_height);};

	    void    m_set_tab_size(int tab_size);
	    int     m_get_tab_size() { return(f_tab_size);};

	    void    m_set_first_visible_col(int col);
	    void    m_set_first_visible_line(int line);

	    int     m_get_first_visible_col() {return(f_first_visible_col);};
	    int     m_get_first_visible_line() {return(f_first_visible_line);};

	    int     m_line_length(int line_nb);

    virtual void    m_enable_modification()   {f_modification_enabled=TRUE;};
    virtual void    m_disable_modification()  {f_modification_enabled=FALSE;};


    // Effacement de texte
    // - m_delete_zone : first_col peut valoir f_nb_cols+1 ( partir saut de
    //                   ligne) et last_col 0 (jusqu'au saut de ligne)

            void    m_clear_text();
            void    m_delete_line(int line_nb);
            void    m_clear_zone(int first_col,int first_line,int last_col,int last_line);

    // Modification du texte

	    void    m_set_line(int line_nb,char *string)    {m_set_line(line_nb,string,NULL);};
	    void    m_insert_line(int line_nb,char *string) {m_insert_line(line_nb,string,NULL);};
	    void    m_insert_text(char *text);


    // Lecture de texte
    // - m_get_zone : first_col peut valoir f_nb_cols+1 et last_col 0
    //                Appeler m_free_zone quand on n'a plus besoin de la zone
    //                retourne
    // - m_free_zone_buffer libre le buffer allou par m_get_zone
    // - La chane retourne par m_get_line peut tre modifie sans
    //   consquence sur le texte

            char    *m_get_zone(int first_col,int first_line,int last_col,int last_line);
	    void    m_free_zone_buffer();
            char   *m_get_line(int line_nb);

    // Chargement/Sauvegarde du texte (retourne FALSE si chec)

            boolean m_save_text(char *filename);
            boolean m_load_text(char *filename);

    // Modification de la partie slectionne du texte

	    void    m_select_zone(int pos1_col,int pos1_line,int pos2_col,int pos2_line);
	    void    m_unselect_zone();

	    // m_get_selected_zone n'a de sens que si m_zone_selected() est
	    // TRUE

	    boolean m_zone_selected() { return(f_zone_selected); }
	    void    m_get_selected_zone(int &min_col,int &min_line,int &max_col,int &max_line);

    // Oprations sur la partie slectionne du texte

	    void    m_cut_selection();
	    void    m_copy_selection();
            void    m_paste();
	    void    m_clear_selection();

    // Retourne un pointeur sur une des lignes du texte
    // La ligne doit exister

	    PStringNode
		    m_line_to_string(int  line);

    // Dfinition des callbacks

	    void    m_set_nb_lines_changed_callback(void (*nb_lines_changed_action)(PObject,char *),
						    char *nb_lines_changed_argument);

	    void    m_set_text_changed_callback(void (*text_changed_action)(PObject,char *),
						char *text_changed_argument);

	    void    m_set_cursor_line_changed_callback(void (*cursor_line_changed_action)(PObject,char *),
						      char *cursor_line_changed_argument);

	    void    m_set_cursor_col_changed_callback(void (*cursor_col_changed_action)(PObject,char *),
						      char *cursor_col_changed_argument);

	    void    m_set_cursor_pos_changed_callback(void (*cursor_pos_changed_action)(PObject,char *),
						      char *cursor_pos_changed_argument);

	    void    m_set_visible_lines_changed_callback(void (*visible_lines_changed_action)(PObject,char *),
							 char *visible_lines_changed_argument);

	    void    m_set_visible_cols_changed_callback(void (*visible_cols_changed_action)(PObject,char *),
							char *visible_cols_changed_argument);

	    void    m_set_selection_status_changed_callback(void (*selection_status_changed_action)(PObject,char *),
							    char *selection_status_changed_argument);


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:


	    void    m_set_line(int line_nb,char *string,PLineProperties properties);
	    void    m_insert_line(int line_nb,char *string,PLineProperties properties);

    // Affichage

    virtual void    m_display();
    virtual void    m_display_focus_depending_part();

	    void    m_display_lines(int first_line,int last_line);

    // Prise/Perte du focus

    virtual void    m_lose_focus();
    virtual void    m_take_focus();

    // L'objet devient actif/inactif

    virtual void    m_set_active(boolean active);

    // Ouverture/Fermeture de l'objet

    virtual void    m_set_open(boolean open);

    // Affichage

    virtual void    m_display_string_node(PStringNode node,int line);
    virtual void    m_display_string_part(char *string,int string_length,int min_col,int max_col,unsigned attribute);


    // Selected part of a line (0,0 if none)

	    void TTextZone::m_get_line_selected_part(int line,int &min_selected_col,int &max_selected_col);

    // Appel des callbacks

    static  void    m_horiz_scrollbar_value_changed_call(PObject scrollbar,char *argument);
    static  void    m_vert_scrollbar_value_changed_call(PObject scrollbar,char *argument);

    virtual void    m_nb_lines_changed_callback();

    virtual void    m_text_changed_callback();

    virtual void    m_cursor_line_changed_callback();
    virtual void    m_cursor_col_changed_callback();
    virtual void    m_cursor_pos_changed_callback();

    virtual void    m_visible_lines_changed_callback();
    virtual void    m_visible_cols_changed_callback();

    virtual void    m_selection_status_changed_callback();

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_left_button_double_click_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);

    virtual void    m_mouse_move_button_pressed(int x,int y,boolean selection);

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_caption();

	    void    m_display_text();

    // Caractres saisis

            void    m_character_hit(int character);

	    void    m_move_cursor_with_key_to(boolean shift_pressed,int new_cursor_col,int new_cursor_line);

	    void    m_ctrl_y_hit();

	    void    m_left_hit(boolean shift_pressed);
	    void    m_right_hit(boolean shift_pressed);
	    void    m_up_hit(boolean shift_pressed);
	    void    m_down_hit(boolean shift_pressed);
	    void    m_ctrl_left_hit(boolean shift_pressed);
	    void    m_ctrl_right_hit(boolean shift_pressed);

	    void    m_home_hit(boolean shift_pressed);
	    void    m_end_hit(boolean shift_pressed);
	    void    m_ctrl_home_hit(boolean shift_pressed);
	    void    m_ctrl_end_hit(boolean shift_pressed);

	    void    m_page_up_hit(boolean shift_pressed);
	    void    m_page_down_hit(boolean shift_pressed);
	    void    m_ctrl_page_up_hit(boolean shift_pressed);
	    void    m_ctrl_page_down_hit(boolean shift_pressed);

            void    m_return_hit();
            void    m_backspace_hit();
            void    m_tab_hit();

	    void    m_insert_hit(boolean shift_pressed);
	    void    m_ctrl_insert_hit();

	    void    m_delete_hit(boolean shift_pressed);

    // Longueur utile d'une chaine

	    int     m_useful_length(char *string);

    // Rduction/Expansion d'une ligne
    // (une ligne expanse a une longueur de f_nb_cols caractres,
    // alors qu'une ligne rduite ne comprend pas les espaces de fin de ligne)
    // Une ligne n'est expanse que quand la zone texte a le focus, et si
    // le curseur est situ sur cette ligne

            void    m_reduce_line(int line_nb);
            void    m_expand_line(int line_nb);

    // Modification de la position du curseur

            void    m_set_cursor_position(int col,int line,boolean make_cursor_visible);

    // Taille du buffer ncessaire pour stocker une zone de texte

	    unsigned
		    m_get_zone_size(int first_col,int first_line,int last_col,int last_line);

    // Correction des limites d'une zone

            boolean m_correct_zone_limits(int &first_col,int &first_line,int &last_col,int &last_line);

    // Recherche le prcdent alignement de texte dans les lignes prcdant
    // le curseur (dplacement suite  un backspace...)

            int     m_get_previous_tab(int max_value);

    // Insertion de n caractres identiques dans le texte

            void    m_insert_nch(int nb_chars,char character);

};

#endif