/****************************************************************************/
/* SPCHARS                                                                  */
/*--------------------------------------------------------------------------*/
/* Special chars of JPTUI (chars which depend on the font)  		    */
/****************************************************************************/

#ifndef _SPCHARS_H_
#define _SPCHARS_H_


#include "Screen.h"

// Special chars

enum {
	SCH_WINDOW_UP_LEFT=0,
	SCH_WINDOW_UP,
	SCH_WINDOW_UP_RIGHT,
	SCH_WINDOW_LEFT,
	SCH_WINDOW_RIGHT,
	SCH_WINDOW_BOTTOM_LEFT,
	SCH_WINDOW_BOTTOM,
	SCH_WINDOW_BOTTOM_RIGHT,

	SCH_FRAME_UP_RIGHT,
	SCH_FRAME_LEFT,
	SCH_FRAME_RIGHT,
	SCH_FRAME_BOTTOM_LEFT,
	SCH_FRAME_BOTTOM,
	SCH_FRAME_BOTTOM_RIGHT,

	SCH_TEXTZONE_UP_LEFT,
	SCH_TEXTZONE_UP,
	SCH_TEXTZONE_UP_RIGHT,
	SCH_TEXTZONE_LEFT,
	SCH_TEXTZONE_RIGHT,
	SCH_TEXTZONE_BOTTOM_LEFT,
	SCH_TEXTZONE_BOTTOM,
	SCH_TEXTZONE_BOTTOM_RIGHT,

	SCH_TABGROUP_UP_LEFT,
	SCH_TABGROUP_UP,
	SCH_TABGROUP_UP_RIGHT,
	SCH_TABGROUP_LEFT,
	SCH_TABGROUP_RIGHT,
	SCH_TABGROUP_BOTTOM_LEFT,
	SCH_TABGROUP_BOTTOM,
	SCH_TABGROUP_BOTTOM_RIGHT,

	SCH_TAB_CAPTION_LEFT,

	SCH_LISTBOX_UP_LEFT,
	SCH_LISTBOX_UP,
	SCH_LISTBOX_UP_RIGHT,
	SCH_LISTBOX_LEFT,
	SCH_LISTBOX_RIGHT,
	SCH_LISTBOX_BOTTOM_LEFT,
	SCH_LISTBOX_BOTTOM,
	SCH_LISTBOX_BOTTOM_RIGHT,

	SCH_SHAFT_HORIZONTAL,
	SCH_SLIDER_HORIZONTAL,

	SCH_COMBOBOX_UP_RIGHT,
	SCH_COMBOBOX_BOTTOM_RIGHT,

	SCH_LIST_CHECK,

	SCH_LAST };

// Special strings

enum {
	SST_ARROW_UP=0,
	SST_ARROW_DOWN,
	SST_ARROW_LEFT,
	SST_ARROW_RIGHT,

	SST_SHAFT_VERTICAL,
	SST_SLIDER_VERTICAL,

	SST_CHECKBOX_CHECKED,
	SST_CHECKBOX_UNCHECKED,

	SST_RADIOBUTTON_CHECKED,
	SST_RADIOBUTTON_UNCHECKED,

	SST_WINDOW_CLOSE_BUTTON,

	SST_TEXTZONE_SB_CORNER,

	SST_ICON_STOP,
	SST_ICON_QUESTION,
	SST_ICON_EXCLAMATION,
	SST_ICON_INFORMATION,

	SST_LAST };

extern TFont JPFont;
extern char  JPSpecialChar  [SCH_LAST][2];
extern char *JPSpecialString[SST_LAST][2];


#define SPECIAL_CHAR(c)	 	(JPSpecialChar  [(int)c][(int)JPFont])
#define SPECIAL_STRING(s)	(JPSpecialString[(int)s][(int)JPFont])

#endif