/****************************************************************************/
/* CURSOR                                                                   */
/*--------------------------------------------------------------------------*/
/* Text cursor functions   						    */
/****************************************************************************/

#ifndef _CURSOR_H_
#define _CURSOR_H_

#include "Types.h"

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

// Cursor style
// (style NO_CURSOR doesn't exist -> use HideTextCursor instead)

#define RECOVER_CURSOR 1
#define INSERT_CURSOR  2

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

// Sets/Gets the cursor style

void    SetTextCursorStyle(int cursor_style);
int     GetTextCursorStyle();

// Hides/Shows the text cursor

void HideTextCursor();
void ShowTextCursor();

// Sets the cursor position with/without changing the cursor style
void SetTextCursorAt(int x,int y);
void SetTextCursorAt(int x,int y,int cursor_style);

bool TextCursorIsVisible();
int     GetXTextCursor();
int     GetYTextCursor();

#endif
