/****************************************************************************/
/* MOUSE                                                                    */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation de la souris                                   */
/****************************************************************************/

#ifndef _MOUSE_H_
#define _MOUSE_H_

#include "Types.h"

/*ͻ*/
/*                                CONSTANTES                              */
/*ͼ*/

// Etat des boutons de la souris

#define NO_BUTTON_PRESSED     0
#define LEFT_BUTTON_PRESSED   1
#define RIGHT_BUTTON_PRESSED  2

// Dsignation des boutons

#define LEFT_BUTTON       0
#define RIGHT_BUTTON      1

// Dure autorise pour faire un double click (en ms)

#define MAX_DOUBLE_CLICK_DURATION 200

/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

// Mouse pointers

typedef enum {
	       MP_ARROW=0,
	       MP_HOURGLASS=1} TMousePointer;

// Mouse pointer aspect (displayed by JPTUI in a graphical or textual way, or
// displayed by the mouse driver)

typedef enum {
	       MPA_GRAPHICAL,
	       MPA_TEXTUAL,
	       MPA_MOUSE_DRIVER } TMousePointerAspect;

// 1er des caractres utiliss par le curseur graphique
// Fix: moved to header (used in ToScreenChar())
#define GMOUSE_1ST_CHAR 208

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

bool InitMouse();
void 	CloseMouse();
void    ShowMouse();
void    HideMouse();
void    GetMouseState(int &x,int &y,int &button_state);

// Changes the mouse pointer type to `cursor'.
// (useful only with a graphical pointer)

void    SetMousePointer(TMousePointer pointer);

// Returns the current mouse pointer type

TMousePointer GetMousePointer();

// Sets the aspect of the mouse pointer (graphical, textual, mouse driver...)

void SetMousePointerAspect(TMousePointerAspect aspect);

// Waits for the left button of the mouse to be released

void    WaitMouseLeftButtonRelease();

#endif
