/****************************************************************************/
/* TCOMBOBOX                                                                */
/*--------------------------------------------------------------------------*/
/* Objet TComboBox                                                          */
/****************************************************************************/

#ifndef _TCOMBBOX_H_
#define _TCOMBBOX_H_

#include "Types.h"

#include "TSmpList.h"
#include "TEdZone.h"

class TComboList;
class TComboBox:public TEditZone
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend class TComboList;

  /*------------------*/
  /* Protected fields */
  /*------------------*/

  protected:

    // The edition-zone contents have to be in the list

    bool f_string_must_be_in_list;


  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Dselectionne l'lment slectionn de la liste is le
    // contenu de la zone de saisie est modifi

    bool f_unselect_on_string_change;

    // Elment slectionne de la liste lorsqu'on l'ouvre

    int     f_selected_item_when_opening;

    // Liste

    PSimpleList f_list;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur/Destructeur
		    TComboBox(PObject parent,
			     int rel_x,int rel_y,
			     int xoffset_caption,int yoffset_caption,
			     const char *caption,
			     int display_length,
			     int max_length,
			     const char *string,
			     int list_height,
			     TListItem items[],
			     bool string_must_be_in_list,
			     bool sorted=false,
			     bool enabled=true);
		    ~TComboBox();

    // Mthodes d'accs

    virtual void    m_enable();
    virtual void    m_disable();

    virtual void    m_enable_modification()   {return;};
    virtual void    m_disable_modification()  {return;};

    virtual void    m_set_string(const char *string);

    // Recopie d'un lment de la liste dans la zone d'dition

	    void    m_set_string_from_list_item(int item_index) {f_list->m_set_selected_item_index(item_index);};

    // Accs  la liste de la combo-box

	    PSimpleList m_get_list() {return(f_list);};

    // Callback : Fonction appele lorsque le contenu de la combo-box
    //            est valide
	jptui::CallbackHolder	stringValidatedAction_;

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Affichage

    virtual void    m_display();

    // Ouverture/Fermeture de l'objet

    virtual void    m_set_open(bool open);

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_left_button_double_click_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);

    // Appel des callbacks

    virtual void    m_string_modified_callback();
    virtual void    m_string_validated_callback();

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

	    void    m_display_arrow();

    // Ouverture/Fermeture d'un menu

	    void    m_open_list();
	    void    m_close_list();

    // Slection d'un lment

	    void    m_select_item_if_none_is_selected();

    // Modification de la chane  partir de l'lment slectionn de la
    // liste (s'il y en a un)

	    void    m_set_string_from_selected_item();

};

#endif
