/****************************************************************************/
/* THELPWND.H                                                               */
/*--------------------------------------------------------------------------*/
/* THelpWindow class                                                        */
/*--------------------------------------------------------------------------*/
/* Auteur      : DELPRAT Jean-Pierre                                        */
/* Cr le     : 25/10/96                                                   */
/****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "Vocab.h"
#include "THelpTZ.h"
#include "TPushBut.h"
#include "TTextZn.h"


#include "THelpWnd.h"

#define MIN_WINDOW_WIDTH        40
#define MIN_WINDOW_HEIGHT       10

#define NB_BUTTONS               5

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* x,y              : Position de la fentre dans l'cran                   */
/* width,height     : Dimensions de la fentre                              */
/* caption          : Lgende de la fentre                                 */
/* info_bar         : Il y a une barre d'information ou pas                 */
/* modal            : Fentre modale ou non                                 */
/* movable          : Fentre dplaable ou non				    */
/****************************************************************************/


#include "Const.h"

#include "THelpWnd.h"

THelpWindow::THelpWindow(int x,int y,
			 int width,int height,
			 const char *caption,
			 bool modal,
			 bool movable)

	    :TWindow(HELP,
		     x,y,
		     MAX(width,MIN_WINDOW_WIDTH),
		     MAX(height,MIN_WINDOW_HEIGHT),
		     caption,
		     NO_INFO_BAR,
		     modal,
		     movable)
{
  int button_width=(f_width-1-(NB_BUTTONS+1))/NB_BUTTONS;
  int temp=(f_width-(NB_BUTTONS*button_width));
  int gap=temp/(NB_BUTTONS+1);

  x=(temp-(gap*(NB_BUTTONS-1)))>>1;
  y=(f_caption[0]==0)?1:2;
  gap+=button_width;


  // Help text

  f_help_text_zone   = new THelpTextZone(this,
				                         2,y+2,
				      					 f_width-4,f_height-3-y);
	 f_help_text_zone->setCursorStyle(_NOCURSOR);
  // Push-Buttons

  f_contents_button  =new TPushButton(this,
				      x,y,
				      button_width,
				      GetString(VOC_CONTENTS_CAPTION),
				      PB_NORMAL,
				      SHC_BOTH,
				      DISABLED);

  x+=gap;
  f_index_button     =new TPushButton(this,
				      x,y,
				      button_width,
				      GetString(VOC_INDEX_CAPTION),
				      PB_NORMAL,
				      SHC_BOTH,
				      DISABLED);

  x+=gap;
  f_back_button      =new TPushButton(this,
				      x,y,
				      button_width,
				      GetString(VOC_BACK_CAPTION),
				      PB_NORMAL,
				      SHC_BOTH,
				      DISABLED);

  x+=gap;
  f_previous_button  =new TPushButton(this,
				      x,y,
				      button_width,
				      GetString(VOC_PREVIOUS_CAPTION),
				      PB_NORMAL,
				      SHC_BOTH,
				      DISABLED);

  x+=gap;
  f_next_button      =new TPushButton(this,
				      x,y,
				      button_width,
				      GetString(VOC_NEXT_CAPTION),
				      PB_NORMAL,
				      SHC_BOTH,
				      DISABLED);

  // Callbacks
	
  setCloseButtonPressedCallback(*this, 0);

  f_contents_button->pressedAction_.set(*this, 1);
  f_index_button   ->pressedAction_.set(*this, 2);
  f_back_button    ->pressedAction_.set(*this, 3);
  f_previous_button->pressedAction_.set(*this, 4);
  f_next_button    ->pressedAction_.set(*this, 5);	

}

/***************/
/* Destructeur */
/* ----------- */
/***************/

THelpWindow::~THelpWindow()
{
  // Destruction des variables dynamiques

	delete f_help_text_zone;

  delete f_next_button;
  delete f_previous_button;
  delete f_back_button;
  delete f_index_button;
  delete f_contents_button;
}

/****************************************************************************/
/* m_load_help_file                                                         */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

bool THelpWindow::m_load_help_file(const char *file_name)
{
  return (f_help_text_zone->m_load_help_file(file_name));
}

void THelpWindow::m_unload_help_file()
{
  f_help_text_zone->m_unload_help_file();
}

bool THelpWindow::m_display_topic(const char *topic, bool push_current_topic)
{
  return(f_help_text_zone->m_display_topic(topic,push_current_topic));
}

void    THelpWindow::m_select_contents_topic()
{
  f_help_text_zone->m_select_contents_topic();
}

void    THelpWindow::m_select_index_topic()
{
  f_help_text_zone->m_select_index_topic();
}

void    THelpWindow::m_select_previous_topic()
{
  f_help_text_zone->m_select_previous_topic();
}

void    THelpWindow::m_select_next_topic()
{
  f_help_text_zone->m_select_next_topic();
}

void    THelpWindow::m_select_back_topic()
{
  f_help_text_zone->m_select_back_topic();
}

void	THelpWindow::operator()(TObject* who, what_type what, item_type item)
{
   PHelpWindow help_window = this; // (PHelpWindow)(((PPushButton)who)->m_get_window());
   switch(what)
     {
       case 0 : help_window->m_close();
		  return;
       case 1 : help_window->m_select_contents_topic();
		  break;
       case 2 : help_window->m_select_index_topic();
		  break;
       case 3 : help_window->m_select_back_topic();
		  break;
       case 4 : help_window->m_select_previous_topic();
		  break;
       case 5 : help_window->m_select_next_topic();
		  break;
     }

   help_window->f_help_text_zone->m_set_focus();
}
