// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef BoundingBoxClass
#define BoundingBoxClass

#include <Lib3d/Matrix.H>
#include <Lib3d/Vector.H>
#include <Lib3d/internals/Polygon.H>
#include <Lib3d/internals/Debuggable.H>

class ModelPipelineData;
class Viewport;

class BoundingObject : public Debuggable
{
public:
    BoundingObject() {}
    virtual ~BoundingObject() {}
    
    virtual bool testBounds( const Matrix34 &toCvv, float, uint &planes ) = 0;    
};

class NoBounds : public BoundingObject
{
public:
    NoBounds() {}
    ~NoBounds() {}

    bool testBounds( const Matrix34 &, float, uint &planes ) {
	planes = 0x3f;
	return true;
    }
};

class BoundingBox : public BoundingObject
{
public:
    BoundingBox( const Vertex *, uint );
    ~BoundingBox();


    bool testBounds( const Matrix34 &toCvv, float D, uint &planes );
    bool testAndDrawBounds( const Matrix34 &toCvv, float D, uint &planes, 
			    Viewport &viewport );

    const char *getName() const { return "BoundingBox"; }

private:
    Vector3 min;
    Vector3 max;
    Vector3 tmin;
    Vector3 tmax;
};



class BoundingBoxExact : public BoundingObject
{
friend class ModelBuilder;	// fix me.
public:
    BoundingBoxExact( const Vertex *, uint );
    ~BoundingBoxExact();


    bool testBounds( const Matrix34 &toCvv, float D, uint &planes );
    bool testAndDrawBounds(const Matrix34 &toCvv, 
			   float D, 
			   uint &planes, 
			   Viewport &viewport,
			   const Matrix4& toDevice);

    const char *getName() const { return "BoundingBoxExact"; }

private:
    Vector3 model[8];
    Vector3 cvv[8];
    DeviceVector device[8];
};


#endif
