// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef HrTimerClass
#define HrTimerClass

#include <sys/time.h>
#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#if defined(__DJGPP__)
#include <time.h>
uclock_t djgpp_uclock(void);
#define uclock() djgpp_uclock()
#endif

class HrTimer 
{
public:
   HrTimer( const char *name, const char *operation = "" );
   ~HrTimer();

   void start();
   void end();
   void lap();

   friend ostream &operator<<( ostream &, const HrTimer & );
   double getElapsedSeconds() const;

private:
   double total;		
   int count;

#if defined(__DJGPP__)
   uclock_t tp;
#else
   struct timeval tp;
#endif

   bool running;
   char *name;
   char *operation;

   static const double PerSecond;
};

inline void
HrTimer::start()
{
    if (!running) {
	running = true;
#if defined(__DJGPP__)
        tp = uclock();
#else
	gettimeofday(&tp, 0);
#endif
    }
}

inline void
HrTimer::end()
{
    if (running) {
#if defined(__DJGPP__)
	uclock_t finish = uclock();
	running = false;
	double len = finish - tp;
#else
	struct timeval finish;
	gettimeofday(&finish, 0);

	running = false;
	double len = ((finish.tv_usec - tp.tv_usec) + 
		      (finish.tv_sec - tp.tv_sec) * 1000000.0);
#endif
	
	total += len;		
	count++;
    }
}

inline void
HrTimer::lap()
{
    if (running) count++;
}

#endif








