// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

 
#include "VpNew.H"
#include <Lib3d/Texture.H>
#include <Lib3d/ColourRamp.H>
#include <math.h>

class Vp32 : public VpNew
{
public:
    const char *getName() const { return "Vp32"; }
    Colour getColour( uint r, uint g, uint b );
    void drawColourSpace() {}

protected:
    virtual void doTextureTriangleZb( edge_major_texture&, 
				      edge_minor_step&,
				      edge_minor_step&,
				      const Texture & );

    virtual void doFlatTriangleZb( edge_major_flat&, 
				   edge_minor&,
				   edge_minor&,
				   Colour );

    virtual void doSmoothTriangleZb( edge_major_smooth&, 
				     edge_minor_step&,
				     edge_minor_step&,
				     const ColourRamp & );

    virtual void lineZb( const DeviceVector &, 
			 const DeviceVector &, 
			 Colour );

protected:
    Viewport *clone( Device *device );
    ~Vp32();
    Vp32( Exemplar e ) : VpNew( e, 100 ) {}
    Vp32( Device * );


protected:
    static Vp32 *advertisement;
};


Vp32::Vp32( Device *device )
    : VpNew( device )
{
}

Vp32::~Vp32()
{
}

Viewport *
Vp32::clone( Device *device ) 
{ 
    return (device->getDepth() == 24) ? new Vp32( device ) : 0;
}

Colour
Vp32::getColour( uint r, uint g, uint b ) 
{
    // For an RGB:888 bit layout.  Other 32 bit viewports should
    // inherit Vp32 and override this function rather than
    // re-instantiating VpGeneric.

    return ((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff);
}

#define CLASS Vp32
#define PIXELTYPE uint
#include "VpGeneric.cc"
