/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _sjtouni.c,v 1.3 1996/10/25 14:04:00 jack Exp $ */

#include <limits.h>
#include <stddef.h>
#include <mbctype.h>
#include <mbprvt.h>

unsigned short
(__sjis_to_unicode) (unsigned short sjis)
{
#if (USHRT_MAX > 0xffff)
  /* check array size */
  if (sjis > 0xffff)
    return _MBC_ERROR_UNICODE;
#endif

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}

unsigned short
(__string_sjis_single_to_unicode) (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis;

  /* get sjis value */
  sjis = (unsigned short) us[0];

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}

unsigned short
(__string_sjis_double_to_unicode) (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis;

  /* get sjis value */
  sjis = (unsigned short) ((us[0] << 8) + us[1]);

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}

unsigned short
(__string_sjis_to_unicode) (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis;

  /* get sjis value */
  if (! _ismbblead (us[0]))
    sjis = (unsigned short) us[0];
  else
    sjis = (unsigned short) ((us[0] << 8) + us[1]);

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}
