/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbspbrk.c,v 1.1 1996/07/01 19:16:18 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

unsigned char *
_mbspbrk (const unsigned char *us1, const unsigned char *us2)
{
  size_t bytes;

  while (1)
    {
      bytes = _mbclen (us1);
      if (bytes == 1)
	{
	  if (*us1 == '\0')
	    return NULL;
	  else if (_mbschr (us2, *us1) != NULL)
	    break;
	}
      else
	{
	  if (_mbschr (us2, _mbsnextc (us1)) != NULL)
	    break;
	}
      us1 += bytes;
    }

  return (unsigned char *) us1;
}
