/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: fgetws.c,v 1.2 1996/07/13 20:40:34 jack Exp $ */

#include <stdio.h>
#include <wchar.h>
#include <wcprvt.h>

wchar_t *
fgetws (wchar_t *ws, int n, FILE *fp)
{
  wchar_t *top = ws;
  wint_t wc;
  __WCHAR_BINARYMODE_VARIABLES;

  /* check room size */
  if (n < 2)
    {
      if (n == 1)
	*ws++ = 0;
      return top;
    }

  /* for EOS */
  n--;

  __WCHAR_BINARYMODE_PROLOGUE (fp);

  while (n-- > 0)
    {
      wc = __fgetwc (fp);
      *ws++ = wc;
      if (wc == WEOF)
	{
	  __WCHAR_BINARYMODE_EPILOGUE (fp);
	  ws[-1] = 0;
	  return NULL;
	}
      else if (wc == (wchar_t) '\n')
	break;
    }

  __WCHAR_BINARYMODE_EPILOGUE (fp);

  /* EOS */
  *ws = 0;

  return top;
}
