/*
 *  General Midi sound bank for the Adlib FM synth.
 *
 *  Although I've put it in a header file, this should only be included
 *  once (in adlib.c). I just put it in a header to get it out of the way.
 */


/*  These instrument definitions are taken from the MID-KIT library by
 *  John Pollard. Many thanks to him for letting me use his patches: I 
 *  wouldn't have enjoyed the task of coming up with a set of my own.
 */
static FM_INSTRUMENT fm_instrument[] =
{ 
{ 0x21, 0x31, 0x4F, 0x00, 0xF2, 0xD2, 0x52, 0x73, 0x00, 0x00, 0x06 }, /* Acoustic Grand */
{ 0x01, 0x11, 0x4F, 0x00, 0xF1, 0xD2, 0x53, 0x74, 0x00, 0x00, 0x06 }, /* Bright Acoustic */
{ 0x13, 0x11, 0xC6, 0x00, 0xF2, 0xF1, 0xF5, 0xF5, 0x01, 0x00, 0x00 }, /* Electric Grand */
{ 0x31, 0x31, 0x8E, 0x80, 0xF1, 0xF3, 0xF9, 0xF9, 0x00, 0x00, 0x0A }, /* Honky-Tonk */
{ 0x01, 0x01, 0x4F, 0x04, 0xF1, 0xD2, 0x50, 0x7C, 0x00, 0x00, 0x06 }, /* Electric Piano 1 */
{ 0x02, 0x02, 0x22, 0x00, 0xF2, 0xF5, 0x13, 0x43, 0x00, 0x00, 0x0E }, /* Electric Piano 2 */
{ 0x31, 0x32, 0x8E, 0x80, 0xF1, 0xF3, 0xF9, 0xF9, 0x00, 0x00, 0x0A }, /* Harpsichord */
{ 0x01, 0x11, 0x49, 0x00, 0xF1, 0xF1, 0x53, 0x74, 0x01, 0x02, 0x06 }, /* Clav */
{ 0x17, 0x12, 0x4F, 0x08, 0xF2, 0xF2, 0x61, 0x74, 0x00, 0x00, 0x08 }, /* Celesta */
{ 0x07, 0x12, 0x4F, 0x0A, 0xF2, 0xF2, 0x60, 0x72, 0x00, 0x00, 0x08 }, /* Glockenspiel */
{ 0x17, 0x12, 0x4F, 0x08, 0xF2, 0xF1, 0x61, 0xB2, 0x00, 0x00, 0x08 }, /* Music Box */
{ 0x93, 0x91, 0x97, 0x80, 0xAA, 0xAC, 0x12, 0x21, 0x02, 0x00, 0x0E }, /* Vibraphone */
{ 0x05, 0x01, 0x4E, 0x00, 0xDA, 0xF9, 0x25, 0x15, 0x00, 0x00, 0x0A }, /* Marimba */
{ 0x06, 0xC4, 0x00, 0x00, 0xFF, 0xF8, 0xF0, 0xB5, 0x00, 0x00, 0x0E }, /* Xylophone */
{ 0x17, 0x02, 0x4F, 0x10, 0xF2, 0xF2, 0x60, 0x72, 0x00, 0x00, 0x08 }, /* Tubular Bells */
{ 0x03, 0x17, 0x0F, 0x0B, 0xF1, 0xF2, 0x53, 0x74, 0x00, 0x00, 0x00 }, /* Dulcimer */
{ 0x64, 0x21, 0x86, 0x80, 0xFF, 0xFF, 0x0F, 0x0F, 0x00, 0x00, 0x01 }, /* Drawbar Organ */
{ 0x24, 0x22, 0x80, 0x40, 0xFF, 0xFF, 0x0F, 0x0F, 0x00, 0x00, 0x01 }, /* Percussive Organ */
{ 0x01, 0x31, 0x4F, 0x00, 0xF0, 0x90, 0xFF, 0x0F, 0x00, 0x00, 0x06 }, /* Rock Organ */
{ 0xB2, 0xB0, 0xC0, 0x80, 0x9F, 0xB4, 0x06, 0x0F, 0x01, 0x01, 0x09 }, /* Church Organ */
{ 0x01, 0x33, 0x4F, 0x08, 0xF0, 0x90, 0xFF, 0x0F, 0x00, 0x00, 0x06 }, /* Reed Organ */
{ 0x24, 0x31, 0x4F, 0x10, 0xF2, 0x92, 0x0B, 0x0B, 0x00, 0x00, 0x0E }, /* Accoridan */
{ 0x21, 0x62, 0x15, 0x80, 0x51, 0x72, 0x03, 0x67, 0x00, 0x00, 0x0A }, /* Harmonica */
{ 0xE0, 0xE1, 0xCE, 0x00, 0xF5, 0xF4, 0xAF, 0x0F, 0x01, 0x01, 0x0C }, /* Tango Accordian */
{ 0x13, 0x11, 0x93, 0x80, 0xFF, 0xFF, 0x21, 0x03, 0x00, 0x00, 0x0A }, /* Acoustic Guitar(nylon) */
{ 0x11, 0x11, 0x8B, 0x80, 0xFF, 0xFF, 0x01, 0x03, 0x01, 0x00, 0x00 }, /* Acoustic Guitar(steel) */
{ 0x03, 0x11, 0x5E, 0x00, 0xF5, 0xF2, 0x71, 0x83, 0x01, 0x00, 0x0E }, /* Electric Guitar(jazz) */
{ 0x21, 0x06, 0x40, 0x80, 0xF1, 0xF4, 0x31, 0x44, 0x00, 0x00, 0x00 }, /* Electric Guitar(clean) */
{ 0x01, 0x01, 0x11, 0x00, 0xF2, 0xF5, 0x1F, 0x88, 0x00, 0x00, 0x0A }, /* Electric Guitar(muted) */
{ 0x31, 0x32, 0x48, 0x00, 0xF1, 0xF2, 0x53, 0x27, 0x00, 0x02, 0x06 }, /* Overdriven Guitar */
{ 0x62, 0xE6, 0x40, 0x03, 0x91, 0xC1, 0x1A, 0x1A, 0x00, 0x00, 0x08 }, /* Distortion Guitar */
{ 0xE1, 0xE7, 0x16, 0x40, 0x71, 0xF0, 0xAE, 0x7E, 0x00, 0x00, 0x0A }, /* Guitar Harmonics */
{ 0x01, 0x00, 0x00, 0x00, 0x94, 0x83, 0xB6, 0x26, 0x00, 0x00, 0x01 }, /* Acoustic Bass */
{ 0x00, 0x01, 0x23, 0x00, 0xC1, 0xF3, 0xEE, 0xDE, 0x00, 0x00, 0x0A }, /* Electric Bass(finger) */
{ 0x50, 0x00, 0x00, 0x00, 0xFB, 0xF3, 0x71, 0xB9, 0x00, 0x00, 0x00 }, /* Electric Bass(pick) */
{ 0x30, 0x20, 0x1E, 0x00, 0xF2, 0xF5, 0xEF, 0x78, 0x00, 0x00, 0x0E }, /* Fretless Bass */
{ 0x00, 0x11, 0x40, 0x00, 0x95, 0xFF, 0x88, 0x03, 0x01, 0x00, 0x06 }, /* Slap Bass 1 */
{ 0x00, 0x00, 0x10, 0x00, 0xF5, 0xF5, 0xF7, 0xF7, 0x01, 0x02, 0x00 }, /* Slap Bass 2 */
{ 0x11, 0x31, 0x05, 0x00, 0xF9, 0xF1, 0x25, 0x34, 0x00, 0x00, 0x0A }, /* Synth Bass 1 */
{ 0x00, 0x11, 0x4F, 0x00, 0xD5, 0xB3, 0x21, 0x01, 0x00, 0x00, 0x0A }, /* Synth Bass 2 */
{ 0x70, 0x20, 0x1C, 0x00, 0x51, 0xB4, 0x03, 0x67, 0x02, 0x02, 0x0E }, /* Violin */
{ 0xF0, 0xF1, 0xD0, 0x40, 0x52, 0x91, 0x11, 0xFE, 0x02, 0x01, 0x00 }, /* Viola */
{ 0xB0, 0xB1, 0xC5, 0x80, 0x52, 0x71, 0x11, 0xFE, 0x01, 0x01, 0x00 }, /* Cello */
{ 0xB0, 0xB0, 0xC5, 0x84, 0x52, 0x80, 0x11, 0xCF, 0x00, 0x01, 0x08 }, /* Contrabass */
{ 0xB1, 0x61, 0x8B, 0x40, 0x71, 0x62, 0x11, 0x15, 0x00, 0x01, 0x06 }, /* Tremolo Strings */
{ 0x31, 0x31, 0x9C, 0x80, 0xF1, 0xF5, 0xF9, 0xD5, 0x00, 0x00, 0x0E }, /* Pizzicato Strings */
{ 0x91, 0x61, 0x4F, 0x40, 0xB3, 0xF7, 0x23, 0x06, 0x01, 0x01, 0x06 }, /* Orchestral Strings */
{ 0x10, 0x10, 0x25, 0x80, 0xF0, 0xD0, 0x05, 0x04, 0x00, 0x00, 0x0E }, /* Timpani */
{ 0x30, 0x20, 0x1C, 0x00, 0x51, 0x64, 0x00, 0x65, 0x02, 0x02, 0x0E }, /* String Ensemble 1 */
{ 0xB1, 0x61, 0x8B, 0x40, 0x71, 0x42, 0x11, 0x15, 0x00, 0x01, 0x06 }, /* String Ensemble 2 */
{ 0x31, 0x62, 0x1C, 0x02, 0x75, 0x54, 0x03, 0x44, 0x01, 0x01, 0x0E }, /* SynthStrings 1 */
{ 0x21, 0x23, 0x16, 0x00, 0xB0, 0xD3, 0x81, 0x2C, 0x00, 0x01, 0x0C }, /* SynthStrings 2 */
{ 0x41, 0xC2, 0x4F, 0x40, 0x71, 0x62, 0x53, 0x7C, 0x08, 0x00, 0x00 }, /* Choir Aahs */
{ 0x60, 0xE2, 0xA7, 0x81, 0x22, 0x10, 0xD6, 0x75, 0x01, 0x00, 0x00 }, /* Voice Oohs */
{ 0x41, 0x42, 0x4F, 0x03, 0xF1, 0xF2, 0x73, 0x74, 0x01, 0x01, 0x06 }, /* Synth Voice */
{ 0x00, 0x00, 0x0F, 0x00, 0x91, 0x82, 0x05, 0x06, 0x00, 0x03, 0x00 }, /* Orchestra Hit */
{ 0x31, 0x62, 0x1C, 0x80, 0x41, 0xC2, 0x0B, 0x3B, 0x00, 0x00, 0x0E }, /* Trumpet */
{ 0xB1, 0x61, 0x1C, 0x80, 0x41, 0xB2, 0x1F, 0x3B, 0x00, 0x00, 0x0E }, /* Trombone */
{ 0x00, 0x21, 0x1D, 0x00, 0x52, 0xA3, 0x65, 0x76, 0x00, 0x00, 0x0E }, /* Tuba */
{ 0x21, 0x22, 0x19, 0x80, 0x43, 0xA5, 0x8C, 0x2F, 0x00, 0x01, 0x0C }, /* Muted Trumpet */
{ 0x21, 0x21, 0x9F, 0x80, 0x53, 0xBA, 0x5A, 0x1A, 0x00, 0x01, 0x0C }, /* French Horn */
{ 0xE1, 0xE1, 0x55, 0x0A, 0x91, 0xA1, 0xAE, 0x9E, 0x01, 0x00, 0x0E }, /* Brass Section */
{ 0x21, 0x61, 0x8E, 0x80, 0xBB, 0xB0, 0x29, 0x0A, 0x00, 0x00, 0x08 }, /* SynthBrass 1 */
{ 0xE1, 0xE1, 0x16, 0x06, 0x71, 0xA1, 0xAE, 0x9E, 0x00, 0x01, 0x0A }, /* SynthBrass 2 */
{ 0xE0, 0xE2, 0x23, 0x00, 0x71, 0xA1, 0xAE, 0x9E, 0x02, 0x01, 0x0A }, /* Soprano Sax */
{ 0x01, 0x12, 0x4F, 0x00, 0x71, 0x92, 0x53, 0x7C, 0x00, 0x00, 0x0A }, /* Alto Sax */
{ 0x20, 0x32, 0x4E, 0x00, 0x71, 0x92, 0x68, 0x5E, 0x00, 0x00, 0x0A }, /* Tenor Sax */
{ 0x10, 0x50, 0x4F, 0x00, 0x71, 0x92, 0x5B, 0x7B, 0x00, 0x00, 0x0E }, /* Baritone Sax */
{ 0x21, 0x24, 0x96, 0x00, 0xF0, 0xC0, 0x09, 0x0A, 0x00, 0x01, 0x0A }, /* Oboe */
{ 0xB1, 0xA2, 0xC5, 0x00, 0x6E, 0xDB, 0x17, 0x0E, 0x00, 0x01, 0x02 }, /* English Horn */
{ 0x30, 0x72, 0x4D, 0x00, 0xD5, 0x91, 0x19, 0x0A, 0x00, 0x00, 0x08 }, /* Bassoon */
{ 0x32, 0x61, 0x9A, 0x02, 0x51, 0xB2, 0x1B, 0x3B, 0x00, 0x00, 0x0C }, /* Clarinet */
{ 0x20, 0x22, 0x5B, 0x00, 0x00, 0xB0, 0x16, 0x15, 0x00, 0x00, 0x0A }, /* Piccolo */
{ 0x21, 0xA1, 0x83, 0x40, 0x74, 0xA5, 0x17, 0x17, 0x00, 0x01, 0x07 }, /* Flute */
{ 0xE1, 0x60, 0xDB, 0x00, 0x7E, 0x86, 0x8F, 0x2A, 0x01, 0x00, 0x0E }, /* Recorder */
{ 0x20, 0xE1, 0x5B, 0x40, 0x00, 0x60, 0x16, 0x15, 0x00, 0x00, 0x0A }, /* Pan Flute */
{ 0x53, 0x00, 0x85, 0x00, 0x3F, 0x7E, 0x06, 0x07, 0x01, 0x00, 0x06 }, /* Blown Bottle */
{ 0xE0, 0x61, 0xEC, 0x00, 0x6E, 0xA6, 0x8F, 0x2A, 0x00, 0x00, 0x0E }, /* Skakuhachi */
{ 0xF5, 0xF4, 0x9A, 0x40, 0x0C, 0x80, 0xC7, 0xA5, 0x00, 0x00, 0x0D }, /* Whistle */
{ 0x02, 0x11, 0x4F, 0x00, 0x71, 0x72, 0x53, 0x7C, 0x00, 0x00, 0x0A }, /* Ocarina */
{ 0x04, 0x02, 0x08, 0x00, 0xF8, 0xB2, 0x07, 0x74, 0x00, 0x00, 0x08 }, /* Lead 1 (square) */
{ 0x60, 0x60, 0x0B, 0x00, 0xF6, 0xA6, 0x4F, 0x0F, 0x01, 0x00, 0x02 }, /* Lead 2 (sawtooth) */
{ 0x82, 0xF1, 0x90, 0x00, 0x68, 0xC7, 0x08, 0x08, 0x00, 0x00, 0x04 }, /* Lead 3 (calliope) */
{ 0x50, 0x01, 0x80, 0x00, 0x55, 0x56, 0xF5, 0xE6, 0x00, 0x01, 0x08 }, /* Lead 4 (chiff) */
{ 0x61, 0x22, 0x00, 0x00, 0x96, 0x65, 0x33, 0x2B, 0x00, 0x00, 0x06 }, /* Lead 5 (charang) */
{ 0x61, 0x22, 0x07, 0x00, 0xF6, 0xF6, 0x03, 0x16, 0x03, 0x00, 0x04 }, /* Lead 6 (voice) */
{ 0x11, 0x01, 0x85, 0x00, 0xB3, 0xA1, 0xE1, 0xE4, 0x00, 0x00, 0x0A }, /* Lead 7 (fifths) */
{ 0x50, 0x71, 0x41, 0x00, 0xF2, 0xF2, 0xE2, 0xB2, 0x01, 0x00, 0x0A }, /* Lead 8 (bass+lead) */
{ 0xB4, 0xF6, 0x87, 0x00, 0xA4, 0x85, 0x02, 0x42, 0x00, 0x00, 0x06 }, /* Pad 1 (new age) */
{ 0xF0, 0xB0, 0xC0, 0x00, 0x41, 0xB2, 0x90, 0x05, 0x01, 0x00, 0x08 }, /* Pad 2 (warm) */
{ 0x51, 0x00, 0x03, 0x01, 0xFF, 0xFF, 0x02, 0x04, 0x01, 0x01, 0x04 }, /* Pad 3 (polysynth) */
{ 0xE1, 0xE0, 0xD0, 0x00, 0xF5, 0xF4, 0xAF, 0x0F, 0x00, 0x02, 0x0C }, /* Pad 4 (choir) */
{ 0xF4, 0xF1, 0x02, 0x00, 0x33, 0x53, 0x11, 0x2E, 0x02, 0x03, 0x03 }, /* Pad 5 (bowed) */
{ 0x05, 0x43, 0x40, 0x00, 0xB3, 0xF2, 0xD3, 0x25, 0x00, 0x01, 0x02 }, /* Pad 6 (metallic) */
{ 0x31, 0x10, 0x4D, 0x00, 0x72, 0x51, 0xCF, 0xEE, 0x03, 0x01, 0x02 }, /* Pad 7 (halo) */
{ 0x00, 0x10, 0x12, 0x00, 0x10, 0x50, 0xFF, 0xFF, 0x00, 0x00, 0x0A }, /* Pad 8 (sweep) */
{ 0x7E, 0x61, 0x1A, 0x00, 0xFF, 0x6F, 0x0F, 0x0F, 0x00, 0x01, 0x0E }, /* FX 1 (rain) */
{ 0xF0, 0xF0, 0x41, 0x40, 0x31, 0x22, 0x11, 0x12, 0x00, 0x01, 0x02 }, /* FX 2 (soundtrack) */
{ 0xB6, 0xF1, 0x4B, 0x00, 0xE5, 0x45, 0x03, 0x42, 0x02, 0x01, 0x06 }, /* FX 3 (crystal) */
{ 0x72, 0x20, 0x18, 0x40, 0x58, 0x26, 0x00, 0x02, 0x01, 0x00, 0x06 }, /* FX 4 (atmosphere) */
{ 0x50, 0xC5, 0x90, 0x00, 0xF9, 0xFF, 0x02, 0x01, 0x02, 0x00, 0x04 }, /* FX 5 (brightness) */
{ 0x20, 0x00, 0x03, 0x00, 0x4D, 0xFF, 0x0F, 0x05, 0x00, 0x01, 0x02 }, /* FX 6 (goblins) */
{ 0x35, 0xA2, 0xD7, 0x00, 0x7F, 0x35, 0x42, 0x21, 0x00, 0x00, 0x0E }, /* FX 7 (echoes) */
{ 0x7C, 0x30, 0x40, 0x00, 0xF1, 0xF1, 0x03, 0x01, 0x03, 0x00, 0x06 }, /* FX 8 (sci-fi) */
{ 0x01, 0x28, 0x40, 0x80, 0xF1, 0xF1, 0x53, 0x53, 0x00, 0x00, 0x00 }, /* Sitar */
{ 0x31, 0x13, 0x87, 0x80, 0xA1, 0x8D, 0x11, 0x43, 0x00, 0x00, 0x08 }, /* Banjo */
{ 0x01, 0x37, 0x4F, 0x00, 0xF1, 0xF2, 0x53, 0x74, 0x00, 0x00, 0x06 }, /* Shamisen */
{ 0x01, 0x21, 0x0B, 0x00, 0xF2, 0xF5, 0x1F, 0x88, 0x00, 0x01, 0x00 }, /* Koto */
{ 0x02, 0x01, 0x99, 0x80, 0xF5, 0xF6, 0x55, 0x53, 0x00, 0x00, 0x00 }, /* Kalimba */
{ 0x31, 0xA1, 0x43, 0x00, 0x6E, 0xAB, 0x17, 0x0C, 0x01, 0x01, 0x02 }, /* Bagpipe */
{ 0x31, 0x62, 0x19, 0x00, 0x55, 0x84, 0x03, 0x44, 0x02, 0x01, 0x0A }, /* Fiddle */
{ 0x81, 0x93, 0x4B, 0x00, 0x78, 0x85, 0x42, 0x55, 0x00, 0x00, 0x0E }, /* Shanai */
{ 0x07, 0x18, 0x46, 0x00, 0xF1, 0xFC, 0x72, 0x04, 0x02, 0x01, 0x00 }, /* Tinkle Bell */
{ 0x0E, 0x0E, 0x00, 0x00, 0xF8, 0xF8, 0xF6, 0xF6, 0x00, 0x00, 0x00 }, /* Agogo */
{ 0x03, 0x02, 0xC0, 0x00, 0x8F, 0x9F, 0x07, 0x05, 0x01, 0x01, 0x0A }, /* Steel Drums */
{ 0x02, 0x02, 0x00, 0x00, 0xC8, 0xF8, 0x97, 0x97, 0x00, 0x00, 0x01 }, /* Woodblock */
{ 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0x07, 0x00, 0x01, 0x05 }, /* Taiko Drum */
{ 0x01, 0x01, 0x00, 0x00, 0xD8, 0xD8, 0x96, 0x96, 0x0A, 0x00, 0x00 }, /* Melodic Tom */
{ 0x09, 0x00, 0x00, 0x00, 0xF1, 0xF6, 0xB3, 0xB4, 0x00, 0x00, 0x0E }, /* Synth Drum */
{ 0x01, 0x00, 0x80, 0x00, 0x5F, 0x5F, 0x0B, 0x0F, 0x00, 0x03, 0x06 }, /* Reverse Cymbal */
{ 0x51, 0x42, 0x00, 0x00, 0x66, 0x66, 0x05, 0x06, 0x02, 0x02, 0x02 }, /* Guitar Fret Noise */
{ 0x54, 0x40, 0x0A, 0x00, 0x5F, 0x7F, 0x66, 0x07, 0x03, 0x00, 0x04 }, /* Breath Noise */
{ 0x0E, 0x0E, 0x00, 0x00, 0x20, 0x21, 0x00, 0x01, 0x00, 0x00, 0x0E }, /* Seashore */
{ 0xC0, 0xFB, 0x51, 0x00, 0xF1, 0x94, 0x05, 0x23, 0x00, 0x00, 0x02 }, /* Bird Tweet */
{ 0xFC, 0xF0, 0xC0, 0x00, 0xFF, 0xFF, 0x0F, 0x0F, 0x01, 0x03, 0x00 }, /* Telephone ring */
{ 0xF0, 0xE2, 0x00, 0xC0, 0x1E, 0x11, 0x11, 0x11, 0x01, 0x01, 0x08 }, /* Helicopter */
{ 0x7E, 0x6E, 0x00, 0x00, 0xFF, 0x5F, 0x0F, 0x0F, 0x00, 0x00, 0x0E }, /* Applause */
{ 0x0A, 0x86, 0x00, 0x00, 0xA0, 0xC5, 0xF0, 0x75, 0x00, 0x00, 0x0E }  /* Gunshot */
};


/*  Thanks to Marcel de Kogel for providing these percussion instruments.
 */
static FM_INSTRUMENT fm_drum_sound[] =
{ 
{ 0x00, 0x00, 0x0D, 0x00, 0xE8, 0xA5, 0xEF, 0xFF, 0x00, 0x00, 0x00 }, /* Bass Drum */
{ 0x01, 0x1E, 0x00, 0x7F, 0xFF, 0xE5, 0x08, 0xF0, 0x00, 0x02, 0x00 }, /* Snare Drum 1 */
{ 0x06, 0x00, 0x00, 0x00, 0xF0, 0xF8, 0xF0, 0xB6, 0x00, 0x00, 0x00 }, /* Snare Drum 2 */
{ 0x02, 0x20, 0x00, 0x00, 0xC8, 0xE0, 0x97, 0x40, 0x00, 0x00, 0x00 }, /* Tom Tom */
{ 0x01, 0xB2, 0x03, 0x5D, 0xDA, 0x02, 0x18, 0x01, 0x00, 0x00, 0x00 }, /* Short Hi-Hat */
{ 0x01, 0x4E, 0x00, 0x00, 0xF7, 0x10, 0xB5, 0x00, 0x00, 0x00, 0x00 }, /* Long Hi-Hat */
{ 0xB7, 0x01, 0x41, 0x00, 0x37, 0xFF, 0x90, 0x06, 0x01, 0x00, 0x00 }, /* Cymbal */
{ 0x0C, 0x4B, 0x00, 0x40, 0xF8, 0xC6, 0xFE, 0xF6, 0x00, 0x00, 0x00 }, /* Rim Shot */
{ 0x05, 0xA7, 0x00, 0x7F, 0xF6, 0x33, 0x56, 0x90, 0x00, 0x03, 0x00 }, /* Agogo */
};


#define BASS_DRUM          fm_drum_sound+0
#define SNARE_DRUM_1       fm_drum_sound+1
#define SNARE_DRUM_2       fm_drum_sound+2
#define TOM_TOM            fm_drum_sound+3
#define SHORT_HIHAT        fm_drum_sound+4
#define LONG_HIHAT         fm_drum_sound+5
#define CYMBAL             fm_drum_sound+6
#define RIM_SHOT           fm_drum_sound+7
#define AGOGO              fm_drum_sound+8


/*  This table is used to map GM percussion numbers to drum instruments
 *  and pitches, so we can get by with less than a full GM set of definitions.
 */
static FM_DRUM fm_drum[] =
{
    { 40, FM_BD, BASS_DRUM },             /* Acoustic Bass Drum */
    { 40, FM_BD, BASS_DRUM },             /* Bass Drum 1 */
    { 30, FM_TT, RIM_SHOT },              /* Side Stick */
    { 70, FM_SD, SNARE_DRUM_1 },          /* Acoustic Snare */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Hand Clap */
    { 70, FM_SD, SNARE_DRUM_1 },          /* Electric Snare */
    { 35, FM_TT, TOM_TOM },               /* Low Floor Tom */
    { 70, FM_HH, SHORT_HIHAT },           /* Closed Hi-Hat */
    { 40, FM_TT, TOM_TOM },               /* High Floor Tom */
    { 70, FM_HH, LONG_HIHAT },            /* Pedal Hi-Hat */
    { 45, FM_TT, TOM_TOM },               /* Low Tom */
    { 70, FM_HH, LONG_HIHAT },            /* Open Hi-Hat */
    { 50, FM_TT, TOM_TOM },               /* Low-Mid Tom */
    { 55, FM_TT, TOM_TOM },               /* Hi-Mid Tom */
    { 70, FM_CY, CYMBAL },                /* Crash Cymbal 1 */
    { 60, FM_TT, TOM_TOM },               /* High Tom */
    { 70, FM_CY, CYMBAL },                /* Ride Cymbal 1 */
    { 70, FM_CY, CYMBAL },                /* Chinese Cymbal */
    { 70, FM_CY, CYMBAL },                /* Ride Bell */
    { 70, FM_HH, SHORT_HIHAT },           /* Tambourine */
    { 70, FM_CY, CYMBAL },                /* Splash Cymbal */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Cowbell */
    { 70, FM_CY, CYMBAL },                /* Crash Cymbal 2 */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Vibraslap */
    { 70, FM_CY, CYMBAL },                /* Ride Cymbal 2 */
    { 70, FM_TT, TOM_TOM },               /* Hi Bongo */
    { 65, FM_TT, TOM_TOM },               /* Low Bongo */
    { 60, FM_TT, TOM_TOM },               /* Mute Hi Conga */
    { 55, FM_TT, TOM_TOM },               /* Open Hi Conga */
    { 50, FM_TT, TOM_TOM },               /* Low Conga */
    { 70, FM_SD, SNARE_DRUM_2 },          /* High Timbale */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Low Timbale */
    { 70, FM_TT, AGOGO },                 /* High Agogo */
    { 65, FM_TT, AGOGO },                 /* Low Agogo */
    { 70, FM_HH, SHORT_HIHAT },           /* Cabasa */
    { 70, FM_HH, SHORT_HIHAT },           /* Maracas */
    { 70, FM_HH, LONG_HIHAT },            /* Short Whistle */
    { 70, FM_HH, LONG_HIHAT },            /* Long Whistle */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Short Guiro */
    { 70, FM_SD, SNARE_DRUM_2 },          /* Long Guiro */
    { 50, FM_TT, RIM_SHOT },              /* Claves */
    { 40, FM_TT, RIM_SHOT },              /* Hi Wood Block */
    { 35, FM_TT, RIM_SHOT },              /* Low Wood Block */
    { 70, FM_HH, LONG_HIHAT },            /* Mute Cuica */
    { 70, FM_HH, LONG_HIHAT },            /* Open Cuica */
    { 70, FM_HH, LONG_HIHAT },            /* Mute Triangle */
    { 70, FM_HH, LONG_HIHAT }             /* Open Triangle */
};

