/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> SLIDER.H
 -> Slider class.
*/

#ifndef _slider_h
#define _slider_h

#include <tws/window.h>
#include <tws/button.h>

#define ID_MOVE_UP      3000
#define ID_MOVE_DOWN    3001
#define ID_MOVE_LEFT    3002
#define ID_MOVE_RIGHT   3003


#define E_SLIDERMOVE(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4008) \
   { \
      function(ev->p3); \
      return TRUE; \
   }

#define E_SLIDERUP(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4000) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERRIGHT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4001) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERDOWN(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4002) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERLEFT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4003) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERPAGEUP(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4004) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERPAGERIGHT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4005) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERPAGEDOWN(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4006) \
   { \
      function(); \
      return TRUE; \
   }

#define E_SLIDERPAGELEFT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==4007) \
   { \
      function(); \
      return TRUE; \
   }

class Slider:public Window {
   public:
      Slider(Window *parent,ControlID id,int x,int y,int w,int h,int length,int position=0)
         :Window(parent,NULL,x,y,x+w,y+h,WA_VISABLE | WA_DEPENDANT)
         ,position(position)
         ,length(length)
         ,isMouse(FALSE)
         ,ID(id)
         {}

      virtual void ChangePos(int);
      virtual void Update(int,int);

   protected:

      int position;
      int length;
      int isMouse;
      ControlID ID;
};

class VSlider:public Slider {
   public:
      VSlider(Window *parent,ControlID id,int x,int y,int l,int length,int position=0)
         :Slider(parent,id,x,y,15,l-1,length,position)
         ,Up(this,ID_MOVE_UP,0,0,15,15,ArrowIcns[0])
         ,Down(this,ID_MOVE_DOWN,0,l-16,15,l-1,ArrowIcns[2])
         {}

   protected:
      void PaintWindow(int,int,int,int);

      void MoveUp();
      void MoveDown();
      void MouseMove(int,int,int,int);
      void LButtonDown(int,int,int);
      void LButtonUp(int,int,int);
      void StopTimer();
      void Timer();

      DECLARE_RESPONSE_TABLE;

      int my,dir;
      IconButton Up,Down;
};

class HSlider:public Slider {
   public:
      HSlider(Window *parent,ControlID id,int x,int y,int l,int length,int position=0)
         :Slider(parent,id,x,y,l-1,15,length,position)
         ,Left(this,ID_MOVE_LEFT,0,0,15,15,ArrowIcns[3])
         ,Right(this,ID_MOVE_RIGHT,l-16,0,l-1,15,ArrowIcns[1])
         {}

   protected:
      void PaintWindow(int,int,int,int);

      void MoveLeft();
      void MoveRight();
      void MouseMove(int,int,int,int);
      void LButtonDown(int,int,int);
      void LButtonUp(int,int,int);
      void StopTimer();
      void Timer();

      DECLARE_RESPONSE_TABLE;

      int mx,dir;
      IconButton Left,Right;
};

#endif
