/*************************************************************
 ****************    ===Picture Viewer===    *****************
 *************************************************************
		Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> PICVIEW.CC
 -> Main program source file for the picture viewer.
*/

#include "picview.h"
#include "image.h"
#include "options.h"
#include <tws/message.h>
#include <tws/filedlg.h>
#include <tws/help.h>

extern char *ErrorString;
HelpDataBase *help_data;

DEFINE_RESPONSE_TABLE(MainMenu,AutoMenu)
	E_COMMAND(ID_FILE_OPEN,CmFileOpen)
	E_COMMAND(ID_FILE_SAVE,CmFileSave)
	E_COMMAND(ID_FILE_SAVE_AS_BITMAP,CmFileSaveAsBMP)
	E_COMMAND(ID_FILE_SAVE_AS_TARGA,CmFileSaveAsTGA)
	E_COMMAND(ID_SHELL_TO_DOS,CmFileShellToDos)
	E_COMMAND(ID_FILE_EXIT,CmFileExit)
	E_COMMAND(ID_IMAGE_OPTIONS,CmImageOptions)
	E_COMMAND(ID_HELP_CONTENTS,CmHelpContents)
END_RESPONSE_TABLE

void
MainMenu::CmFileOpen()
{
	char *filename;
	Image *im;
	ImageWindow *iwin;

	filename=FileDlg("Open File").Run();
	if(filename)
	{
		im=new Image(filename);
		if(im->DoError())
			delete im;
		else
		{
			iwin=new ImageWindow(10,30,filename,im);
			iwin->Paint();
			iwin->RefreshWindow();
		}
		delete filename;
	}
}

void
MainMenu::CmFileSave()
{
	ws.QueueDocumentEvent(event(W_DOCUMENT,IMAGE_SAVE));
}

void
MainMenu::CmFileSaveAsBMP()
{
	ws.QueueDocumentEvent(event(W_DOCUMENT,IMAGE_SAVE_AS_BMP));
}

void
MainMenu::CmFileSaveAsTGA()
{
	ws.QueueDocumentEvent(event(W_DOCUMENT,IMAGE_SAVE_AS_TGA));
}

void
MainMenu::CmFileShellToDos()
{
	ws.ShellToDos();
}

void
MainMenu::CmFileExit()
{
	ws.StopRunningEvents();
}

void
MainMenu::CmImageOptions()
{
	OptionDlg().Run();
}

void
MainMenu::CmHelpContents()
{
	HelpWindow *temp=new HelpWindow(NULL,help_data,"contents",ws.GetDeskWidth()/2+10,100,ws.GetDeskWidth()*9/10+30,ws.GetDeskHeight()*4/5+50);
	temp->Setup();
}

int main(int argc,char *argv[])
{
	char *temp;

	help_data=new HelpDataBase("picview.hlp");

	ws.Init("picview.cfg");

	MainMenuWindow Main;

	ws.RefreshDesktop();

	ws.RunEvents();

	return 0;
}

