/***************************************************************************\
*                                                                           *
*   WINUSER.H                                                               *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINUSER_H)
#define _WINUSER_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)

typedef struct {
    HWND        hwnd;
    UINT        message;
    WORD      wParam;
    DWORD      lParam;
    DWORD       time;
    POINT       pt;
} MSG, *LPMSG;

#define CallMsgFilter TFUNCT(CallMsgFilter)
BOOL WINAPI CallMsgFilter(LPMSG lpMsg, int nCode);

#define WM_NULL                         0x000
#define WM_CREATE                       0x001
#define WM_DESTROY                      0x002
#define WM_MOVE                         0x003
#define WM_SIZE                         0x005
#define WM_ACTIVATE                     0x006
#define WM_SETFOCUS                     0x007
#define WM_KILLFOCUS                    0x008
#define WM_ENABLE                       0x00A
#define WM_SETREDRAW                    0x00B
#define WM_SETTEXT                      0x00C
#define WM_GETTEXT                      0x00D
#define WM_GETTEXTLENGTH                0x00E
#define WM_PAINT                        0x00F
#define WM_CLOSE                        0x010
#define WM_QUERYENDSESSION              0x011
#define WM_QUIT                         0x012
#define WM_QUERYOPEN                    0x013
#define WM_ERASEBKGND                   0x014
#define WM_SYSCOLORCHANGE               0x015
#define WM_ENDSESSION                   0x016
#define WM_SHOWWINDOW                   0x018
#define WM_WININICHANGE                 0x01A
#define WM_DEVMODECHANGE                0x01B
#define WM_ACTIVATEAPP                  0x01C
#define WM_FONTCHANGE                   0x01D
#define WM_TIMECHANGE                   0x01E
#define WM_CANCELMODE                   0x01F
#define WM_SETCURSOR                    0x020
#define WM_MOUSEACTIVATE                0x021
#define WM_CHILDACTIVATE                0x022
#define WM_QUEUESYNC                    0x023
#define WM_GETMINMAXINFO                0x024
#define WM_PAINTICON                    0x026
#define WM_ICONERASEBKGND               0x027
#define WM_NEXTDLGCTL                   0x028
#define WM_SPOOLERSTATUS                0x02A
#define WM_DRAWITEM                     0x02B
#define WM_MEASUREITEM                  0x02C
#define WM_DELETEITEM                   0x02D
#define WM_VKEYTOITEM                   0x02E
#define WM_CHARTOITEM                   0x02F
#define WM_SETFONT                      0x030
#define WM_GETFONT                      	0x031
#define WM_SETHOTKEY                    	0x032
#define WM_GETHOTKEY                    	0x033
#define WM_QUERYDRAGICON               0x037
#define WM_COMPAREITEM                  	0x039
#define WM_COMPACTING                   	0x041
#define WM_WINDOWPOSCHANGING   0x046
#define WM_WINDOWPOSCHANGED     0x047
#define WM_POWER                        	0x048
#define WM_COPYDATA                     	0x04A
#define WM_CANCELJOURNAL                0x04B
#define WM_NOTIFY			0x04E
#define WM_CONTEXTMENU		0x07B
#define WM_NCCREATE                     	0x081
#define WM_NCDESTROY                    	0x082
#define WM_NCCALCSIZE                   	0x083
#define WM_NCHITTEST                    	0x084
#define WM_NCPAINT                      	0x085
#define WM_NCACTIVATE                   	0x086
#define WM_GETDLGCODE                   	0x087
#define WM_NCMOUSEMOVE                  	0x0A0
#define WM_NCLBUTTONDOWN              0x0A1
#define WM_NCLBUTTONUP                  	0x0A2
#define WM_NCLBUTTONDBLCLK          0x0A3
#define WM_NCRBUTTONDOWN             0x0A4
#define WM_NCRBUTTONUP                  	0x0A5
#define WM_NCRBUTTONDBLCLK          0x0A6
#define WM_NCMBUTTONDOWN             0x0A7
#define WM_NCMBUTTONUP                  	0x0A8
#define WM_NCMBUTTONDBLCLK         0x0A9
#define WM_KEYFIRST                     	0x100
#define WM_KEYDOWN                      	0x100
#define WM_KEYUP                        	0x101
#define WM_CHAR                         	0x102
#define WM_DEADCHAR                     	0x103
#define WM_SYSKEYDOWN                   	0x104
#define WM_SYSKEYUP                     	0x105
#define WM_SYSCHAR                      	0x106
#define WM_SYSDEADCHAR                  	0x107
#define WM_KEYLAST                      	0x108
#define WM_INITDIALOG                   	0x110
#define WM_COMMAND                      	0x111
#define WM_SYSCOMMAND                   	0x112
#define WM_TIMER                        	0x113
#define WM_HSCROLL                      	0x114
#define WM_VSCROLL                      	0x115
#define WM_INITMENU                     	0x116
#define WM_INITMENUPOPUP                	0x117
#define WM_MENUSELECT                   	0x11F
#define WM_MENUCHAR                     	0x120
#define WM_ENTERIDLE                    	0x121
#define WM_CTLCOLORMSGBOX            0x132
#define WM_CTLCOLOREDIT                 	0x133
#define WM_CTLCOLORLISTBOX             0x134
#define WM_CTLCOLORBTN                  	0x135
#define WM_CTLCOLORDLG                  	0x136
#define WM_CTLCOLORSCROLLBAR      0x137
#define WM_CTLCOLORSTATIC               	0x138
#define WM_MOUSEFIRST                   	0x200
#define WM_MOUSEMOVE                    	0x200
#define WM_LBUTTONDOWN                  	0x201
#define WM_LBUTTONUP                    	0x202
#define WM_LBUTTONDBLCLK                0x203
#define WM_RBUTTONDOWN                  	0x204
#define WM_RBUTTONUP                    	0x205
#define WM_RBUTTONDBLCLK                0x206
#define WM_MBUTTONDOWN                  0x207
#define WM_MBUTTONUP                    	0x208
#define WM_MBUTTONDBLCLK               0x209
#define WM_MOUSELAST                    	0x209
#define WM_PARENTNOTIFY                 	0x210
#define WM_ENTERMENULOOP               0x211
#define WM_EXITMENULOOP                 	0x212
#define WM_MDICREATE                    	0x220
#define WM_MDIDESTROY                   	0x221
#define WM_MDIACTIVATE                  	0x222
#define WM_MDIRESTORE                   	0x223
#define WM_MDINEXT                      	0x224
#define WM_MDIMAXIMIZE                  	0x225
#define WM_MDITILE                      	0x226
#define WM_MDICASCADE                   	0x227
#define WM_MDIICONARRANGE              0x228
#define WM_MDIGETACTIVE                 	0x229
#define WM_MDISETMENU                   	0x230
#define WM_DROPFILES                    	0x233
#define WM_MDIREFRESHMENU             0x234
#define WM_CUT                          		0x300
#define WM_COPY                         	0x301
#define WM_PASTE                        	0x302
#define WM_CLEAR                        	0x303
#define WM_UNDO                         	0x304
#define WM_RENDERFORMAT                 	0x305
#define WM_RENDERALLFORMATS        0x306
#define WM_DESTROYCLIPBOARD         0x307
#define WM_DRAWCLIPBOARD               0x308
#define WM_PAINTCLIPBOARD               	0x309
#define WM_VSCROLLCLIPBOARD         0x30A
#define WM_SIZECLIPBOARD                	0x30B
#define WM_ASKCBFORMATNAME         0x30C
#define WM_CHANGECBCHAIN                0x30D
#define WM_HSCROLLCLIPBOARD         0x30E
#define WM_QUERYNEWPALETTE          0x30F
#define WM_PALETTEISCHANGING	0x310
#define WM_PALETTECHANGED	0x311
#define WM_HOTKEY                       	0x312
#define WM_PRINTCLIENT		0x318
#define WM_PENWINFIRST                  	0x380
#define WM_PENWINLAST                   	0x38F
#define WM_USER                         		0x400

#define HTERROR             	(-2)
#define HTTRANSPARENT       	(-1)
#define HTNOWHERE		0
#define HTCLIENT            	1
#define HTCAPTION        		2
#define HTSYSMENU		3
#define HTGROWBOX		4
#define HTSIZE             		HTGROWBOX
#define HTMENU              	5
#define HTHSCROLL           	6
#define HTVSCROLL           	7
#define HTMINBUTTON         	8
#define HTREDUCE            	HTMINBUTTON
#define HTMAXBUTTON         	9
#define HTZOOM              	HTMAXBUTTON
#define HTLEFT              		10
#define HTSIZEFIRST         	HTLEFT
#define HTRIGHT             		11
#define HTTOP               		12
#define HTTOPLEFT          	13
#define HTTOPRIGHT          	14
#define HTBOTTOM            	15
#define HTBOTTOMLEFT        	16
#define HTBOTTOMRIGHT       	17
#define HTSIZELAST         	HTBOTTOMRIGHT
#define HTBORDER           	18
#define HTOBJECT            	19
#define HTCLOSE             	20
#define HTHELP              		21

#define MK_LBUTTON	0x0001
#define MK_RBUTTON	0x0002
#define MK_SHIFT          	0x0004
#define MK_CONTROL	0x0008
#define MK_MBUTTON	0x0010

#define DispatchMessage TFUNCT(DispatchMessage)
LONG WINAPI DispatchMessage(CONST MSG * lpMsg);
#define GetMessage TFUNCT(GetMessage)
BOOL WINAPI GetMessage(MSG *, HWND, UINT, UINT);
#define PostMessage TFUNCT(PostMessage)
BOOL WINAPI PostMessage (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
#define SendMessage TFUNCT(SendMessage)
LRESULT WINAPI SendMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
VOID WINAPI PostQuitMessage (int nExitCode);
BOOL WINAPI TranslateMessage (CONST MSG * lpMsg);
int WINAPI TranslateAccelerator (HWND a, HANDLE b, MSG * c);
#define RegisterWindowMessage TFUNCT(RegisterWindowMessage)
UINT WINAPI RegisterWindowMessage(LPCTSTR lpString);

#define PM_NOREMOVE	0x0000
#define PM_REMOVE		0x0001
#define PM_NOYIELD		0x0002

#define PeekMessage TFUNCT(PeekMessage)
BOOL WINAPI PeekMessage(LPMSG lpMsg, HWND hWnd,
	UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);

#define DefWindowProc TFUNCT(DefWindowProc)
int WINAPI DefWindowProc(HWND hWnd, UINT Msg, int wParam, long lParam);

typedef VOID WINAPI (*TIMERPROC)(HWND, UINT, UINT, DWORD);
UINT WINAPI SetTimer(HWND hWnd, UINT nIDEvent, UINT uElapse,
	TIMERPROC lpTimerFunc);
BOOL WINAPI KillTimer(HWND hWnd, UINT uIDEvent);

#define EWX_LOGOFF	0
#define EWX_SHUTDOWN	1
#define EWX_REBOOT	2
#define EWX_FORCE 	4

#define ExitWindows(dwReserved, Code) ExitWindowsEx(EWX_LOGOFF, 0xFFFFFFFF)
BOOL WINAPI ExitWindowsEx(UINT uFlags, DWORD dwReserved);

#define COLOR_SCROLLBAR 0
#define COLOR_BACKGROUND 1
#define COLOR_ACTIVECAPTION 2
#define COLOR_INACTIVECAPTION 3
#define COLOR_MENU 4
#define COLOR_WINDOW 5
#define COLOR_WINDOWFRAME 6
#define COLOR_MENUTEXT 7
#define COLOR_WINDOWTEXT 8
#define COLOR_CAPTIONTEXT 9
#define COLOR_ACTIVEBORDER 10
#define COLOR_INACTIVEBORDER 11
#define COLOR_APPWORKSPACE 12
#define COLOR_HIGHLIGHT 13
#define COLOR_HIGHLIGHTTEXT 14
#define COLOR_BTNFACE 15
#define COLOR_BTNSHADOW 16
#define COLOR_GRAYTEXT 17
#define COLOR_BTNTEXT 18
#define COLOR_INACTIVECAPTIONTEXT 19
#define COLOR_BTNHIGHLIGHT 20

#endif /* RC_INVOKED */

#define CS_VREDRAW          0x0001
#define CS_HREDRAW          0x0002
#define CS_KEYCVTWINDOW     0x0004
#define CS_DBLCLKS          0x0008
#define CS_OWNDC            0x0020
#define CS_CLASSDC          0x0040
#define CS_PARENTDC         0x0080
#define CS_NOKEYCVT         0x0100
#define CS_NOCLOSE          0x0200
#define CS_SAVEBITS         0x0800
#define CS_BYTEALIGNCLIENT  0x1000
#define CS_BYTEALIGNWINDOW  0x2000
#define CS_GLOBALCLASS      0x4000
#define CS_IME              0x00010000

#define DT_SINGLELINE       0x00000020
#define DT_CENTER           0x00000001
#define DT_VCENTER          0x00000004

#define WS_OVERLAPPED       0x00000000L
#define WS_POPUP            0x80000000L
#define WS_CHILD            0x40000000L
#define WS_MINIMIZE         0x20000000L
#define WS_VISIBLE          0x10000000L
#define WS_DISABLED         0x08000000L
#define WS_CLIPSIBLINGS     0x04000000L
#define WS_CLIPCHILDREN     0x02000000L
#define WS_MAXIMIZE         0x01000000L
#define WS_CAPTION          0x00C00000L
#define WS_BORDER           0x00800000L
#define WS_DLGFRAME         0x00400000L
#define WS_VSCROLL          0x00200000L
#define WS_HSCROLL          0x00100000L
#define WS_SYSMENU          0x00080000L
#define WS_THICKFRAME       0x00040000L
#define WS_GROUP            0x00020000L
#define WS_TABSTOP          0x00010000L
#define WS_MINIMIZEBOX      0x00020000L
#define WS_MAXIMIZEBOX      0x00010000L
#define WS_TILED            WS_OVERLAPPED
#define WS_ICONIC           WS_MINIMIZE
#define WS_SIZEBOX          WS_THICKFRAME
#define WS_TILEDWINDOW      WS_OVERLAPPEDWINDOW

#define WS_OVERLAPPEDWINDOW	(WS_OVERLAPPED | WS_CAPTION | \
	WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW	(WS_POPUP | WS_BORDER | WS_SYSMENU)
#define WS_CHILDWINDOW	(WS_CHILD)

#define WS_EX_DLGMODALFRAME  0x00000001L
#define WS_EX_NOPARENTNOTIFY 0x00000004L
#define WS_EX_TOPMOST        0x00000008L
#define WS_EX_ACCEPTFILES    0x00000010L
#define WS_EX_TRANSPARENT    0x00000020L
#define WS_EX_MDICHILD          0x00000040L
#define WS_EX_TOOLWINDOW        0x00000080L
#define WS_EX_WINDOWEDGE        0x00000100L
#define WS_EX_CLIENTEDGE        0x00000200L
#define WS_EX_CONTEXTHELP       0x00000400L
#define WS_EX_RIGHT             0x00001000L
#define WS_EX_LEFT              0x00000000L
#define WS_EX_RTLREADING        0x00002000L
#define WS_EX_LTRREADING        0x00000000L
#define WS_EX_LEFTSCROLLBAR     0x00004000L
#define WS_EX_RIGHTSCROLLBAR    0x00000000L
#define WS_EX_CONTROLPARENT     0x00010000L
#define WS_EX_STATICEDGE        0x00020000L
#define WS_EX_APPWINDOW         0x00040000L
#define WS_EX_OVERLAPPEDWINDOW  (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE)
#define WS_EX_PALETTEWINDOW     (WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST)

#if !defined(RC_INVOKED)

typedef LRESULT WINAPI (*WNDPROC)(HWND, UINT, WPARAM, LPARAM);

typedef struct {
  UINT        style;
  WNDPROC     lpfnWndProc;
  int         cbClsExtra;
  int         cbWndExtra;
  HINSTANCE   hInstance;
  HICON       hIcon;
  HCURSOR     hCursor;
  HBRUSH      hbrBackground;
  LPCSTR      lpszMenuName;
  LPCSTR      lpszClassName;
} WNDCLASS, *LPWNDCLASS;

#define RegisterClass TFUNCT(RegisterClass)
ATOM WINAPI RegisterClass(CONST WNDCLASS * lpWndClass);

typedef struct {
    UINT        cbSize;
    UINT        style;
    WNDPROC     lpfnWndProc;
    int         cbClsExtra;
    int         cbWndExtra;
    HINSTANCE   hInstance;
    HICON       hIcon;
    HCURSOR     hCursor;
    HBRUSH      hbrBackground;
    LPTSTR      lpszMenuName;
    LPTSTR      lpszClassName;
    HICON       hIconSm;
} WNDCLASSEX,
*PWNDCLASSEX,
*LPWNDCLASSEX;

#define RegisterClassEx TFUNCT(RegisterClassEx)
ATOM WINAPI RegisterClassEx(CONST WNDCLASSEX *);

#define CW_USEDEFAULT       ((int)0x80000000)

typedef struct {
    LPVOID      lpCreateParams;
    HINSTANCE   hInstance;
    HMENU       hMenu;
    HWND        hwndParent;
    int         cy;
    int         cx;
    int         y;
    int         x;
    LONG        style;
    LPCTSTR      lpszName;
    LPCTSTR      lpszClass;
    DWORD       dwExStyle;
} CREATESTRUCT, *LPCREATESTRUCT;

#define CreateWindow(a,b,c,d,e,f,g,h,i,j,k) CreateWindowEx(0L, a,b,c,d,e,f,g,h,i,j,k)
#define CreateWindowEx TFUNCT(CreateWindowEx)
HWND WINAPI CreateWindowEx(DWORD, LPCTSTR, LPCTSTR, DWORD, 
	int, int, int, int, HWND, HMENU, HINSTANCE, void *);

/* bits to SetWindowPos */

#define SWP_NOSIZE		0x1
#define SWP_NOMOVE		0x2
#define SWP_NOZORDER	0x4
#define SWP_NOREDRAW	0x8
#define SWP_NOACTIVATE	0x10
#define SWP_FRAMECHANGED	0x0020
#define SWP_SHOWWINDOW      0x0040
#define SWP_HIDEWINDOW      0x0080
#define SWP_NOCOPYBITS      0x0100
#define SWP_NOOWNERZORDER   0x0200
#define SWP_NOSENDCHANGING  0x0400
#define SWP_DRAWFRAME       SWP_FRAMECHANGED
#define SWP_NOREPOSITION    SWP_NOOWNERZORDER
#define SWP_DEFERERASE      0x2000
#define SWP_ASYNCWINDOWPOS  0x4000

#define HWND_TOP		((HWND)0)
#define HWND_BOTTOM	((HWND)1)
#define HWND_TOPMOST	((HWND)-1)
#define HWND_NOTOPMOST	((HWND)-2)

BOOL WINAPI SetWindowPos (HWND t, HWND After, int x, int y, int cx, int cy, UINT flags);
BOOL WINAPI BringWindowToTop(HWND hWnd);

typedef HANDLE HDWP;
HDWP WINAPI BeginDeferWindowPos(int nNumWindows);
HDWP WINAPI DeferWindowPos(HDWP hWinPosInfo, HWND hWnd,
	HWND hWndAfter, int x, int y, int cx, int cy, UINT uFlags);
BOOL WINAPI EndDeferWindowPos(HDWP hWinPosInfo);

typedef struct {
    UINT  length;
    UINT  flags;
    UINT  showCmd;
    POINT ptMinPosition;
    POINT ptMaxPosition;
    RECT  rcNormalPosition;
} WINDOWPLACEMENT, *PWINDOWPLACEMENT, *LPWINDOWPLACEMENT;

BOOL WINAPI GetWindowPlacement(HWND hWnd, WINDOWPLACEMENT *lpwndpl);
BOOL WINAPI SetWindowPlacement(HWND hWnd, CONST WINDOWPLACEMENT *lpwndpl);

BOOL WINAPI IsWindow(HWND hWnd);
BOOL WINAPI IsMenu(HMENU hMenu);
BOOL WINAPI IsChild(HWND hWndParent, HWND hWnd);
BOOL WINAPI IsWindowVisible(HWND hWnd);
BOOL WINAPI IsIconic(HWND hWnd);
BOOL WINAPI IsZoomed(HWND hWnd);
BOOL WINAPI AnyPopup(VOID);

#define GW_HWNDFIRST        0
#define GW_HWNDLAST         1
#define GW_HWNDNEXT         2
#define GW_HWNDPREV         3
#define GW_OWNER            4
#define GW_CHILD            5

HWND WINAPI GetWindow(HWND handle, int command);

typedef BOOL WINAPI (*WNDENUMPROC)(HWND, LPARAM);
BOOL WINAPI EnumWindows(WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EnumChildWindows(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EnumThreadWindows(DWORD dwThreadId, WNDENUMPROC lpfn, LPARAM lParam);
#define EnumTaskWindows(hTask, lpfn, lParam) EnumThreadWindows((DWORD)hTask, lpfn, lParam)

#define FindWindow TFUNCT(FindWindow)
HWND WINAPI FindWindow(LPCTSTR lpClassName, LPCTSTR lpWindowName);

HWND WINAPI GetDesktopWindow(VOID);
HWND WINAPI GetParent(HWND hWnd);
HWND WINAPI SetParent(HWND hWndChild, HWND hWndNewParent);

#define GetClassName TFUNCT(GetClassName)
int WINAPI GetClassName(HWND hWnd, LPTSTR lpClassName, int nMaxCount);

#define SetWindowText TFUNCT(SetWindowText)
BOOL WINAPI SetWindowText(HWND hWnd, LPCTSTR lpString);
#define GetWindowText TFUNCT(GetWindowText)
int WINAPI GetWindowText(HWND hWnd, LPTSTR lpString, int nMaxCount);

/* Constants for GetWindowLong */
#define GWL_WNDPROC (-4)
#define GWL_HINSTANCE (-6)
#define GWL_HWNDPARENT (-8)
#define GWL_ID (-12)
#define GWL_STYLE (-16)
#define GWL_EXSTYLE (-20)
#define GWL_USERDATA (-21)

#define GetWindowLong TFUNCT(GetWindowLong)
LONG WINAPI GetWindowLong(HWND hWnd, int nIndex);
#define SetWindowLong TFUNCT(SetWindowLong)
LONG WINAPI SetWindowLong(HWND hWnd, int nIndex, LONG dwLong);

typedef BOOL CALLBACK (*PROPENUMPROC)(HWND, LPCTSTR, HANDLE);
typedef BOOL CALLBACK (*PROPENUMPROCEX)(HWND, LPTSTR, HANDLE, DWORD);

#define SetProp  TFUNCT(SetProp)
BOOL WINAPI SetProp(HWND hWnd, LPCTSTR lpString, HANDLE hData);
#define GetProp  TFUNCT(GetProp)
HANDLE WINAPI GetProp(HWND hWnd, LPCTSTR lpString);
#define RemoveProp TFUNCT(RemoveProp)
HANDLE WINAPI RemoveProp(HWND hWnd, LPCTSTR lpString);
#define EnumPropsEx  TFUNCT(EnumPropsEx)
int WINAPI EnumPropsEx(HWND hWnd, PROPENUMPROCEX lpEnumFunc,
	LPARAM lParam);
#define EnumProps TFUNCT(EnumProps)
int WINAPI EnumProps(HWND hWnd, PROPENUMPROC lpEnumFunc);

/*Constants for size changes */
#define SIZE_RESTORED	0
#define SIZE_MINIMIZED	1
#define SIZE_MAXIMIZED	2
#define SIZE_MAXSHOW	3
#define SIZE_MAXHIDE		4
#define SIZENORMAL		SIZE_RESTORED
#define SIZEICONIC		SIZE_MINIMIZED
#define SIZEFULLSCREEN	SIZE_MAXIMIZED
#define SIZEZOOMSHOW	SIZE_MAXSHOW
#define SIZEZOOMHIDE		SIZE_MAXHIDE


/* Constants for function ShowWindow() */
#define SW_HIDE		0L
#define SW_SHOWNORMAL	1L
#define SW_NORMAL		SW_SHOWNORMAL
#define SW_SHOWMINIMIZED	2L
#define SW_SHOWMAXIMIZED	3L
#define SW_MAXIMIZE		SW_SHOWMAXIMIZED
#define SW_SHOWNOACTIVATE	4L
#define SW_SHOW		5L
#define SW_MINIMIZE		6L
#define SW_SHOWMINNOACTIVE	7L
#define SW_SHOWNA		8L
#define SW_RESTORE		9L
#define SW_SHOWDEFAULT	10L
#define SW_MAX		10L

BOOL WINAPI ShowWindow (HWND hWnd, int nCmdShow);
BOOL WINAPI ShowWindowAsync(HWND hWnd, int nCmdShow);

BOOL WINAPI CloseWindow(HWND hWnd);
BOOL WINAPI MoveWindow(HWND hWnd, int X, int Y,
	int nWidth, int nHeight, BOOL bRepaint);
BOOL WINAPI FlashWindow(HWND hWnd, BOOL bInvert);
BOOL WINAPI ShowOwnedPopups(HWND hWnd, BOOL fShow);
BOOL WINAPI OpenIcon(HWND hWnd);

HWND WINAPI GetFocus(VOID);
HWND WINAPI SetFocus(HWND hWnd);
HWND WINAPI GetActiveWindow(VOID);
HWND WINAPI SetActiveWindow(HWND hWnd);
BOOL WINAPI EnableWindow(HWND hWnd, BOOL bEnable);
BOOL WINAPI IsWindowEnabled(HWND hWnd);

BOOL WINAPI DestroyWindow(HWND hWnd);

/* Constants for message boxes */
#define MB_OK 0x00000000L
#define MB_OKCANCEL 0x00000001L
#define MB_ABORTRETRYIGNORE 0x00000002L
#define MB_YESNOCANCEL 0x00000003L
#define MB_YESNO 0x00000004L
#define MB_RETRYCANCEL 0x00000005L
#define MB_ICONHAND 0x00000010L
#define MB_ICONQUESTION 0x00000020L
#define MB_ICONEXCLAMATION 0x00000030L
#define MB_ICONASTERISK 0x00000040L
#define MB_ICONINFORMATION MB_ICONASTERISK
#define MB_ICONSTOP MB_ICONHAND
#define MB_DEFBUTTON1 0x00000000L
#define MB_DEFBUTTON2 0x00000100L
#define MB_DEFBUTTON3 0x00000200L
#define MB_APPLMODAL 0x00000000L
#define MB_SYSTEMMODAL 0x00001000L
#define MB_TASKMODAL 0x00002000L
#define MB_NOFOCUS 0x00008000L
#define MB_SETFOREGROUND 0x00010000L
#define MB_DEFAULT_DESKTOP_ONLY 0x00020000L
#define MB_TYPEMASK 0x0000000FL
#define MB_ICONMASK 0x000000F0L
#define MB_DEFMASK 0x00000F00L
#define MB_MODEMASK 0x00003000L
#define MB_MISCMASK 0x0000C000L

#define MessageBox TFUNCT(MessageBox)
int WINAPI MessageBox(HWND hWnd, LPTSTR lpText, LPTSTR lpCaption, UINT uType);
#define MessageBoxEx TFUNCT(MessageBoxEx)
int WINAPI MessageBoxEx(HWND hWnd, LPCTSTR lpText, LPCTSTR lpCaption,
	UINT uType, WORD wLanguageId);
BOOL WINAPI MessageBeep(UINT uType);

#endif /* RC_INVOKED */

#define MAXINTATOM 0xC000
#define MAKEINTATOM(i)  (LPTSTR)((DWORD)((WORD)(i)))
#define INVALID_ATOM ((ATOM)0)

#ifdef RC_INVOKED
#define MAKEINTRESOURCE(x) (x)
#else
#define MAKEINTRESOURCE(x) ((LPTSTR)((DWORD)((WORD)(x))))
#endif

#define IDC_ARROW           MAKEINTRESOURCE(32512)

#if !defined(RC_INVOKED)

#define WHITE_BRUSH         0
#define LTGRAY_BRUSH        1
#define GRAY_BRUSH          2
#define DKGRAY_BRUSH        3
#define BLACK_BRUSH         4
#define NULL_BRUSH          5
#define WHITE_PEN           6
#define BLACK_PEN           7
#define NULL_PEN            8
#define OEM_FIXED_FONT      10
#define ANSI_FIXED_FONT     11
#define ANSI_VAR_FONT       12
#define SYSTEM_FONT         13
#define DEVICE_DEFAULT_FONT 14
#define DEFAULT_PALETTE     15
#define SYSTEM_FIXED_FONT   16

typedef struct {
    HDC         hdc;
    BOOL        fErase;
    RECT        rcPaint;
    BOOL        fRestore;
    BOOL        fIncUpdate;
    BYTE        rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT, *LPPAINTSTRUCT;

HDC WINAPI BeginPaint(HWND hWnd, PPAINTSTRUCT lpPS);
BOOL WINAPI EndPaint(HWND hWnd, const PPAINTSTRUCT lpPS);

BOOL WINAPI GetWindowRect (HWND hWind, PRECT lpRect);
BOOL WINAPI GetClientRect (HWND hWnd, PRECT lpRect);

BOOL WINAPI DrawFocusRect(HDC hDC, CONST RECT * lprc);
int WINAPI FillRect(HDC hDC, CONST RECT *lprc, HBRUSH hbr);
int WINAPI FrameRect(HDC hDC, CONST RECT *lprc, HBRUSH hbr);
BOOL WINAPI InvertRect(HDC hDC, CONST RECT *lprc);
BOOL WINAPI SetRect(LPRECT lprc, int xLeft, int yTop, int xRight, int yBottom);
BOOL WINAPI SetRectEmpty(LPRECT lprc);
BOOL WINAPI CopyRect(LPRECT lprcDst, CONST RECT *lprcSrc);
BOOL WINAPI InflateRect(LPRECT lprc, int dx, int dy);
BOOL WINAPI IntersectRect(LPRECT lprcDst, CONST RECT *lprcSrc1,
	CONST RECT *lprcSrc2);
BOOL WINAPI UnionRect(LPRECT lprcDst, CONST RECT *lprcSrc1,
	CONST RECT *lprcSrc2);
BOOL WINAPI SubtractRect(LPRECT lprcDst, CONST RECT *lprcSrc1,
	CONST RECT *lprcSrc2);
BOOL WINAPI OffsetRect(LPRECT lprc, int dx, int dy);
BOOL WINAPI IsRectEmpty(CONST RECT *lprc);
BOOL WINAPI EqualRect(CONST RECT *lprc1, CONST RECT *lprc2);
BOOL WINAPI PtInRect(CONST RECT *lprc, POINT pt);

BOOL WINAPI GetUpdateRect(HWND hWnd, LPRECT lpRect, BOOL bErase);
int WINAPI GetUpdateRgn(HWND hWnd, HRGN hRgn, BOOL bErase);
int WINAPI SetWindowRgn(HWND hWnd, HRGN hRgn, BOOL bRedraw);
int WINAPI GetWindowRgn(HWND hWnd, HRGN hRgn);
int WINAPI ExcludeUpdateRgn(HDC hDC, HWND hWnd);
BOOL WINAPI InvalidateRect(HWND hWnd, CONST RECT *lpRect, BOOL bErase);
BOOL WINAPI ValidateRect(HWND hWnd, CONST RECT *lpRect);
BOOL WINAPI InvalidateRgn(HWND hWnd, HRGN hRgn, BOOL bErase);
BOOL WINAPI ValidateRgn(HWND hWnd, HRGN hRgn);


#define RDW_INVALIDATE          0x0001
#define RDW_INTERNALPAINT       0x0002
#define RDW_ERASE               0x0004
#define RDW_VALIDATE            0x0008
#define RDW_NOINTERNALPAINT     0x0010
#define RDW_NOERASE             0x0020
#define RDW_NOCHILDREN          0x0040
#define RDW_ALLCHILDREN         0x0080
#define RDW_UPDATENOW           0x0100
#define RDW_ERASENOW            0x0200
#define RDW_FRAME               0x0400
#define RDW_NOFRAME             0x0800

BOOL WINAPI RedrawWindow(HWND hWnd, CONST RECT *lprcUpdate,
	HRGN hrgnUpdate, UINT flags);

#define DCX_WINDOW           0x00000001L
#define DCX_CACHE            0x00000002L
#define DCX_NORESETATTRS     0x00000004L
#define DCX_CLIPCHILDREN     0x00000008L
#define DCX_CLIPSIBLINGS     0x00000010L
#define DCX_PARENTCLIP       0x00000020L
#define DCX_EXCLUDERGN       0x00000040L
#define DCX_INTERSECTRGN     0x00000080L
#define DCX_EXCLUDEUPDATE    0x00000100L
#define DCX_INTERSECTUPDATE  0x00000200L
#define DCX_LOCKWINDOWUPDATE 0x00000400L
#define DCX_VALIDATE         0x00200000L

HDC WINAPI GetDCEx(HWND hWnd, HRGN hrgnClip, DWORD flags);
HWND WINAPI WindowFromDC(HDC hDC);
HDC WINAPI GetWindowDC(HWND hWnd);
HDC WINAPI GetDC(HWND hWnd);
int WINAPI ReleaseDC(HWND hWnd, HDC hDC);

BOOL WINAPI UpdateWindow(HWND hWnd);

int WINAPI ShowCursor(BOOL bShow);
BOOL WINAPI SetCursorPos(int X, int Y);
HCURSOR WINAPI SetCursor(HCURSOR hCursor);
BOOL WINAPI GetCursorPos(LPPOINT lpPoint);
BOOL WINAPI ClipCursor(CONST RECT *lpRect);
BOOL WINAPI GetClipCursor(LPRECT lpRect);
HCURSOR WINAPI GetCursor(VOID);
BOOL WINAPI CreateCaret(HWND hWnd, HBITMAP hBitmap,
	int nWidth, int nHeight);
UINT WINAPI GetCaretBlinkTime(VOID);
BOOL WINAPI SetCaretBlinkTime(UINT uMSeconds);
BOOL WINAPI DestroyCaret(VOID);
BOOL WINAPI HideCaret(HWND hWnd);
BOOL WINAPI ShowCaret(HWND hWnd);
BOOL WINAPI SetCaretPos(int X, int Y);
BOOL WINAPI GetCaretPos(LPPOINT lpPoint);

BOOL WINAPI ClientToScreen(HWND hWnd, LPPOINT lpPoint);
BOOL WINAPI ScreenToClient(HWND hWnd, LPPOINT lpPoint);
int WINAPI MapWindowPoints(HWND hWndFrom, HWND hWndTo,
	LPPOINT lpPoints, UINT cPoints);
HWND WINAPI WindowFromPoint(POINT Point);
HWND WINAPI ChildWindowFromPoint(HWND hWndParent, POINT Point);

#define CWP_ALL             0x0000
#define CWP_SKIPINVISIBLE   0x0001
#define CWP_SKIPDISABLED    0x0002
#define CWP_SKIPTRANSPARENT 0x0004
HWND WINAPI ChildWindowFromPointEx(HWND hWndParent, POINT Point, UINT uMode);

HWND WINAPI GetCapture(VOID);
HWND WINAPI SetCapture(HWND hWnd);
BOOL WINAPI ReleaseCapture(VOID);

#define wvsprintf TFUNCT(wvsprintf)
int WINAPI wvsprintf(LPTSTR, LPCTSTR, va_list arglist);
/* normal c decl calling convention */
#define wsprintf TFUNCT(wsprintf)
int wsprintf(LPTSTR, LPCTSTR, ...);

typedef DWORD HELPPOLY;
typedef struct {
    DWORD  mkSize;
    TCHAR   mkKeylist;
    TCHAR   szKeyphrase[1];
} MULTIKEYHELP, *PMULTIKEYHELP, *LPMULTIKEYHELP;

typedef struct {
    int  wStructSize;
    int  x;
    int  y;
    int  dx;
    int  dy;
    int  wMax;
    TCHAR   rgchMember[2];
} HELPWININFO, *PHELPWININFO, *LPHELPWININFO;

#define HELP_CONTEXT	0x0001L
#define HELP_QUIT		0x0002L
#define HELP_INDEX		0x0003L
#define HELP_CONTENTS	0x0003L
#define HELP_HELPONHELP	0x0004L
#define HELP_SETINDEX	0x0005L
#define HELP_SETCONTENTS	0x0005L
#define HELP_CONTEXTPOPUP	0x0008L
#define HELP_FORCEFILE	0x0009L
#define HELP_KEY		0x0101L
#define HELP_COMMAND	0x0102L
#define HELP_PARTIALKEY	0x0105L
#define HELP_MULTIKEY	0x0201L
#define HELP_SETWINPOS	0x0203L
#define HELP_CONTEXTMENU	0x000a
#define HELP_FINDER		0x000b
#define HELP_WM_HELP	0x000c
#define HELP_SETPOPUP_POS	0x000d
#define HELP_TCARD		0x8000
#define HELP_TCARD_DATA	0x0010
#define HELP_TCARD_OTHER_CALLER	0x0011

#define IDH_NO_HELP			28440
#define IDH_MISSING_CONTEXT	28441
#define IDH_GENERIC_HELP_BUTTON	28442
#define IDH_OK				28443
#define IDH_CANCEL			28444
#define IDH_HELP			28445

#define WinHelp TFUNCT(WinHelp)
BOOL WINAPI WinHelp(HWND hWndMain, LPCTSTR lpszHelp,
	UINT uCommand, DWORD dwData);

#define CharToOem TFUNCT(CharToOem)
BOOL WINAPI CharToOem(LPCTSTR lpszSrc, LPTSTR lpszDst);
#define OemToChar TFUNCT(OemToChar)
BOOL WINAPI OemToChar(LPCSTR lpszSrc, LPTSTR lpszDst);
#define CharToOemBuff TFUNCT(CharToOemBuff)
BOOL WINAPI CharToOemBuff(LPCTSTR lpszSrc, LPSTR lpszDst, DWORD cchDstLength);
#define OemToCharBuff TFUNCT(OemToCharBuff)
BOOL WINAPI OemToCharBuff(LPCSTR lpszSrc, LPTSTR lpszDst, DWORD cchDstLength);
#define CharUpper TFUNCT(CharUpper)
LPTSTR WINAPI CharUpper(LPTSTR lpsz);
#define CharUpperBuff TFUNCT(CharUpperBuff)
DWORD WINAPI CharUpperBuff(LPTSTR lpsz, DWORD cchLength);
#define CharLower TFUNCT(CharLower)
LPTSTR WINAPI CharLower(LPTSTR lpsz);
#define CharLowerBuff TFUNCT(CharLowerBuff)
DWORD WINAPI CharLowerBuff(LPTSTR lpsz, DWORD cchLength);
#define CharNext TFUNCT(CharNext)
LPTSTR WINAPI CharNext(LPCTSTR lpsz);
#define CharPrev TFUNCT(CharPrev)
LPTSTR WINAPI CharPrev(LPCTSTR lpszStart, LPCTSTR lpszCurrent);
LPSTR WINAPI CharNextExA(WORD CodePage, LPCSTR lpCurrentChar, DWORD dwFlags);
LPSTR WINAPI CharPrevExA(WORD CodePage, LPCSTR lpStart, 
	LPCSTR lpCurrentChar, DWORD dwFlags);

#define AnsiToOem CharToOemA
#define OemToAnsi OemToCharA
#define AnsiToOemBuff CharToOemBuffA
#define OemToAnsiBuff OemToCharBuffA
#define AnsiUpper CharUpperA
#define AnsiUpperBuff CharUpperBuffA
#define AnsiLower CharLowerA
#define AnsiLowerBuff CharLowerBuffA
#define AnsiNext CharNextA
#define AnsiPrev CharPrevA

/* I would expect those two to be in the kernel */
VOID WINAPI SetDebugErrorLevel(DWORD dwLevel);

#define SLE_ERROR		1
#define SLE_MINORERROR	2
#define SLE_WARNING		3

VOID WINAPI SetLastErrorEx(DWORD dwErrCode, DWORD dwType);

typedef struct
{
    HWND        hwndFrom;
    UINT        idFrom;
    UINT        code;
} NMHDR, *LPNMHDR;

#endif /* RC_INVOKED */

#include <winmenu.h>
#include <windialo.h>
#include <winkeyb.h>
#include <winclipb.h>


#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINUSER_H) */
