// Associated include file : Graphics/FontSys.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/grx.h"
#include "graphics/colors.h"
#include "graphics/fontsys.h"

TFont *FontSystem;
TFont *FontListing;

TFont::TFont(char *Name)
{ // Load the fonts in Normal, Italic, Bold, BoldItalic
  char   Tmp[10];
  // :: Normal
  Fonts[FFace_NORMAL]=GrLoadFont(Name);
  // :: Italic
  sprintf(Tmp,"%sI",Name);
  Fonts[FFace_ITALIC]=GrLoadFont(Tmp);
  if (Fonts[FFace_ITALIC]==NULL) Fonts[FFace_ITALIC]=Fonts[FFace_NORMAL];
  // :: Bold
  sprintf(Tmp,"%sB",Name);
  Fonts[FFace_BOLD]=GrLoadFont(Tmp);
  if (Fonts[FFace_BOLD]==NULL) Fonts[FFace_BOLD]=Fonts[FFace_NORMAL];
  // :: Bold-Italic
  sprintf(Tmp,"%sBI",Name);
  Fonts[FFace_BOLD | FFace_ITALIC]=GrLoadFont(Tmp);
  if (Fonts[FFace_BOLD | FFace_ITALIC]==NULL)
     Fonts[FFace_BOLD | FFace_ITALIC]=Fonts[FFace_NORMAL];
  // Initialize the default parameters for future drawings
#ifndef _GRX20_
  Options.txo_xmag=Options.txo_ymag=1;
#endif
  Options.txo_bgcolor.v=0;
  Options.txo_direct=GR_TEXT_RIGHT;
  Options.txo_xalign=Options.txo_yalign=GR_ALIGN_DEFAULT;
  Options.txo_chrtype=GR_BYTE_TEXT;
  ChooseFace(FFace_NORMAL);
  UnderLine(FALSE);
  BackColor(NoColor);
  Grayed(FALSE);
}

TFont::~TFont()
{ if (Fonts[3]!=Fonts[0]) GrUnloadFont(Fonts[3]);
  if (Fonts[2]!=Fonts[0]) GrUnloadFont(Fonts[2]);
  if (Fonts[1]!=Fonts[0]) GrUnloadFont(Fonts[1]);
  GrUnloadFont(Fonts[0]);
}

// Choosing the font's attributes

void TFont::Grayed(boolean _IsGrayed)
{ IsGrayed=_IsGrayed;
}

void TFont::ChooseFace(int Face)
{ Options.txo_font=Fonts[Face & 3];
}

void TFont::UnderLine(boolean UL)
{ if (UL) UnderLineOption=GR_UNDERLINE_TEXT;
     else UnderLineOption=0;
}

void TFont::BackColor(int Color)
{ Options.txo_bgcolor.v=Color;
}

void TFont::BackSysColor(int SysColor)
{ Options.txo_bgcolor.v=NoSysColor[SysColor];
}

// Using the font

int TFont::WidthStr(char *Text)
{ if ( (Text==NULL) ||
       (*Text==0) ) return 0;
              else return GrStringWidth(Text,strlen(Text),&Options);
}

int TFont::WidthChar(char Ch)
{ return GrCharWidth(Ch,&Options);
}

int TFont::HeightStr(char *Text)
{ if ( (Text==NULL) ||
       (*Text==0) ) return GrStringHeight("W",1,&Options);
               else return GrStringHeight(Text,strlen(Text),&Options);
}

void TFont::TruncStr(int Width, char *Text, char *Result)
{ strcpy(Result,Text);
  if (*Result==0) return;
  while (WidthStr(Result)>Width)
    Result[strlen(Result)-1]=0;
}

void TFont::PutStr(int X, int Y, char *Text, int Color)
{ if ((Text==NULL)||(*Text==0)) return;
  if (IsGrayed)
  { DoPutStr(X+1,Y+1,Text,NoSysColor[LightGray]);
    DoPutStr(X,Y,Text,NoSysColor[DarkGray]);
  }
  else DoPutStr(X,Y,Text,Color);
}

void TFont::DoPutStr(int X, int Y, char *Text, int Color)
{ if ((Text==NULL)||(*Text==0)) return;
  Options.txo_fgcolor.v=Color+UnderLineOption;
  GrDrawString(Text,strlen(Text),X,Y,&Options);
}

void TFont::PutChar(int X, int Y, char Ch, int Color)
{ char Str[2];
  Str[0]=Ch;
  Str[1]=0;
  PutStr(X,Y,Str,Color);
}

// Using the font with system text

int TFont::WidthSysStr(char *Text)
{ int L;
  if ((Text==NULL) || (*Text==0)) L=0;
  else
  { char *P=strchr(Text,'&');
    if (P!=NULL)
    { *P=0;
      L=GrStringWidth(Text,strlen(Text),&Options);
      *P='&';
      L+=GrStringWidth(P+1,strlen(P+1),&Options);
    }
    else L=GrStringWidth(Text,strlen(Text),&Options);
  }
  return L;
}

void TFont::TruncSysStr(int Width, char *Text,char *Result)
{ strcpy(Result,Text);
  if (*Result==0) return;
  while (WidthSysStr(Result)>Width)
  { Result[strlen(Result)-1]=0;
    if (Result[strlen(Result)-1]=='&') Result[strlen(Result)-1]=0;
  }
}

void TFont::PutSysStr(int X, int Y, char *Text, int Color)
{ if ((Text==NULL) || (*Text==0)) return;
  // Search for a '&' character
  char *P=strchr(Text,'&');
  char  Temp[2];
  int   dX;
  if (P!=NULL)
  { // Show the first part of the string
    *P=0;
    PutStr(X,Y,Text,Color);
    // Compute the next position for the other part of the string
    dX=WidthStr(Text);
    *P='&';
    // Show the underlined character
    UnderLine(TRUE);
    Temp[0]=*(P+1);
    Temp[1]=0;
    PutStr(X+dX,Y,Temp,Color);
    dX+=WidthStr(Temp);
    // Show the end of the string
    UnderLine(FALSE);
    PutStr(X+dX,Y,P+2,Color);
  }
  else PutStr(X,Y,Text,Color);
}

// Init/Done of the Font system

void InitFont()
{ FontSystem=new TFont("HELV15");
  FontListing=new TFont("COUR14");
}

void DoneFont()
{ delete FontListing;
  delete FontSystem;
}
