/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Demonstration
	Commands  : Group: 10000
	File      : Samples/ScrSaver/ScrSaver.CC
	Author    : Eric NICOLAS
	Overview  : Screen Saver demo program
	UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "sword.H"

// --- New Screen saver object

#define N_STARS     500
#define DEPTH_STARS 900

struct TStar
{ int x,y,z;
};

struct TStarPos
{ int x,y;
};

class TMyScreenSaver : public TScreenSaver
{ // --- Datas
  protected:
    TStar    *Stars;
	 TStarPos *Pos;
	 TStarPos *OldPos;
	 int      ScrX,ScrY;
    long     OldTime;
  // --- Functions
  public:
  // Constructor
    TMyScreenSaver(TShell *Shell);
  protected:
  // Overridables
    virtual void Init(void);
    virtual void Step(void);
    virtual void Done(void);
  //
            void CalcStars(void);
            void DrawStars(void);
				void UnDrawStars(void);
            void MoveStars(void);
};

TMyScreenSaver::TMyScreenSaver(TShell *Shell) : TScreenSaver(Shell)
{ }

void TMyScreenSaver::Init(void)
{ // Allocate memory
  Stars =new TStar[N_STARS];
  Pos   =new TStarPos[N_STARS];
  OldPos=new TStarPos[N_STARS];
  // Remove mouse cursor
  GrMouseEraseCursor();
  // Blank Screen
  GrSetClipBox(0,0,GrMaxX(),GrMaxY());
  GrFilledBox(0,0,GrMaxX(),GrMaxY(),NoSysColor[0]);
  // Reset all stars positions
  int i;
  ScrX=GrSizeX();
  ScrY=GrSizeY();
  for(i=0;i<N_STARS;i++)
  { Stars[i].x=Random(ScrX)-ScrX/2;
	 Stars[i].y=Random(ScrY)-ScrY/2;
	 Stars[i].z=(int)(1.*i*DEPTH_STARS/N_STARS+1);
  }
  CalcStars();
  OldTime=GetTime();
}

void TMyScreenSaver::Step(void)
{ long Time=GetTime();
  if (Time-OldTime>4)
  { UnDrawStars();
    CalcStars();
    DrawStars();
    MoveStars();
    OldTime=Time;
  }
}

void TMyScreenSaver::Done(void)
{ // Show mouse cursor
  GrMouseDisplayCursor();
  // Free memory
  delete Stars;
  delete Pos;
  delete OldPos;
}

void TMyScreenSaver::CalcStars(void)
{ int i;
  for(i=0;i<N_STARS;i++)
  { Pos[i].x=(int)((256.*Stars[i].x)/Stars[i].z)+ScrX/2;
	 Pos[i].y=(int)((256.*Stars[i].y)/Stars[i].z)+ScrY/2;
  }
}

void TMyScreenSaver::DrawStars(void)
{ int i,gr;
  int x,y;
  for(i=0;i<N_STARS;i++)
  { if((OldPos[i].x>0) && (OldPos[i].x<ScrX) &&
		 (OldPos[i].y>0) && (OldPos[i].y<ScrY))
	 { GrPlot(OldPos[i].x,OldPos[i].y,NoSysColor[Black]);
	 }
	 if((Pos[i].x>0) && (Pos[i].x<ScrX) &&
		 (Pos[i].y>0) && (Pos[i].y<ScrY))
	 { if (Stars[i].z>550) gr=80;
		else
		if (Stars[i].z>350) gr=140;
		else
		if (Stars[i].z>150) gr=200;
		else gr=255;
		x=Pos[i].x;
		y=Pos[i].y;
		GrPlot(x,y,Dither->GetRGBColor(x,y,gr,gr,gr));
	 }
  }
}

void TMyScreenSaver::UnDrawStars(void)
{ int i;
  for(i=0;i<N_STARS;i++)
  { OldPos[i].x=Pos[i].x;
	 OldPos[i].y=Pos[i].y;
  }
}

void TMyScreenSaver::MoveStars(void)
{ int i;
  for(i=0;i<N_STARS;i++)
  { Stars[i].z-=10;
	 if (Stars[i].z<1) Stars[i].z+=DEPTH_STARS;
  }
}

// --- Application object

class TMyApp : public TApp
{ DECLARE(TMyApp);
  // --- Functions
  public:
  // Public Constructors
          TMyApp(void);
          TMyApp(char *argv0);
  // Construction / Destruction
          void Init(char *argv0);
  // Overridables
  virtual void          CreateMenuChoices(TMenu *Menu);
  virtual TScreenSaver *ScreenSaverCreation();
};

DEFINE(TMyApp)

TMyApp::TMyApp(void)
{ Defaults();
}

TMyApp::TMyApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TMyApp::Init(char *argv0)
{ // Herited constructions
  TApp::Init(argv0);
  //
  ScreenSaverReset(10);
}

void TMyApp::CreateMenuChoices(TMenu *Menu)
{ Menu->Insert(new TMenuChoice("&Quit the demo",ScanAltQ,cmQuit));
}

TScreenSaver *TMyApp::ScreenSaverCreation()
{ return new TMyScreenSaver(this);
}

// ==== Main Program

int main(char , char *argv[])
{ TMyApp *MyApp;

  // Application identification
  ShortVersion="ScreenSaver";
  LongVersion ="ScreenSaver Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Create, run and destroy the Application object
  MyApp=new TMyApp(argv[0]);
  MyApp->Run();
  delete MyApp;
  return 0;
}