/* enh2Structures.c - structures used for the Starbase Enhancer
*/
#if !defined(__GTR3__) && !defined(__ENH2__) && !defined(__VPL3__) && !defined(VPL3) && !defined(__FLN1__) && !defined(__SPY3__)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef ENH2_STRUCTS_H
#define ENH2_STRUCTS_H
/*****************************************************************Includes*/
#include <vpl3.h>
#include <vpl3/rlssbenh.h>
/*********************************************************Type Definitions*/
#define delComponent(C) (C).type = none
typedef enum {cmp_none = 0, cmp_hull = 1, cmp_engine = 2, cmp_beamWeapon = 3, cmp_torpedoTube = 4} componentType;
typedef struct _componentRecordType {
  // identification
  int           ID;        // ID of this component - arbitrary
  componentType type;      // type of component (last record = none)
  // status of towing ship
  word          shipID;    // ID of ship towing component - 0 if lost in space
  word          shipFuel;  // amount of fuel the ship has
  // particulars of the component
  word          mass;      // mass of the component
  byte          techLevel; // tech level of the component
  byte          hullType;  // type of hull (if the component is a hull)
  // location of the component
  word          xCoord;    // location of the component
  word          yCoord;
  // misc.
  word          UFOID;     // ID in UFO database
} componentRecordType;
#define componentRecordSize 32

typedef struct _towedBaseRecordType {
  // identification
  word  ID;                 // ID # of the starbase - arbitrary
  word  owner;              // owner of the starbase - 0 if no starbase (last record)
  // status of towing ship
  word  shipID;             // ID of ship towing component - 0 if lost in space
  word  shipFuel;           // amount of fuel the ship has
  // tech levels
  byte  engineTech;         // engine tech level of the starbase
  byte  hullTech;           // hull tech level of the starbase
  byte  beamTech;           // beam weapon tech level of the starbase
  byte  torpedoTech;        // torpedo tech level of the starbase
  // status of the starbase
  short mission;            // current mission of the starbase
  short defense;            // defense units of the starbase
  short damage;             // damage of the starbase
  short buildableHulls[20]; // hulls the starbase can build.
  // location
  word  xCoord;             // coordinats of the starbase
  word  yCoord;
  // misc.
  word  UFOID;              // ID in UFO database
} towedBaseRecordType;
#define towedBaseRecordSize 75

typedef struct _enhancedBaseRecordType {
  // identification
  word  ID;                           // unique ID of the base/planet
  byte  owner;                        // owner of the base/planet
  bool  isMiniBase;                   // true if it's a minibase
  // tech levels
  byte  engineTech;                   // engine tech level of the starbase
  byte  hullTech;                     // hull tech level of the starbase
  byte  beamTech;                     // beam weapon tech level of the starbase
  byte  torpedoTech;                  // torpedo tech level of the starbase
  // status of the starbase
  short defense;                      // defense units of the starbase
  short damage;                       // damage of the starbase
  bool  buildableHulls[numHulls + 1]; // hulls the starbase can build.
  word  storedHulls[numHulls + 1];    // hulls the starbase has in storage
} enhancedBaseRecordType;
#define enhancedBaseRecordSize 500
/***************************************************************Mem movers*/
bool buf2Cmp(componentRecordType *C, char *B);
bool cmp2Buf(char *B, componentRecordType *C);
bool buf2Tsb(towedBaseRecordType *T, char *B);
bool tsb2Buf(char *B, towedBaseRecordType *T);
bool buf2Esb(enhancedBaseRecordType *E, char *B);
bool esb2Buf(char *B, enhancedBaseRecordType *E);
/**************************************************************************/
#endif // ENH2_RLSSBENH_H
