extproc perl -x

#!perl

# fileutils.pl - crude nroff -> texinfo conversion
# Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

print <<'!END!OF!INTRO!';
\input texinfo					@c -*-texinfo-*-
@setfilename fileutil
@settitle The GNU file utilities (MS-DOS Version)

@comment Don't bother about some overfull boxes from the manpages.
@iftex
@finalout
@end iftex

@ifinfo
This file documents the MS-DOS port of the GNU file utilities.

Copyright @copyright{} 1990 Thorsten Ohl, <td12@@ddagsi3.bitnet>

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

@ignore
Permission is granted to process this file through TeX and print the
results, provided the printed document carries copying permission
notice identical to this one except for the removal of this paragraph
(this paragraph not being relevant to the printed manual).

@end ignore
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided also that
the section entitled ``GNU General Public License'' is included exactly as in
the original, and provided that the entire resulting derived work is
distributed under the terms of a permission notice identical to this
one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the text of the translations of the section
entitled ``GNU General Public License'' must be approved for accuracy by the
Foundation.
@end ifinfo


@comment --------------------------------------------------------------

@node Top,,,(Dir)

@menu
* Introduction::        Foreword.
* Installation::	How to make the GNU fileutilities.
* Local::		How the DOS & OS/2 version differs.
* Manpages::		Short description of the commands.
* Program Index::	A guide to key material.
@end menu

@comment --------------------------------------------------------------

@node Introduction, Installation,, Top
@chapter General introduction to the GNU file utilities

Please send bug reports
(preferably with fixes (@strong{context} @code{diff}'s!) to

@display
      Thorsten Ohl
      <td12@@ddagsi3.bitnet>
@end display

I can make no promises to fix it immediately, but I might want to!

---

The port to OS/2 was made by

@display
      Kai Uwe Rommel
      <rommel@@lan.informatik.tu-muenchen.dbp.de>
@end display

Send bug reports to me too!


@comment --------------------------------------------------------------

@node Installation, Local, Introduction, Top
@chapter How to install the @code{GNUish MS-DOS} file utilities

@enumerate
@item
Edit the following variables in the makefile

@table @code

@item CFLAGS, LDFLAGS
These are for the Microsoft C compiler Version 6.0, edit them for your
system:

@table @code
@item -AS
Small memory model

@item -W4
Full warnings!

@item -Ox
Optimization.

@item -Za
@item -DSTDC_HEADERS
ANSI C.

@item -DUSG
Microsoft's C looks more like System V than BSD.

@item -DVPRINTF
The runtime library has @code{vprintf()}.

@item -DUTIMES_MISSING
The runtime library misses @code{utimes()}.

@item -DFCHMOD_MISSING
The runtime library misses @code{fchmod()}.

@item -DINT_16_BITS
32-bit @code{MS-DOS}?

@item -DBLKSIZE=0x4000
Use large blocksizes for @emph{fast} copying.

@item -DSMART_SHELL
Recognize the @code{GNUish MS-DOS} argument passing convention.

@item /e
Pack the executable.

@item /st:0x8000
Large stack.

@item /noe
If duplicate symbols in object files and libraries, use the one from the
object file.
@end table
@end table

@item
Say @code{make}.
@end enumerate

That's all.


@comment --------------------------------------------------------------

@node Local, Manpages, Installation, Top
@chapter How the @code{MS-DOS} version differs

All programs have additional options @samp{+version} and @samp{+copying}
for echoing the revision and a short copyleft notice respectively to
@file{stderr}.  This is mainly useful for identifying executables if
you do not yet have the sources.

@section Individual programs

@itemize
@item
@pindex cp
@pindex mv
GNU @code{cp} and @code{mv} can generate backup files with GNU
@code{emacs} style numbered backup suffixes (i.e. @file{foo.c} becomes
@file{foo.c.~1~}). Of course this is almost always impossible under
@code{MS-DOS}.  We have changed this convention to strip a part of the
original filename. The following examples should make the principle
clear:
@example
@file{foo} goes to @file{foo.~1~}
@file{foo.c} goes to @file{foo.c~1}
@file{foo.tex} goes to @file{foo.t~1}
@end example
This is not entirely foolproof (cf. @file{foo.txt} and @file{foo.tex}), and
is furthermore restructed to at most 9 generations of backup files.  But
here @code{MS-DOS}' limits are too restrictive to provide more.

@item
@pindex cp
GNU @code{cp} remembers all files it copies. This is primarily intended
for avoiding duplicate copying of linked files, but has the nice side
effect that by
@example
cp *.c foo.*
@end example
the file @file{foo.c} (if it exists) will not be copied twice.

Since @code{MS-DOS} has no inodes, this hashing doesn't work and has been
disabled. Future versions might provide either of the following:
@itemize
@item
Hashing based on filenames (no links!)

@item
An improved @file{ndir} library, which uses the starting cluster of a
file as an inode number.

@display
Suggestions for fast and @strong{portable} access to the @code{MS-DOS}
directory are very much appreciated.
@end display

@end itemize

@item
@pindex cat
@pindex head
@pindex tail
@code{cat}, @code{head} and @code{tail} have the new option:
@table @code
@item -B, +binary
Process the inputfiles and stdout in binary mode.  The has the effect of
switching of the @key{LF} @key{CR}@key{LF} conversions and allows reading
past a @ctrl{^Z}.
@end table

@item
@pindex dd
@code{dd} has the follwing new options:
@table @code
@item im=@{text,binary@}
Process the inputfile in binary mode.

@item om=@{text,binary@}
Process the outputfile in binary mode.
@end table

The OS/2 version of DD can directly access block devices (disk drives)
by using '0:' or '1:' etc. as file names. This should be used with care.

@item
@pindex ln
@pindex cp
There is no @code{ln}, since we can't link files under @code{MS-DOS}.
If one @emph{needs} to, one can use @code{cp}.  But this wastes disk
space, of course.

@item
@pindex mkfifo
There is no @code{mkfifo}, again for obvious reasons.

@item
@pindex install
There is no @code{install}.  I have no burning need for one, but for
completeness' sake, there might be one in the future.

@item
@pindex du
There is also no @code{du}.  This one I really miss, but it might be hard
to gather the information under @code{MS-DOS} - without going into too much
device dependent details.
@end itemize


@comment --------------------------------------------------------------

@node Manpages, Program Index, Local, Top
@chapter Manpages

These "manpages" have been translated automatically by a @code{perl}
script from the @code{nroff} sources, as supplied with the GNU distribution.

Thus they apply to the GNU version of these programs.  For @code{MS-DOS}
specific changes, additions, and omissions, @pxref{Local}


!END!OF!INTRO!

# O.k. now perl's work starts.

# This array will be used to determine the `next' fiels of a node.
@commands = ();

# First pass: generate the menu.
print '@menu';

file: while ($manfile = <*.1>)
  {
    chop;
    open (cur_file, $manfile) || die "can't open  $manfile.";

    while (<cur_file>)
      {
	# Take the menu entry from the `NAME' section.

	if (/^\.SH[ \t]+NAME/)
	  {
	    # Get the next line.
	    $_ = <cur_file>;
	    &preprocess;

	    ($name, $desc) = split ('[ \t]*-[ \t]*', $_, 2);
	    $name =~ s/[ \t]*,[ \t]*/ - /g;

	    # Print out a menu entry
	    printf "* %-22s%s\n", $name . "::", $desc;

	    # Save the name
	    push (@commands, $name);

	    next file;
	  }
      }

    die "Command has no name: $manfile.";	# oops...
  }

print '@end menu';

# Second pass: process the complete manpages.
shift (@commands);
$last = "";

# No open tables, etc. yet.
@pending = ();

file: while ($manfile = <*.1>)
  {
    chop;
    open (cur_file, $manfile) || die "can't open  $manfile";

    # Close all open tables.
    &pop_pending;

  line: while (<cur_file>)
      {
	&preprocess;

	if (/^\./)
	  {
	    # We have found a command, interpret it.

	    ($cmd, $arg) = split (/[ \t]+/, $_, 2);

	    if ($cmd eq '.TH')
	      {
		# ignore the header section.

		next line;
	      }
	    elsif ($cmd eq '.SH')
	      {
		# A new section starts here

		# Close all open tables.
		&pop_pending;

		if ($arg eq 'NAME')
		  {
		    # The name section gives us the information
		    # for the @node.

		    $_ = <cur_file>;
		    &preprocess;

		    ($name, $desc) = split ('[ \t]*-[ \t]*', $_, 2);
		    $name =~ s/[ \t]*,[ \t]*/ - /g;

		    print '';
		    print '';
		    printf "@node %s, %s, %s, Manpages\n",
			   $name, shift (@commands), $last;
		    print '@section ' . $name;
		    print '@pindex ' . $name;
		    print '';
		    print '@unnumberedsubsec NAME';
		    print '@display';
		    print $_;
		    print '@end display';
		    print '';

		    # Remember the name for the `last' field 
		    # of the next node
		    $last = $name;

		    next line;
		  }
		elsif ($arg eq 'SYNOPSIS')
		  {
		    # `display' the `SYNOPSIS'

		    print '';
		    print '@unnumberedsubsec SYNOPSIS';
		    print '@display';

		    push (@pending, '@end display');
		  }
		elsif ($arg eq 'DESCRIPTION')
		  {
		    print '';
		    print '@unnumberedsubsec DESCRIPTION';
		    print '';
		  }
		else
		  {
		    die "unknown section: $_.";
		  }
	      }
	    elsif ($cmd eq '.SS')
	      {
		&pop_pending;

		if ($arg eq 'OPTIONS')
		  {
		    print '';
		    print '@unnumberedsubsec OPTIONS';
		    print '';
		  }
		else
		  {
		    die "unknown section: $_.";
		  }
	      }
	    elsif ($cmd eq '.TP')
	      {
		# This is usually for a table entry.

		print '';

		if (! $intable)
		  {
		    # We're not yet in a @table, open it.

		    $intable = 1;
		    print '@table @code';
		    push (@pending, "@end table");
		  }

		# Get rid of the next lines' formatting commands.
		$_ = <cur_file>;
		&preprocess;

		if (/^\.[BI]R?/)
		  {
		    ($junk, $_) = split ('[ \t]+', $_, 2);
		  }

		 print '@item ' . $_;
	      }
	    elsif ($cmd eq '.PP')
	      {
		# New paragraph

		print '';
	      }
	    elsif ($cmd eq '.br')
	      {
		# Break the line

		print '';
	      }
	    elsif ($cmd eq '.RS')
	      {
		# This should start another level of `@table'

		print '@table @asis';
	      }
	    elsif ($cmd eq '.RE')
	      {
		# This should end another level of `@table'

		print '@end table';
	      }
	    elsif ($cmd eq '.B')
	      {
		# Assume that boldface is like `@code'

		printf "@code{%s} ", $arg;
	      }
	    elsif ($cmd eq '.BR')
	      {
		printf "@code{%s}%s ", split (/[ \t]+/, $arg, 2);
	      }
	    elsif ($cmd eq '.I')
	      {
		# Assume that italics are like `@samp'

		printf "@samp{%s} ", $arg;
	      }
	    elsif ($cmd eq '.IR')
	      {
		printf "@samp{%s}%s ", split (/[ \t]+/, $arg, 2);
	      }
	    else
	      {
		die "unknown command: $_.";
	      }
	  }
	else
	  {
	    # Plain line, print it.

	    print;
	  }
      }
  }

# Close all pending `@table's.
&pop_pending;

print '

@comment --------------------------------------------------------------

@node Program Index, , Manpages, Top
@appendix Program Index

@printindex pg

@contents
@bye
';

# Trivial subroutines:

# handle special characters.
sub preprocess
{
  chop;
  s/\\-/-/g;
  s/@/@@/g;
  s/{/@{/g;
  s/}/@}/g;
}

# Close all pending `@table's.
sub pop_pending
{
  while ($tmp = pop (@pending))
    {
      print $tmp;
    }
  $intable = 0;
}
