#define CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef beep

#ifdef PDCDEBUG
char *rcsid_beep = "$Header: C:\CURSES\portable\RCS\beep.c 2.1 1993/06/18 20:19:33 MH Rel MH $";
#endif




/*man-start*********************************************************************

  beep()	- generate audio-visual alarm.

  X/Open Description:
 	This routine is used to signal the terminal user.  The beep()
 	function will sound the audible bell on the terminal, if possible
 	and if not, will flash the screen (visible bell), if possible.
 	The flash() function will flash the screen, and if that is not
 	possible, will sound the audible signal.  If neither signal is
 	possible, nothing will happen.  Nearly all terminals have an
 	audible signal (bell or beep), but only some can flash the screen.

  X/Open Return Value:
 	The beep() and flash() functions return OK on success and ERR on
 	error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int beep( void );
 	X/Open Dec '88	int beep( void );
 	BSD Curses	int beep( void );
 	SYS V Curses	int beep( void );

**man-end**********************************************************************/

int	beep(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("beep() - called\n");
#endif

	if (!_cursvar.audible)
	{
		flash();
		return( ERR );		/* We try to flash instead...*/
	}

#ifdef UNIX
	if (bell != NULL)
		putp(bell);
#else
	PDC_putctty( '\007', 0 );
#endif
	return( OK );
}
