#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	flushinp

#ifdef PDCDEBUG
char *rcsid_flushinp = "$Header: C:\CURSES\portable\RCS\flushinp.c 2.1 1993/06/18 20:19:56 MH Rel MH $";
#endif




/*man-start*********************************************************************

  flushinp()	- discard type-ahead

  X/Open Description:
 	Throws away any type-ahead that has been typed by the user and
 	has not yet been read by the program.

  PDCurses Description:
 	If the PDCurses library is compiled under DOS with the FAST_VIDEO
 	define true, then we will poke the BIOS keyboard buffer head and
 	tail pointers, resetting the typeahead.

 	If this is not true, then we will be unable to reliably flush
 	the typeahead.

  X/Open Return Value:
 	The flushinp() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int flushinp( void );
 	X/Open Dec '88	int flushinp( void );
 	BSD Curses	int flushinp( void );
 	SYS V Curses	int flushinp( void );

**man-end**********************************************************************/

int	flushinp(void)
{
extern int	c_pindex;		/* putter index */
extern int	c_gindex;		/* getter index */
extern int	c_ungind;		/* wungetch() push index */

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("flushinp() - called\n");
#endif

#if defined(DOS) && defined(FAST_VIDEO)
	setdosmemword (0x41a, getdosmemword (0x41c)); /* Force the BIOS kbd buf       */
					/* head/tail pointers to be the */
					/* same...  Real nasty trick... */
#endif

#ifdef OS2
	KbdFlushBuffer(0);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif

	c_gindex = 1;			/* set indices to kill buffer	 */
	c_pindex = 0;
	c_ungind = 0;			/* clear c_ungch array		 */
	return( OK );
}
