#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	leaveok

#ifdef PDCDEBUG
char *rcsid_leaveok = "$Header: C:\CURSES\portable\RCS\leaveok.c 2.1 1993/06/18 20:20:16 MH Rel MH $";
#endif




/*man-start*********************************************************************

  leaveok()	- enable non-tracking cursor

  X/Open Description:
 	Normally, the hardware cursor is left at the location of the
 	window being refreshed.  This option allows the cursor to be
 	left whereever the update happens to leave it.  It is useful
 	for applications where the cursor is not used, since it reduces
 	the need for cursor motions.  If possible, the cursor is made
 	invisible when this option is enabled.

  PDCurses Description:
 	Though not explicitly stated, the cursor will be made visible
 	again, if leaveok() is passed a FALSE value.
 			(Frotz:911226 Comments?)

  X/Open Return Value:
 	The leaveok() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int leaveok( WINDOW* win, bool bf );
 	X/Open Dec '88	int leaveok( WINDOW* win, bool bf );
 	BSD Curses	int leaveok( WINDOW* win, bool bf );
 	SYS V Curses	int leaveok( WINDOW* win, bool bf );

**man-end**********************************************************************/

int	leaveok( WINDOW *win, bool bf )
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("loaveok() - called\n");
#endif

	if  ((win->_leave = bf) != 0)	cursoff();
	else				curson();
	return( OK );
}
