#include <stdarg.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	mvprintw

#ifdef PDCDEBUG
char *rcsid_mvprintw = "$Header: C:\CURSES\portable\RCS\mvprintw.c 2.1 1993/06/18 20:20:21 MH Rel MH $";
#endif





/*man-start*********************************************************************

  mvprintw()	- formatted write to a window

  X/Open Description:
 	The printw routine adds a string to the default window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by addstr.

 	The routine wprintw adds a string to the specified window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by waddstr.

 	The routine mvprintw adds a string to the default window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by addstr.

 	The routine mvwprintw adds a string to the specified window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by waddstr.

 	All these routines are analogous to printf.  It is advisable
 	to use the field width options of printf to avoid leaving
 	unwanted characters on the screen from earlier calls.

  PDCurses Description:
 	The old Bjorn Larssen code for the 68K platform has been removed
 	from this module.

  X/Open Return Value:
 	The mvprintw() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int mvprintw( int y, int x, char* fmt, ... );
 	X/Open Dec '88	int mvprintw( int y, int x, char* fmt, ... );
 	BSD Curses	int mvprintw( int y, int x, char* fmt, ... );
 	SYS V Curses	int mvprintw( int y, int x, char* fmt, ... );

**man-end**********************************************************************/

int	mvprintw(int y, int x, char *fmt, ...)
{
	int	retval = ERR;
	va_list args;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("mvprintw() - called\n");
#endif

	if (stdscr == (WINDOW *)NULL)
		return (retval);

	if (wmove(stdscr, y, x) == ERR)
		return( retval );

	va_start(args, fmt);
	vsprintf(c_printscanbuf, fmt, args);
	va_end(args);

	if (waddstr(stdscr, c_printscanbuf) == ERR)
		return( retval );
	retval = (strlen(c_printscanbuf));
	return( retval );
}
