#include <stdarg.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	mvscanw

#ifdef PDCDEBUG
char *rcsid_mvscanw = "$Header: C:\CURSES\portable\RCS\mvscanw.c 2.1 1993/06/18 20:20:22 MH Rel MH $";
#endif



/*man-start*********************************************************************

  mvscanw()	- read formatted from window

  X/Open Description:
 	These routines correspond to scanf.  The function scanw reads
 	input from the default window.  The function wscanw reads
 	input from the specified window.  The function mvscanw moves
 	the cursor to the specified position and then reads input from
 	the default window.  The function mvwscanw moves the cursor to
 	the specified position and then reads input from the specified
 	window.

 	For all the functions, the routine wgetstr is called to get a
 	string from the window, and the resulting line is used as
 	input for the scan.  All character interpretation is carried
 	out according to the scanf function rules.

  PDCurses Description:
 	The old Bjorn Larssen code for the 68K platform has been removed
 	from this module.

  X/Open Return Value:
 	Upon successful completion, the scanw, mvscanw, mvwscanw and
 	wscanw functions return the number of items successfully
 	matched.  On end-of-file, they return EOF.  Otherwise they
 	return ERR.

  PDCurses Errors:
 	No errors.

  Portability:
 	PDCurses	int mvscanw( int y, int x, char *fmt, ...);
 	X/Open Dec '88	int mvscanw( int y, int x, char *fmt, ...);
 	BSD Curses	int mvscanw( int y, int x, char *fmt, ...);
 	SYS V Curses	int mvscanw( int y, int x, char *fmt, ...);

**man-end**********************************************************************/

int	mvscanw(int y, int x, char *fmt, ... )
{
	va_list args;
	int	retval = ERR;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("mvscanw() - called\n");
#endif

#if	!defined (HC)
	if (stdscr == (WINDOW *)NULL)
		return( retval );

	if (wmove(stdscr, y, x) == ERR)
		return( retval );

	wrefresh(stdscr);			/* set cursor position */

	/*
	 * get string
	 */
	c_printscanbuf[0] = '\0';  /* reset to empty string */
	if (wgetstr(stdscr, c_printscanbuf) == ERR)
		return( retval );
	va_start(args, fmt);
#ifdef NO_VSSCANF
	retval = PDC_vsscanf(c_printscanbuf, fmt, args);
#else
	retval = vsscanf(c_printscanbuf, fmt, args);
#endif
	va_end(args);
#endif
	return( retval );
}
