#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	overwrite

#ifdef PDCDEBUG
char *rcsid_overwrit = "$Header: C:\CURSES\portable\RCS\overwrit.c 2.1 1993/06/18 20:19:18 MH Rel MH $";
#endif




/*man-start*********************************************************************

  overwrite()	- Overwrite windows

  X/Open Description:	overlay() and overwrite()
 	These functions overlay src_w on top of dst_w; that is,
 	all text in src_w is copied into dst_w. The windows
 	src_w and dst_w are not required to be the same size. The
 	copy starts at (0, 0) on each window. The difference between
 	the two functions is that overlay() is non-destructive
 	(blanks are not copied) while overwrite() is destructive
 	(blanks are copied).

  PDCurses Description:
 	The above description is misleading in the actual behaviour
 	exhibited by both SysV and BSD curses. The above implies that
 	the character in 0,0 of the source window is copied to 0,0 of
 	the destination window. What actually happens is that those
 	characters in the source window that intersect with characters
 	in the destination window RELATIVE TO ABSOLUTE 0,0 ON THE SCREEN, 
 	are copied to the destination window so that the characters appear 
 	in the same physical position on the screen.

 	Thanks to Andreas Otte (venn@uni-paderborn.de) for the correction
 	and code changes.

  X/Open Return Value:
 	The overwrite() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer.

  Portability:
 	PDCurses	int	overwrite( WINDOW* src_w, WINDOW* dst_w );
 	X/Open Dec '88	int	overwrite( WINDOW* src_w, WINDOW* dst_w );
 	BSD Curses	int	overwrite( WINDOW* src_w, WINDOW* dst_w );
 	SYS V Curses	int	overwrite( WINDOW* src_w, WINDOW* dst_w );

**man-end**********************************************************************/

int	overwrite(WINDOW *src_w, WINDOW *dst_w)
{
	int	last_line;
	int	last_col;
	int	first_line;
	int	first_col;
	int	src_start_x;
	int	src_start_y;
	int	dst_start_x;
	int	dst_start_y;
	int	xdiff;
	int	ydiff;
	int	rc;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("overwrit() - called\n");
#endif

	if (src_w == (WINDOW *)NULL)	return( ERR );
	if (dst_w == (WINDOW *)NULL)	return( ERR );

	first_col  = max(dst_w->_begx,src_w->_begx);
	first_line = max(dst_w->_begy,src_w->_begy);
	last_col   = min(src_w->_begx+src_w->_maxx, dst_w->_begx+dst_w->_maxx);
	last_line  = min(src_w->_begy+src_w->_maxy, dst_w->_begy+dst_w->_maxy);

/* determine the overlapping region of the two windows in real coordinates */
	if ((last_col < first_col) || (last_line < first_line))
    return(OK);  /* if no overlapping region, do nothing */

/* size of overlapping region */
	xdiff = last_col - first_col;
	ydiff = last_line - first_line;

	if (src_w->_begx <= dst_w->_begx)
		{
		src_start_x = dst_w->_begx - src_w->_begx;
		dst_start_x = 0;
		}
	else
		{
		dst_start_x = src_w->_begx - dst_w->_begx;
		src_start_x = 0;
		}
	if (src_w->_begy <= dst_w->_begy)
		{
		src_start_y = dst_w->_begy - src_w->_begy;
		dst_start_y = 0;
		}
	else
		{
		dst_start_y = src_w->_begy - dst_w->_begy;
		src_start_y = 0;
		}

	rc = PDC_copy_win(src_w,dst_w,src_start_y,src_start_x,
		src_start_y+ydiff,src_start_x+xdiff,dst_start_y,dst_start_x,
		dst_start_y+ydiff,dst_start_x+xdiff,FALSE);

	return( rc );
}
