#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wclear

#ifdef PDCDEBUG
char *rcsid_wclear = "$Header: C:\CURSES\portable\RCS\wclear.c 2.1 1993/06/18 20:21:35 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wclear()	- Clear window

  X/Open Description:	clear() and wclear()
 	These functions are like erase(), but they also call clearok(),
 	arranging that the screen will be cleared completely on the
 	next call to wrefresh() for that window and repainted.

 	NOTE: clear() is a macro.

  PDCurses Description:
 	There is no additional PDCurses functionality.  This module is
 	a documentation place holder.  No code will execute in this module
 	unless the user #undefs wclear.

  X/Open Return Value:
 	The wclear() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wclear( WINDOW* win );
 	X/Open Dec '88	int wclear( WINDOW* win );
 	BSD Curses	int wclear( WINDOW* win );
 	SYS V Curses	int wclear( WINDOW* win );

**man-end**********************************************************************/

int	wclear( WINDOW *win )
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wclear() - called\n");
#endif

	if  (win == (WINDOW *)NULL)
		return( ERR );

	clearok( win, TRUE );
	return( werase( win ) );
}
