#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__copywin = "$Header: C:\CURSES\private\RCS\_copywin.c 2.1 1993/06/18 20:22:57 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_copy_win()	- Common routine for copywin(), overlay() and overwrite()
 	functions.

  PDCurses Description:
 	This function copies the region of the source window specified
 	over the specified region of the destination window. All validation
 	of limits are done by the calling function.

 	Thanks to Andreas Otte (venn@uni-paderborn.de) for the code changes.

  PDCurses Errors:
 	ERR is returned if either src or dst windows are NULL;

  Portability:
 	PDCurses	int	PDC_copy_win( WINDOW* src_w, WINDOW* dst_w
 			int src_tr,int src_tc,int src_br,int src_bc,
 			int dst_tr,int dst_tc,int dst_br,int dst_bc,bool overlay);

**man-end**********************************************************************/

int	PDC_copy_win(WINDOW *src_w, WINDOW *dst_w,
 			int src_tr,int src_tc,int src_br,int src_bc,
 			int dst_tr,int dst_tc,int dst_br,int dst_bc,bool overlay)
{
	int*	minchng;
	int*	maxchng;
	chtype*	w1ptr;
	chtype*	w2ptr;
	int	col;
	int	line;
	int	xdiff = src_bc - src_tc;
	int	ydiff = src_br - src_tr;
	int	y1;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_copy_win() - called\n");
#endif

	if (src_w == (WINDOW *)NULL)	return( ERR );
	if (dst_w == (WINDOW *)NULL)	return( ERR );

	minchng    = dst_w->_firstch;
	maxchng    = dst_w->_lastch;


	for (y1 = 0; y1 < dst_tr; y1++)
		{
		minchng++;
		maxchng++;
		}

	for (line = 0; line < ydiff; line++)
	{
		register int fc;
		register int lc;

		w1ptr = src_w->_y[line+src_tr]+src_tc;
		w2ptr = dst_w->_y[line+dst_tr]+dst_tc;
		fc    = _NO_CHANGE;

		for (col = 0; col < xdiff; col++)
		{
			if ((*w1ptr) != (*w2ptr)
			&&  !((*w1ptr & A_CHARTEXT) == src_w->_blank && overlay))
			{
				*w2ptr = *w1ptr;
				if (fc == _NO_CHANGE)
				{
					fc = col+dst_tc;
				}
				lc = col+dst_tc;
			}
			w1ptr++;
			w2ptr++;
		}

		if (*minchng == _NO_CHANGE)
		{
			*minchng = fc;
			*maxchng = lc;
		}
		else	if (fc != _NO_CHANGE)
		{
			if (fc < *minchng)	*minchng = fc;
			if (lc > *maxchng)	*maxchng = lc;
		}
		minchng++;
		maxchng++;
	}
	return( OK );
}
