#ifdef PDCDEBUG
char *rcsid__memmove = "$Header: C:\CURSES\private\RCS\_memmove.c 2.1 1993/06/18 20:22:29 MH Rel MH $";
#endif
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*man-start*********************************************************************

  PDC_memmove()	- Replacement memmove() for lacking compliers.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Move a portion of memory taking consideration of overlapping memory
 	areas.

  PDCurses Return Value:
 	This function returns NULL if no temporary memory could be allocated.

  Portability:
 	PDCurses	int PDC_memmove(void *s1,const void *s2,size_t n);

**man-end**********************************************************************/


void *PDC_memmove (void *s1, const void *s2, size_t n)
{
  char *dd;
  const char *ss;

  dd = (char *)s1;
  ss = (const char *)s2;
  if (dd > ss && dd < ss + n)
    {
      dd += n;
      ss += n;
      while (n--)
        *--dd = *--ss;
    }
  else
    while (n--)
      *dd++ = *ss++;
  return s1;
}
