#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif

#ifdef PDCDEBUG
char *rcsid__queryad = "$Header: C:\CURSES\private\RCS\_queryad.c 2.1 1993/06/18 20:22:33 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_query_adapter_type()	- Determine PC video adapter type

  PDCurses Description:
 	This is a private PDCurses routine.

 	Thanks to Jeff Duntemann, K16RA for providing the impetus
 	(through the Dr. Dobbs Journal, March 1989 issue) for getting
 	the routines below merged into Bjorn Larsson's PDCurses 1.3...
 		-- frotz@dri.com	900730

  PDCurses Return Value:
 	This function returns a macro identifier indicating the adapter
 	type.  See the list of adapter types in PRIVATE/CURSPRIV.H.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_query_adapter_type( void );

**man-end**********************************************************************/

#ifdef     OS2
VIOCONFIGINFO	PDC_query_adapter_type(void)
#else
int	PDC_query_adapter_type(void)
#endif
{
	int	retval = _NONE;

#ifdef	DOS
	int	equip;
	struct SREGS segs;
	short video_base = getdosmemword (0x463);
#endif

#ifdef	OS2
	VIOCONFIGINFO configInfo;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_query_adapter_type() - called\n");
#endif

#ifdef	FLEXOS
	return (_FLEXOS);
#endif

#ifdef	DOS
	/*
	 * Attempt to call VGA Identify Adapter Function...
	 */
	regs.h.ah = 0x1a;
	regs.h.al = 0;
	int86(0x10, &regs, &regs);
	if ((regs.h.al == 0x1a) && (retval == _NONE))
	{
		/*
		 * We know that the PS/2 video BIOS is alive and well.
		 */
		switch (regs.h.al)
		{
		case 0:
			retval = _NONE;
			break;
		case 1:
			retval = _MDA;
			break;
		case 2:
			retval = _CGA;
			break;
		case 4:
			retval = _EGACOLOR;
			_cursvar.sizeable = TRUE;
			break;
		case 5:
			retval = _EGAMONO;
			break;
		case 26:
			retval = _VGACOLOR;	/* ...alt. VGA BIOS... */
		case 7:
			retval = _VGACOLOR;
			_cursvar.sizeable = TRUE;
			break;
		case 8:
			retval = _VGAMONO;
			break;
		case 10:
		case 13:
			retval = _MCGACOLOR;
			break;
		case 12:
			retval = _MCGAMONO;
			break;
		default:
			retval = _CGA;
			break;
		}
	}
	else
	{
		/*
		 * No VGA BIOS, check for an EGA BIOS by selecting an
		 * Alternate Function Service...
		 *
		 * bx == 0x0010	 -->  return EGA information
		 */
		regs.h.ah = 0x12;
		regs.x.bx = 0x10;
		int86(0x10, &regs, &regs);
		if ((regs.h.bl != 0x10) && (retval == _NONE))
		{
			/*
			 * An EGA BIOS exists...
			 */
			regs.h.ah = 0x12;
			regs.h.bl = 0x10;
			int86(0x10, &regs, &regs);
			if (regs.h.bh == 0)
				retval = _EGACOLOR;
			else
				retval = _EGAMONO;
		}
		else
		if (retval == _NONE)
		{
			/*
			 * Now we know we only have CGA or MDA...
			 */
			int86(0x11, &regs, &regs);
			equip = (regs.h.al & 0x30) >> 4;
			switch (equip)
			{
			case 1:
			case 2:
				retval = _CGA;
				break;
			case 3:
				retval = _MDA;
				break;
			default:
				retval = _NONE;
				break;
			}
		}
	}
	if (video_base == 0x3d4)
	{
		_cursvar.video_seg = 0xb800;
		switch (retval)
		{
		case _EGAMONO:
			retval = _EGACOLOR;
			break;
		case _VGAMONO:
			retval = _VGACOLOR;
			break;
		default:
			break;
		}
	}
	if (video_base == 0x3b4)
	{
		_cursvar.video_seg = 0xb000;
		switch (retval)
		{
		case _EGACOLOR:
			retval = _EGAMONO;
			break;
		case _VGACOLOR:
			retval = _VGAMONO;
			break;
		default:
			break;
		}
	}
	if ((retval == _NONE)
#ifndef CGA_DIRECT
	||  (retval == _CGA)
#endif
	)
	{
		_cursvar.direct_video = FALSE;
	}
	if ((unsigned int) _cursvar.video_seg == 0xb000)
		_cursvar.mono = TRUE;
	else
		_cursvar.mono = FALSE;

	regs.h.ah = 0xfe;		/* Check for DESQview shadow buffer */
	regs.h.al = 0;
	regs.x.di = _cursvar.video_ofs;
	segs.es   = _cursvar.video_seg;
	int86x(0x10, &regs, &regs, &segs);
	_cursvar.video_ofs = regs.x.di;
	_cursvar.video_seg = segs.es;

	if  (!_cursvar.adapter)
		_cursvar.adapter = retval;
	return (PDC_sanity_check(retval));
#endif

#ifdef	OS2
	VioGetConfig(0, &configInfo, 0);
	_cursvar.sizeable = TRUE;
        return configInfo;
#  if     0
	switch (configInfo.adapter)
	{
		case 0:
			retval = _MDA;
			_cursvar.mono =TRUE;
			break;
		case 1:
			retval = _CGA;
			_cursvar.mono = FALSE;
			break;
		case 2: switch (configInfo.display)
			{
				case 0:
				case 3:
					retval = _EGAMONO;
					_cursvar.mono = TRUE;
					break;
				case 1:
				case 2:
				case 4:
				case 9:
					retval = _EGACOLOR;
					_cursvar.mono = FALSE;
					break;
			}
			break;
		case 3: switch (configInfo.display)
			{
				case 0:
				case 3:
					retval = _VGAMONO;
					_cursvar.sizeable = TRUE;
					_cursvar.mono = TRUE;
					break;
				case 1:
				case 2:
				case 4:
				case 9:
					retval = _VGACOLOR;
					_cursvar.sizeable = TRUE;
					_cursvar.mono = FALSE;
					break;
			}
			break;
		default:
			retval = _CGA;
			_cursvar.mono = FALSE;
			break;
	}
	return (PDC_sanity_check(retval));
#  endif
#endif

#ifdef UNIX
	if (set_foreground != NULL && set_background != NULL) /* we have a colour monitor */
		{
		_cursvar.mono = FALSE;
		retval = _UNIX_COLOR;
		}
	else
		{
		_cursvar.mono = TRUE;
		retval = _UNIX_MONO;
		}
	_cursvar.sizeable = FALSE;
	_cursvar.bogus_adapter = FALSE;
return(retval);
#endif
}
