#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>


#ifdef PDCDEBUG
char *rcsid__xfrmlin = "$Header: C:\CURSES\private\RCS\_xfrmlin.c 2.1 1993/06/18 20:23:56 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_transform_line()	- transform

  PDCurses Description:
 	This is a private PDCurses function.

 	Updates the given physical line to look like the corresponding
 	line in _curscr.

  PDCurses Return Value:
 	This routine returns TRUE if a premature refresh end
 	is allowed, and there is an input character pending.  Otherwise,
 	FALSE is returned.

  PDCurses Errors:
 	No errors are defined for this routine.

  Portability:
 	PDCurses	bool	PDC_transform_line( int lineno );

**man-end**********************************************************************/

bool	PDC_transform_line(register int lineno)
{
#if defined (MSC) && defined (DOS)
chtype*	dstp;
chtype*	srcp;
#else
register chtype*	dstp;
register chtype*	srcp;
#endif

#ifdef DOS
#if SMALL || MEDIUM
struct SREGS segregs;
int ds;
#endif
#endif

	int rc;
	int		x;
	int		endx;
	int		len;
	chtype*	ch;
	extern unsigned	char atrtab[MAX_ATRTAB];
	chtype temp_line[256]; /* this should be enough for the maximum width of a screen. MH-920715 */
	chtype chr;
	register int j;
	WINDOW *twin=curscr;

#ifdef	FLEXOS
	char	line[80];
	char	attr[80];
	FFRAME	sframe;
	RECT	drect;
	RECT	srect;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_transform_line() - called\n");
#endif

	if (twin == (WINDOW *)NULL)
		return( FALSE );

	x = twin->_firstch[lineno];
	endx = twin->_lastch[lineno];
	dstp = curscr->_y[lineno] + x;
	srcp = twin->_y[lineno] + x;
	len = endx-x+1;

	ch = temp_line; /* now have ch pointing to area to contain real attributes. MH-920715 */

		memcpy(ch, srcp, len * sizeof(chtype));

/* replace the attribute part of the chtype with the actual colour value */
/* replacing the number that points to the actual colour value.          */
#ifndef UNIX
	for (j=0;j<len;j++)          /* for each chtype in the line... */
	   {
	    chr = temp_line[j] & A_CHARTEXT;
	    temp_line[j] = chtype_attr(temp_line[j]) | chr;
	   }
#endif

	if (_cursvar.direct_video)
	{

		memcpy(dstp, srcp, len * sizeof(chtype));

#ifdef	FLEXOS
		_split_plane(curscr, &line[0], &attr[0], lineno, x, lineno, endx);

		drect.r_row = lineno;
		drect.r_col = x;
		drect.r_nrow = 1;
		drect.r_ncol = len;

		sframe.fr_pl[0] = (UBYTE *) line;
		sframe.fr_pl[1] = (UBYTE *) attr;
		sframe.fr_nrow = 1;
		sframe.fr_ncol = len;
		sframe.fr_use = 0x03;

		srect.r_col = 0;
		srect.r_row = 0;
		srect.r_nrow = 1;
		srect.r_ncol = len;

		s_copy(0x03, 0x01L, 0L, (far unsigned short *) &drect,
			(far unsigned short *) &sframe, (far unsigned
			short *) &srect);

#endif

#ifdef	DOS
#  ifdef GO32
		dosmemput (ch, len * sizeof(chtype),
			(void *)_FAR_POINTER(_cursvar.video_seg,
			_cursvar.video_ofs + (((lineno * curscr->_maxx) + x) * sizeof(chtype))));
#  else
#    if	SMALL || MEDIUM
		segread(&segregs);
		ds = segregs.ds;
		movedata(ds,(int)ch,
			_cursvar.video_seg,
			_cursvar.video_ofs+(((lineno*curscr->_maxx)+x)*sizeof(chtype)),
		        len * sizeof(chtype));
#    else
		memcpy((void *)_FAR_POINTER(_cursvar.video_seg,
			     _cursvar.video_ofs + (((lineno * curscr->_maxx) + x) * sizeof(chtype))),
		       ch, len * sizeof(chtype));
#    endif
#  endif
#endif

#ifdef	OS2
					VioWrtCellStr ((PCH)ch, (USHORT)(len*sizeof(chtype)), (USHORT)lineno, (USHORT)x, 0);
#endif
	}
	else
	{

#ifdef UNIX
		PDC_gotoxy(lineno,x);
		for (; x <= endx; x++)
		{
			PDC_putc( (*ch & A_CHARTEXT),(*ch & A_ATTRIBUTES) );
			ch++;
		}
#else
		for (; x <= endx; x++)
		{
			PDC_gotoxy(lineno, x);
			PDC_putc( (*ch & A_CHARTEXT),(*ch & A_ATTRIBUTES) >> 8 );
			ch++;
		}
#endif
	}
	twin->_firstch[lineno] = _NO_CHANGE;
	twin->_lastch[lineno] = _NO_CHANGE;

	if (_cursvar.refrbrk && PDC_check_bios_key())
		return(TRUE);
	 else
		return(FALSE);
}
