WITH Ada.Text_IO; 
WITH Ada.Integer_Text_IO;
PROCEDURE Coin_Collection IS
------------------------------------------------------------------
--|                                                              
--| Finds the value of a coin collection,
--| given pennies and nickels
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
  Pennies    : Natural;           -- input - number of pennies
  Nickels    : Natural;           -- input - number of nickels
  Dollars    : Natural;           -- output - value in dollars
  Cents      : Natural;           -- output - value in cents
  TotalCents : Natural;

BEGIN -- Coin_Collection

  -- prompt user for number of nickels and pennies
  Ada.Text_IO.Put (Item => "How many nickels do you have? ");
  Ada.Integer_Text_IO.Get (Item => Nickels);  
  Ada.Text_IO.Put (Item => "How many pennies do you have? ");
  Ada.Integer_Text_IO.Get (Item => Pennies);  
  Ada.Text_IO.New_Line;

  -- compute total value in cents
  TotalCents := 5 * Nickels + Pennies;

  -- find the value in dollars and change
  Dollars := TotalCents / 100;
  Cents   := TotalCents REM 100;

  -- display the value in dollars and change
  Ada.Text_IO.Put (Item => "Your collection is worth ");
  Ada.Integer_Text_IO.Put (Item => Dollars, Width => 1);
  Ada.Text_IO.Put (Item => " dollars and ");  
  Ada.Integer_Text_IO.Put (Item => Cents, Width => 1);
  Ada.Text_IO.Put (" cents.");          
  Ada.Text_IO.New_Line;

END Coin_Collection;
