WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Dividend IS
------------------------------------------------------------------
--| Finds and displays the insurance dividend.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
 
  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;

  BasicRate : CONSTANT NonNegFloat := 0.045; -- basic dividend rate 4.5%
  BonusRate : CONSTANT NonNegFloat := 0.005; -- bonus dividend rate 0.5%
 
  Premium   : NonNegFloat;   -- input  - premium amount
  NumClaims : Natural;       -- input  - number of claims
  Dividend  : NonNegFloat;   -- output - dividend amount   
 
BEGIN -- Dividend   

  -- Enter Premium and NumClaims   
  Ada.Text_IO.Put (Item => "Premium amount > $");
  Ada.Float_Text_IO.Get (Item => Premium);  
  Ada.Text_IO.Put (Item => "Number of claims > ");
  Ada.Integer_Text_IO.Get (Item => NumClaims);  
  Ada.Text_IO.New_Line;
 
  -- Compute divided using bonus rate when earned
  IF NumClaims /= 0 THEN
    Dividend := Premium * BasicRate;
  ELSE
    Dividend := (Premium * BasicRate) + (Premium * BonusRate); 
  END IF;
 
  -- Display total dividend   
  Ada.Text_IO.Put (Item => "Total dividend is $");
  Ada.Float_Text_IO.Put (Item => Dividend, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;

  IF NumClaims = 0 THEN
    Ada.Text_IO.Put(Item => "This includes a bonus dividend for zero claims!");
    Ada.Text_IO.New_Line;
  END IF;

END Dividend;
