WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Metric_Conversion IS

------------------------------------------------------------------
--|                                                              
--| Converts square meters to square yards
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
 
  MetersToYards : CONSTANT Float := 1.196; -- conversion constant
  SquareMeters  : Float;                   -- input - metric fabric size
  SquareYards   : Float;                   -- output - US fabric size
 
BEGIN -- Metric_Conversion

  -- Read the fabric size in square meters
  Ada.Text_IO.Put (Item => "Enter the fabric size in square meters > ");
  Ada.Float_Text_IO.Get (Item => SquareMeters);
 
  -- Convert the fabric size to square yards
  SquareYards := MetersToYards * SquareMeters;
 
  -- Display the fabric size in square yards 
  Ada.Text_IO.Put (Item => "The fabric size in square yards is ");
  Ada.Float_Text_IO.Put (Item => SquareYards); 
  Ada.Text_IO.New_Line;

END Metric_Conversion;
