WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Numerics.Discrete_Random;
PROCEDURE Random_Numbers IS
------------------------------------------------------------------
--| Generates 120 random integers in the range 1..50
--| Uses the random number generator from Ada.Numerics
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995
------------------------------------------------------------------

  SUBTYPE RandomRange IS Positive RANGE 1..50;

  PACKAGE Random_50 IS NEW Ada.Numerics.Discrete_Random
    (Result_Subtype => RandomRange);

  G: Random_50.Generator;     -- funny variable; we must keep 
                              -- passing it to Random, but can't use it.

BEGIN -- Random_Numbers

  Random_50.Reset (Gen => G);  -- starts G from time of day clock

  FOR Row IN 1..10 LOOP        -- displays 10 rows of 12 numbers

    FOR Num IN 1..12 LOOP

      Ada.Integer_Text_IO.Put
        (Item => Random_50.Random(Gen => G), Width => 4);

    END LOOP;

    Ada.Text_IO.New_Line;

  END LOOP;

END Random_Numbers;
