WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PACKAGE BODY Robust_Input IS
------------------------------------------------------------------
--| Body of package for robust numeric input handling
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  PROCEDURE Get (Item : OUT Integer; 
                 MinVal : IN Integer; 
                 MaxVal : IN Integer) IS
       
    SUBTYPE TempType IS Integer RANGE MinVal..MaxVal;
    TempItem : TempType;     -- temporary copy of MinVal   

  BEGIN -- Get
            
    LOOP
      BEGIN      -- exception handler block
        Ada.Text_IO.Put(Item => "Enter an integer between ");
        Ada.Integer_Text_IO.Put(Item => MinVal, Width => 0);  
        Ada.Text_IO.Put(Item => " and ");
        Ada.Integer_Text_IO.Put(Item => MaxVal, Width => 0);  
        Ada.Text_IO.Put(Item => " > ");
        Ada.Integer_Text_IO.Get(Item => TempItem);
        Item := TempItem;
        EXIT;    -- valid data
      EXCEPTION  -- invalid data
        WHEN Constraint_Error =>
          Ada.Text_IO.Put 
            (Item => "Value entered is out of range. Please try again.");
          Ada.Text_IO.New_Line;
          Ada.Text_IO.Skip_Line;
        WHEN Ada.Text_IO.Data_Error =>
          Ada.Text_IO.Put 
            (Item => "Value entered not an integer. Please try again.");
          Ada.Text_IO.New_Line;
          Ada.Text_IO.Skip_Line;
      END;       -- exception handler block
    END LOOP;
    -- assert: Item is in the range MinVal to MaxVal   

  END Get;

  PROCEDURE Get (Item : OUT Float; 
                 MinVal : IN Float; 
                 MaxVal : IN Float) IS

    SUBTYPE TempType IS Float RANGE MinVal..MaxVal;
    TempItem : TempType;     -- temporary copy of MinVal   

  BEGIN -- Get
            
    LOOP
      BEGIN       -- exception handler block
        Ada.Text_IO.Put(Item => "Enter a floating-point value between ");
        Ada.Float_Text_IO.Put(Item => MinVal, Fore=> 1, Aft => 2, Exp => 0);  
        Ada.Text_IO.Put(Item => " and ");
        Ada.Float_Text_IO.Put(Item => MaxVal, Fore=> 1, Aft => 2, Exp => 0);  
        Ada.Text_IO.Put(Item => " > ");
        Ada.Float_Text_IO.Get(Item => TempItem);
        Item := TempItem;
        EXIT;     -- valid data
      EXCEPTION   -- invalid data
        WHEN Constraint_Error =>
          Ada.Text_IO.Put 
            (Item => "Value entered is out of range. Please try again.");
          Ada.Text_IO.New_Line;
          Ada.Text_IO.Skip_Line;
        WHEN Ada.Text_IO.Data_Error =>
          Ada.Text_IO.Put 
            (Item => "Value entered not floating point. Please try again.");
          Ada.Text_IO.New_Line;
          Ada.Text_IO.Skip_Line;
      END;        -- exception handler block
    END LOOP;
    -- assert: Item is in the range MinVal to MaxVal   

  END Get;

END Robust_Input;
